package com.bcxin.ars.model.sb;

import com.bcxin.ars.model.BaseModel;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;


/**
 * 资格证/等级证学习记录对象
 *
 * @table cer_learn_record
 * @author lin
 * @date 2020-09-08
 */
@Data
public class CerLearnRecord extends BaseModel{

    private static final long serialVersionUID=1L;

                                
    /**
     * 姓名
     */
    private String name;
        
    /**
     * 身份证号
     */
    private String idNum;
        
    /**
     * 手机号
     */
    private String phone;
        
    /**
     * 人员id
     */
    private Long perId;
        
    /**
     * 公司id
     */
    private Long comId;
        
    /**
     * 现职企业
     */
    private String comName;
        
    /**
     * 所学课程名称
     */
    private String courseName;
        
    /**
     * 记录进度
     */
    private String progress;
        
    /**
     * 记录时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date recordTime;
        
    /**
     * 记录地点
     */
    private String address;
        
    /**
     * 自拍照片
     */
    private String photo;

    /**
     * 记录类型 01 资格证 03 等级证
     */
    private String recordType;

    /**
     * 培训机构id
     */
    private  Long trainId;
    /**
     * 培训机构名称
     */
    private  String  trainName;

    @Override
    public boolean equals(Object o){
        return super.equals(o);
    }

    @Override
    public int hashCode(){
        return super.hashCode();
    }

}
