package com.bcxin.ars.model;

import com.bcxin.ars.serializer.LongJsonDeserializer;
import com.bcxin.ars.serializer.LongJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import java.util.List;

/**
 * 
 * <b>保安员工作经验 </b>
 * 
 * @author LinQingLin
 * @date 2017年10月9日 下午2:23:57
 * @注意事项 </b>
 * <b>
 */
@Data
public class SecurityPersonExperience extends BaseModel {

	/**  */
	private static final long serialVersionUID = 1L;

	/**  
	 *保安员id
	**/
	@JsonSerialize(using = LongJsonSerializer.class)
	@JsonDeserialize(using = LongJsonDeserializer.class)
	private Long personId;
	
	/**  
	 *公司名称
	**/
	private String companyName;
	
	/**  
	 *公司地址
	**/
	private String companyAddress;
	
	/**  
	 *职务
	**/
	private String post;
	
	/**  
	 *部门
	**/
	private String department;
	
	/**  
	 *工作内容
	**/
	private String workContent;
	
	/**  
	 *任职开始时间
	**/
	private String startDate;
	
	/**  
	 *任职结束时间
	**/
	private String endDate;

	/**
	 * 系统生成的不能删除
	 */
	private boolean canDel;
	
	/**
	 * 身份证号
	 */
	private String idNum;
	
	/**
	 * 所属公司id
	 */
	private Long companyId;
	
	/**
	 * 所属部门id
	 */
	private Long orgId;


	/**
	 * 处罚
	 */
	private List<SbPunish> punishList;

	/**
	 * 奖励
	 */
	private List<SbReward> rewardList;

	/**
	 * 好人好事
	 */
	private List<SecurityGoodThing> goodThingList;
}
