package com.bcxin.ars.model;

import lombok.Data;


/**
 * 北京保安从业单位和从业人员情况年度调查对象
 *
 * @table annual_survey_report
 * @author lin
 * @date 2020-11-20
 */
@Data
public class AnnualSurveyReport extends BaseModel{

    private static final long serialVersionUID=1L;

                                
    /**
     * 公安机构id
     */
    private Long orgId;
        
    /**
     * 操作者id
     */
    private Long userId;
        
    /**
     * 公司id
     */
    private Long comId;
        
    /**
     * 年度
     */
    private String fillYear;

    /**
     * 公司名称
     */
    private String comName;

    /**
     * 填写人
     */
    private String realName;
        
    /**
     * 联系电话
     */
    private String phone;
        
    /**
     * 客户数量
     */
    private Integer custNum;
        
    /**
     * 固定资产(万元)
     */
    private String fixedAssets;
        
    /**
     * 年营业额(万元)
     */
    private String annualTurnover;
        
    /**
     * 年利税(万元)
     */
    private String annualProfitTax;
        
    /**
     * 橡胶棍(个)
     */
    private Integer rubberNum;
        
    /**
     * 防弹背心(件)
     */
    private Integer vestNum;
        
    /**
     * 警告(起)
     */
    private Integer warnrNum;
        
    /**
     * 罚款(万元)
     */
    private String fine;
        
    /**
     * 没收非法所得(万元)
     */
    private String income;
        
    /**
     * 吊销许可证(起)
     */
    private Integer revokeLiceNum;
        
    /**
     * 追究刑事责任(起)
     */
    private Integer criminalNum;
        
    /**
     * 其他(起)
     */
    private Integer crimeOther;
        
    /**
     * 保安员(人)
     */
    private Integer perNum;
        
    /**
     * 女保安员(人)
     */
    private Integer fePerNum;
        
    /**
     * 持有保安员证(人)
     */
    private Integer cerNum;
        
    /**
     * 企业管理人员(人)
     */
    private Integer manageNum;
        
    /**
     * 提供破案线索(条)
     */
    private Integer caseClueNum;
        
    /**
     * 抓获嫌疑人(人)
     */
    private Integer captureNum;
        
    /**
     * 预防灾害事故(起)
     */
    private Integer preventNum;
        
    /**
     * 挽回经济损失(万元)
     */
    private String retrieve;
        
    /**
     * 参加大型商贸文体展览活动(次数)
     */
    private Integer eventNum;
        
    /**
     * 参加大型商贸文体展览活动(人数)
     */
    private Integer eventPerNum;
        
    /**
     * 参加群体性事件处置工作(次数)
     */
    private Integer handleNum;
        
    /**
     * 参加群体性事件处置工作(人数)
     */
    private Integer handlePerNum;
        
    /**
     * 见义勇为(人)
     */
    private Integer cudgelsNum;
        
    /**
     * 因公负伤(人)
     */
    private Integer injuriesNum;
        
    /**
     * 因公牺牲(人)
     */
    private Integer sacrificeNum;
        
    /**
     * 全国先进集体(个)
     */
    private Integer nationalAdCollNum;
        
    /**
     * 省级先进集体(个)
     */
    private Integer ProvAdCollNum;
        
    /**
     * 全国先进个人(人)
     */
    private Integer nationalAdindiNum;
        
    /**
     * 省级先进个人(人)
     */
    private Integer ProvAdindiNum;
        
    /**
     * 吊销保安员证(人)
     */
    private Integer revokeCerNum;
        
    /**
     * 治安管理处罚(人)
     */
    private Integer punishNum;
        
    /**
     * 追究刑事责任(人)
     */
    private Integer criminalPerNum;
        
    /**
     * 合计（期次）
     */
    private Integer beTotalNum;
        
    /**
     * 合计（人数）
     */
    private Integer beTotalPerNum;
        
    /**
     * 全日制大中专院校（期次）
     */
    private Integer beCollegeNum;
        
    /**
     * 全日制大中专院校（人数）
     */
    private Integer beCollegePerNum;
        
    /**
     * 民办大中专院校（期次）
     */
    private Integer bePrivateNum;
        
    /**
     * 民办大中专院校（人数）
     */
    private Integer bePrivatePerNum;
        
    /**
     * 职业技术学校（期次）
     */
    private Integer beVocationalNum;
        
    /**
     * 职业技术学校（人数）
     */
    private Integer beVocationalPerNum;
        
    /**
     * 武术学校（期次）
     */
    private Integer beMartialNum;
        
    /**
     * 武术学校（人数）
     */
    private Integer beMartialPerNum;
        
    /**
     * 保安培训学校（期次）
     */
    private Integer beTrainNum;
        
    /**
     * 保安培训学校（人数）
     */
    private Integer beTrainPerNum;
        
    /**
     * 保安公司自办培训机构（期次）
     */
    private Integer beSelfNum;
        
    /**
     * 保安公司自办培训机构（人数）
     */
    private Integer beSelfPerNum;
        
    /**
     * 其他（期次）
     */
    private Integer beOther;
        
    /**
     * 其他（人数）
     */
    private Integer beOtherPer;
        
    /**
     * 合计（期次）
     */
    private Integer onTotalNum;
        
    /**
     * 合计（人数）
     */
    private Integer onTotalPerNum;
        
    /**
     * 全日制大中专院校（期次）
     */
    private Integer onCollegeNum;
        
    /**
     * 全日制大中专院校（人数）
     */
    private Integer onCollegePerNum;
        
    /**
     * 民办大中专院校（期次）
     */
    private Integer onPrivateNum;
        
    /**
     * 民办大中专院校（人数）
     */
    private Integer onPrivatePerNum;
        
    /**
     * 职业技术学校（期次）
     */
    private Integer onVocationalNum;
        
    /**
     * 职业技术学校（人数）
     */
    private Integer onVocationalPerNum;
        
    /**
     * 武术学校（期次）
     */
    private Integer onMartialNum;
        
    /**
     * 武术学校（人数）
     */
    private Integer onMartialPerNum;
        
    /**
     * 保安培训学校（期次）
     */
    private Integer onTrainNum;
        
    /**
     * 保安培训学校（人数）
     */
    private Integer onTrainPerNum;
        
    /**
     * 保安公司自办培训机构（期次）
     */
    private Integer onSelfNum;
        
    /**
     * 保安公司自办培训机构（人数）
     */
    private Integer onSelfPerNum;
        
    /**
     * 其他（期次）
     */
    private Integer onOther;
        
    /**
     * 其他（人数）
     */
    private Integer onOtherPer;
        
    /**
     * 保安培训学校职业技能鉴定合计（个）
     */
    private Integer appraiseTotal;
        
    /**
     * 保安培训学校初级保安员证(个)
     */
    private Integer primaryNum;
        
    /**
     * 保安培训学校中级保安员证(个)
     */
    private Integer middleNum;
        
    /**
     * 保安培训学校保安管理师证(个)
     */
    private Integer adminNum;
    
    @Override
    public boolean equals(Object o){
        return super.equals(o);
    }

    @Override
    public int hashCode(){
        return super.hashCode();
    }

}
