package com.bcxin.ars.export;

import com.bcxin.ars.enums.SignType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

/**
 * 缴费状态导出where条件策略
 *
 * @author zhangyutong
 */
public class FeeStateExportWhereStrategy implements ExportWhereStrategy {
    private static final Logger logger = LoggerFactory.getLogger(FeeStateExportWhereStrategy.class);

    @Override
    public String spliceWhereStr(SignType signType, Map<String, String> columnMap, Map<Object, Object> searchParams, Object key) {

        String feeState = (String) key;
        String whereStr = " and ";
        //字段名
        String column = columnMap.get(feeState);
        //表单查询字段值
        String value = (String) searchParams.get(feeState);
        whereStr = whereStr + " if(ifnull(fee_state,'0')='','0',ifnull(fee_state,'0'))="+value;

        return whereStr;
    }
}
