package com.bcxin.ars.dto.page.task;

import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.task.ComTaskDto;
import lombok.Data;

import java.util.Date;

/**
 * @author linqinglin
 * @date 2019/10/11 0011 11:05
 */
@Data
public class ComTaskSearchDto extends SearchDto<ComTaskDto> {

    private String taskName;

    private String taskStationType;
    /**
     * 驻勤状态
     */
    private String taskStatus;
    private String taskStatusNew;

    private String comName;

    private String serviceObject;

    private String taskAddress;

    private String startDate;

    private String endDate;

    private Long comId;
    /**
     * 合同状态
     */
    private String contractStatus;
    /***
     * 驻勤点监管机构
     */
     private String orgIdTask;
    /**
     * 公司监管机构
     */
    private String orgIdCom;

    /**
     * 公司数据区域
     */
    private String comAreaCode;

    /**
     * 驻勤点数据区域
     */
    private String taskAreaCode;

    /**
     * 驻勤开始时间
     */
    private Date taskStartDate;
    /**
     * 驻勤结束时间
     */
    private Date taskEndDate;

    protected Integer pageNumber;//页数
    protected Integer pageSize;//每页显示几条

    @Override
    public Integer getStart() {
        return (this.pageNumber == null ? 0:(this.pageNumber-1)) * (this.pageSize == null ? 0:this.pageSize);
    }
}
