package com.bcxin.ars.dto.export;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.enums.SignType;
import com.bcxin.ars.model.BaseModel;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.sys.Approval;
import lombok.Data;

import java.util.Date;
import java.util.List;


/**
 * sb_traincompanyapply
 */
@Data
public class TraincompanyapplyExportDTO extends BaseModel {

    /**  */
	private static final long serialVersionUID = -1353450017808828069L;

	/**
     * 单位名称
     */
    @ModelAnnotation(getName="公司名称",column = "companyname",isExport = true,defaultColumn=true)
    private String companyname;
    /**
     * 提交时间（审批表）
     */
    @ModelAnnotation(getName="提交时间",column = "create_time",isExport = true,defaultColumn=true,anotherTable=true)
    private Date createTime;
    /**
     * 保安培训机构名称
     */
    @ModelAnnotation(getName="保安培训机构名称",column = "traincompanyname",isExport = true)
    private String traincompanyname;
    /**
     * （保安培训机构）法人姓名
     */
    @ModelAnnotation(getName="法人",column = "trainlegalname",isExport = true,defaultColumn=true)
    private String trainlegalname;

    /**
     * （保安培训机构）身份证
     */
    @ModelAnnotation(getName=" 身份证",column = "traincreditcode",isExport = true)
    private String traincreditcode;

    /**
     * (保安培训机构)手机号
     */
    @ModelAnnotation(getName=" 手机号",column = "trainphone",isExport = true,defaultColumn=true)
    private String trainphone;

    /**
     * 审批状态
     */
    @ModelAnnotation(getName="审批状态",column = "approvalstate",defaultColumn = true,isExport = true,needTranslate = true,dictName = "approvalState")
    private String approvalstate;
    /**
     * 下一个审批人（审批表）
     */
    @ModelAnnotation(getName="下一个审批人",column = "nextPerson",defaultColumn = true,isExport = true,anotherTable = true)
    private String nextPerson;
    /**
     * 公司用房面积
     */
    @ModelAnnotation(getName="公司用房面积",column = "company_house_area",isExport = true)
    private String companyHoseArea;

    /**
     * 地址
     */
    @ModelAnnotation(getName="地址",column = "address",isExport = true)
    private String address;

    /**
     * 姓名
     */
    @ModelAnnotation(getName="姓名",column = "name",isExport = true)
    private String name;

    /**
     * 拟任职务
     */
    @ModelAnnotation(getName="拟任职务",column = "post",isExport = true)
    private String post;

    /**
     * 性别
     */
    @ModelAnnotation(getName="性别",column = "sex",isExport = true,needTranslate = true,dictName = "sex")
    private String sex;

    /**
     * 民族
     */
    @ModelAnnotation(getName="民族",column = "Nation",isExport = true)
    private String nation;

    /**
     * 出生年月
     */
    @ModelAnnotation(getName="出生年月",column = "birth",isExport = true)
    private Date birth;

    /**
     * 政治面貌
     */
    @ModelAnnotation(getName="政治面貌",column = "politics",isExport = true)
    private String politics;

    /**
     * 文化程度
     */
    @ModelAnnotation(getName="文化程度",column = "culture",isExport = true)
    private String culture;

    /**
     * 联系电话
     */
    @ModelAnnotation(getName="联系电话",column = "phone",isExport = true)
    private String phone;

    /**
     * 籍贯
     */
    @ModelAnnotation(getName="籍贯",column = "place",isExport = true)
    private String place;

    /**
     * 职业资质
     */
    @ModelAnnotation(getName="职业资质",column = "qualifications",isExport = true)
    private String qualifications;

    /**
     * 技术职称
     */
    @ModelAnnotation(getName="技术职称",column = "title",isExport = true)
    private String title;

    /**
     * 用户ID
     */
    @ModelAnnotation(getName="用户ID",column = "userid",isExport = true)
    private Long userid;
    
    /**
     * 受理民警ID
     */
    @ModelAnnotation(getName="受理民警ID",column = "policeid",isExport = true)
    private Long policeid;
    

    /**
     * 审批人
     *//*
    @ModelAnnotation(getName="审批人",column = "Approvalperson",isExport = true)
    private String approvalperson;

    *//**
     * 审批时间
     *//*
    @ModelAnnotation(getName="审批时间",column = "approvaldate",isExport = true)
    private Date approvaldate;

    *//**
     * 审批原因
     *//*
    @ModelAnnotation(getName="审批原因",column = "approvalreason",isExport = true)
    private String approvalreason;*/

    /**
     * 法定代表人姓名
     */
    @ModelAnnotation(getName="法定代表人姓名",column = "legalname",isExport = true)
    private String legalname;

    /**
     * 居民身份证
     */
    @ModelAnnotation(getName="居民身份证",column = "creditcode",isExport = true)
    private String creditcode;

    /**
     * 邮政编码
     */
    @ModelAnnotation(getName="邮政编码",column = "zipcode",isExport = true)
    private String zipcode;

    /**
     * 组织机构代码
     */
    @ModelAnnotation(getName="组织机构代码",column = "organizationcode",isExport = true)
    private String organizationcode;

    /**
     * 单位性质
     */
    @ModelAnnotation(getName="单位性质",column = "companytype",isExport = true)
    private String companytype;

    /**
     * 保安服务许可证编号
     */
    @ModelAnnotation(getName="保安服务许可证编号",column = "allownumber",isExport = true)
    private String allownumber;

    /**
     * 营业执照编号
     */
    @ModelAnnotation(getName="营业执照编号",column = "businessnumber",isExport = true)
    private String businessnumber;

    /**
     * 批准机关及文号
     */
    @ModelAnnotation(getName="批准机关及文号",column = "organsallownumber",isExport = true)
    private String organsallownumber;




    /**
     * (保安培训机构)地址
     */
    @ModelAnnotation(getName="(保安培训机构)地址",column = "trainaddress",isExport = true)
    private String trainaddress;

    /**
     * （保安培训机构）邮编
     */
    @ModelAnnotation(getName=" （保安培训机构）邮编",column = "trainzipcode",isExport = true)
    private String trainzipcode;

    /**
     * 保安培训机构规模
     */
    @ModelAnnotation(getName="保安培训机构规模",column = "trainsize",isExport = true)
    private String trainsize;

    /**
     * (保安培训机构)培训内容
     */
    @ModelAnnotation(getName="(保安培训机构)培训内容",column = "traincontent",isExport = true)
    private String traincontent;

    /**
     * 压缩包地址
     */
    @ModelAnnotation(getName="压缩包地址",column = "template_rar")
    private String templateRar;

    /**
     * 审批信息
     */
    private Approval approval;

    /**
     * 审批信息列表
     */
    private List approvallist;

    /**
     * 所在地省市县（区）
     **/
    @ModelAnnotation(getName=" 所在地省市县（区）",column = "szss",isExport = true)
    private String szss;

    /**
     * 所在地省代码
     **/
    @ModelAnnotation(getName="所在地省代码",column = "province")
    private String province;

    /**
     * 所在地市代码
     **/
    @ModelAnnotation(getName="所在地市代码",column = "city")
    private String city;

    /**
     * 所在地县（区）代码
     **/
    @ModelAnnotation(getName="所在地县（区）代码",column = "district",sign = SignType.LIKE)
    private String district;

    /***
     * 现法人身份证号
     */
    @ModelAnnotation(getName="现法人身份证号",column = "legalcode",isExport = true)
    private String legalcode;

    /***
     * 现法人手机
     */
    @ModelAnnotation(getName="现法人手机",column = "legalphone",isExport = true)
    private String legalphone;

    /**
     * 审查状态 0未审查 003 审查通过 004 审查不通过
     */
    @ModelAnnotation(getName="申请单位审查状态",column = "censor_status",isExport = true,defaultColumn=true,needTranslate = true,dictName = "censorStatus")
    private String censorStatus;
    
    /**
     * 审查状态 0未审查 1 审查通过 2审查不通过
     */
    @ModelAnnotation(getName="拟设法人审查状态",column = "plan_censor_status",isExport = true,needTranslate = true,dictName = "censorStatus")
    private String planCensorStatus;

    /**
     * 资料补正告知书
     */
    @ModelAnnotation(getName="资料补正告知书",column = "info_rar")
    private String infoRar;

    /**
     * 批复意见
     * @return
     */
    @ModelAnnotation(getName="批复意见",column = "replyreason")
    private String replyreason;
    /***
     * 批复附件
     */
    @ModelAnnotation(getName="批复附件",column = "reply_rar")
    private String replyRar;
    /***
     * 批复结果
     */
    @ModelAnnotation(getName="批复结果",column = "reply_state")
    private String replyState;

    /***
     * 审批主键
     */
    private Long approvalId;
    
    /**
     * 派出所ID
     */
    @ModelAnnotation(getName="派出所ID",column = "orgid")
    private Long orgid;

    /**
     * 派出所信息
     */
    private Police police;

    /**
     *制证状态    2已制证  0未制证  1提交审核
     */
    @ModelAnnotation(getName="开始时间",column = "card_state",isExport = true)
    private String cardState;

    /**
     * 批复，上传，制证按钮的标志位，在新审批中显示，旧审批中不显示
     * 1代表旧审批  空代表新审批
     */
    private String newOldFlag;


}