package com.bcxin.ars.dto.conference;

import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.enums.SignType;
import lombok.Data;
import java.util.Date;

/**
 * 华为云录播会议返回数据
 */
@Data
public class RecordFileInfo {


    /**
     * 会议主题
     */
    @ModelAnnotation(getName="会议主题",isExport = true,column  = "subject",sign= SignType.LIKE,isGrid=true,width = "300px")
    private String subject;
    /**
     * 会议预订者
     */
    @ModelAnnotation(getName="会议预订者",isExport = true,column  = "scheduserName",sign= SignType.LIKE,isGrid=true,width = "130px")
    private String scheduserName;
    /**
     * 会议ID
     */
    @ModelAnnotation(getName="会议Id",isExport = true,column  = "confID",sign= SignType.LIKE,isGrid=true,width = "100px")
    private String confID;
    /**
     * 会议开始时间
     */
    @ModelAnnotation(getName="会议开始时间",isExport = true,column  = "startTime",sign= SignType.LIKE,isGrid=true,width = "120px")
    private String startTime;
    /**
     * 会议UUID
     */
    private String confUUID;
    /**
     *点播地址
     */
    private  String[] url;
    /**
     * 录制时长（单位秒）
     */
    @ModelAnnotation(getName="录制时长",isExport = true,column  = "rcdTime",sign= SignType.LIKE,isGrid=true,width = "120px",formatter = "formatOperationFnRcdTime")
    private Integer rcdTime;
    /**
     * 录制文件大小（MB)
     */
    @ModelAnnotation(getName="录制文件大小",isExport = true,column  = "rcdSize",sign= SignType.LIKE,isGrid=true,width = "100px",formatter = "formatOperationFnRcdSize")
    private Integer rcdSize;
    /**
     * 录制文件是否转码完成
     */
    private Boolean isDecodeFinish;
    /**
     * 录制文件预计转码完成时间
     */
    private Long decodeEndTime;

    /**
     * 录制文件预计转码完成时间
     */
    private Date decodeEndTimeFinish;
    /**
     * 录播文件是否可观看
     */
    private Boolean available;

}
