package com.bcxin.ars.dto.conference;

import lombok.Data;

import java.util.List;

@Data
public class ConferenceInfo {


    /**
     * 会议ID
     */
    private String conferenceID;


    /***
     * 会议起始时间 (YYYY-MM-DD HH:MM )。
     */
    private String startTime;

    /**
     * 会议结束时间 (YYYY-MM-DD HH:MM )。
     */
    private String endTime;

    /**
     * 会议接入码。
     */
    private String accessNumber;

    /***
     *(目前只会返回Created和Schedule状态， 如果会议已经召开返回Created状态，否则返回Schedule状态)
     * “Schedule”：预定状态。
     * “Creating”：正在创建状态。
     * “Created”：会议已经被创建，并正在召开。
     * “Destroyed”：会议已经关闭。
     */
    private String conferenceState;

    /***
     * 会议的UUID
     */
    private String confUUID;

    /***
     * 会议密码条目。预订者返回主持人密码和来宾密码。
     * 主持人查询时返回主持人密码。
     * 来宾查询时返回来宾密码。
     */
    private List<PasswordEntry> passwordEntry;

}
