package com.bcxin.ars.dto.certificate;


import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.pdf.PdfChangeDTO;
import com.bcxin.ars.enums.SignType;
import com.bcxin.ars.model.certificate.TrainCertificate;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 *保安培训公司证书搜索类
 * @author Ethan
 */
@Data
public class TrainCertificateSearchDto extends SearchDto<TrainCertificate> {

    /***
     * 发证日期查询开始时间
     */
    @ModelAnnotation(getName="发证开始时间",column  = "fzrq",sign = SignType.DATE_GREATER_EQUAL)
    private String queryStartTime;

    /***
     * 发证日期查询结束时间
     */
    @ModelAnnotation(getName="发证结束时间",column  = "fzrq",sign = SignType.DATE_LESS_EQUAL)
    private String queryEndTime;

    /**
     * 批准文号
     */
    private String pzwh;

    /**
     * 培训内容
     */
    private String pxnr;

    private String pxnr2;

    private String pxnr3;

    private String pxnr_1;
    private String pxnr_2;
    private String pxnr_3;

    /***
     * 发证日期开始时间
     */
    private String searchStartTime;
    /***
     * 发证日期结束时间
     */
    private String searchEndTime;


    /**
     * 法人名称
     */
    private String frmc;

    /**
     * 公司名称
     */
    private String gsmc;

    /**
     * 注册资本
     */
    private String zczb;

    /**
     * 发证日期
     */
    private Date fzrq;

    /**
     * 申请人
     */
    private String slr;

    /**
     * 申请人手机
     */
    private String slrsj;

    /**
     * 制证日期
     */
    private Date zzrq;

    /**
     * 许可证号
     */
    private String xkzh;

    /**
     * 保安服务公司申报ID
     */
    private Long traincompanyapplyid;

    /**
     * 公司地址
     */
    private String gsdz;

    private String gsdz2;
    private String gsdz3;

    private String gsdz_1;
    private String gsdz_2;
    private String gsdz_3;

    private String change;



    /***
     * 1申请2变更
     */
    private String applytype;


    public String getChange() {
        return change;
    }

    public void setChange(String change) {
        this.change = change;
    }

    private List<PdfChangeDTO> pdfChangeDTOList;


    public String getApplytype() {
        return applytype;
    }

    public void setApplytype(String applytype) {
        this.applytype = applytype;
    }

    public List<PdfChangeDTO> getPdfChangeDTOList() {
        return pdfChangeDTOList;
    }

    public void setPdfChangeDTOList(List<PdfChangeDTO> pdfChangeDTOList) {
        this.pdfChangeDTOList = pdfChangeDTOList;
    }

    public String getGsdz3() {
        return gsdz3;
    }

    public void setGsdz3(String gsdz3) {
        this.gsdz3 = gsdz3;
    }

    public String getGsdz_1() {
        return gsdz_1;
    }

    public void setGsdz_1(String gsdz_1) {
        this.gsdz_1 = gsdz_1;
    }

    public String getGsdz_2() {
        return gsdz_2;
    }

    public void setGsdz_2(String gsdz_2) {
        this.gsdz_2 = gsdz_2;
    }

    public String getGsdz_3() {
        return gsdz_3;
    }

    public void setGsdz_3(String gsdz_3) {
        this.gsdz_3 = gsdz_3;
    }

    /**
     * 注册资本类型
     */
    private String zczblx;

    /**
     * 发证机关编号
     */
    private String fzjgbh;

    /**
     * 发证机关名称
     */
    private String fzjgmc;

    /**
     * 法人代表类型
     */
    private String frdblx;

    /**
     * 制证状态
     */
    private String zzzt;

    private String fzrqn;
    private String fzrqy;
    private String fzrqr;

    private String project1;
    private String project2;
    private String project3;
    private String project4;

    private String content1;
    private String content2;
    private String content3;
    private String content4;

    private String time1;
    private String time2;
    private String time3;
    private String time4;

    private String cord1;
    private String cord2;
    private String cord3;
    private String cord4;
    private String cord5;

    public String getPxnr_1() {
        return pxnr_1;
    }

    public void setPxnr_1(String pxnr_1) {
        this.pxnr_1 = pxnr_1;
    }

    public String getPxnr_2() {
        return pxnr_2;
    }

    public void setPxnr_2(String pxnr_2) {
        this.pxnr_2 = pxnr_2;
    }

    public String getPxnr_3() {
        return pxnr_3;
    }

    public void setPxnr_3(String pxnr_3) {
        this.pxnr_3 = pxnr_3;
    }

    public String getPxnr2() {
        return pxnr2;
    }

    public void setPxnr2(String pxnr2) {
        this.pxnr2 = pxnr2;
    }

    public String getPxnr3() {
        return pxnr3;
    }

    public void setPxnr3(String pxnr3) {
        this.pxnr3 = pxnr3;
    }

    public String getGsdz2() {
        return gsdz2;
    }

    public void setGsdz2(String gsdz2) {
        this.gsdz2 = gsdz2;
    }

    /**
     * 打印类型  区分线上1 线下 0
     */
    private String printtype;

    public String getPrinttype() {
        return printtype;
    }

    public void setPrinttype(String printtype) {
        this.printtype = printtype;
    }

    public String getProject1() {
        return project1;
    }

    public void setProject1(String project1) {
        this.project1 = project1;
    }

    public String getProject2() {
        return project2;
    }

    public void setProject2(String project2) {
        this.project2 = project2;
    }

    public String getProject3() {
        return project3;
    }

    public void setProject3(String project3) {
        this.project3 = project3;
    }

    public String getProject4() {
        return project4;
    }

    public void setProject4(String project4) {
        this.project4 = project4;
    }

    public String getContent1() {
        return content1;
    }

    public void setContent1(String content1) {
        this.content1 = content1;
    }

    public String getContent2() {
        return content2;
    }

    public void setContent2(String content2) {
        this.content2 = content2;
    }

    public String getContent3() {
        return content3;
    }

    public void setContent3(String content3) {
        this.content3 = content3;
    }

    public String getContent4() {
        return content4;
    }

    public void setContent4(String content4) {
        this.content4 = content4;
    }

    public String getTime1() {
        return time1;
    }

    public void setTime1(String time1) {
        this.time1 = time1;
    }

    public String getTime2() {
        return time2;
    }

    public void setTime2(String time2) {
        this.time2 = time2;
    }

    public String getTime3() {
        return time3;
    }

    public void setTime3(String time3) {
        this.time3 = time3;
    }

    public String getTime4() {
        return time4;
    }

    public void setTime4(String time4) {
        this.time4 = time4;
    }

    public String getCord1() {
        return cord1;
    }

    public void setCord1(String cord1) {
        this.cord1 = cord1;
    }

    public String getCord2() {
        return cord2;
    }

    public void setCord2(String cord2) {
        this.cord2 = cord2;
    }

    public String getCord3() {
        return cord3;
    }

    public void setCord3(String cord3) {
        this.cord3 = cord3;
    }

    public String getCord4() {
        return cord4;
    }

    public void setCord4(String cord4) {
        this.cord4 = cord4;
    }

    public String getCord5() {
        return cord5;
    }

    public void setCord5(String cord5) {
        this.cord5 = cord5;
    }

    public String getFzrqn() {
        return fzrqn;
    }

    public void setFzrqn(String fzrqn) {
        this.fzrqn = fzrqn;
    }

    public String getFzrqy() {
        return fzrqy;
    }

    public void setFzrqy(String fzrqy) {
        this.fzrqy = fzrqy;
    }

    public String getFzrqr() {
        return fzrqr;
    }

    public void setFzrqr(String fzrqr) {
        this.fzrqr = fzrqr;
    }

    public String getQueryEndTime() {
        return queryEndTime;
    }

    public void setQueryEndTime(String queryEndTime) {
        this.queryEndTime = queryEndTime;
    }

    public String getQueryStartTime() {
        return queryStartTime;
    }

    public void setQueryStartTime(String queryStartTime) {
        this.queryStartTime = queryStartTime;
    }

    public String getPzwh() {
        return pzwh;
    }

    public void setPzwh(String pzwh) {
        this.pzwh = pzwh;
    }

    public String getPxnr() {
        return pxnr;
    }

    public void setPxnr(String pxnr) {
        this.pxnr = pxnr;
    }

    public String getFrmc() {
        return frmc;
    }

    public void setFrmc(String frmc) {
        this.frmc = frmc;
    }

    public String getGsmc() {
        return gsmc;
    }

    public void setGsmc(String gsmc) {
        this.gsmc = gsmc;
    }

    public String getZczb() {
        return zczb;
    }

    public void setZczb(String zczb) {
        this.zczb = zczb;
    }

    public Date getFzrq() {
        return fzrq;
    }

    public void setFzrq(Date fzrq) {
        this.fzrq = fzrq;
    }

    public String getSlr() {
        return slr;
    }

    public void setSlr(String slr) {
        this.slr = slr;
    }

    public String getSlrsj() {
        return slrsj;
    }

    public void setSlrsj(String slrsj) {
        this.slrsj = slrsj;
    }

    public Date getZzrq() {
        return zzrq;
    }

    public void setZzrq(Date zzrq) {
        this.zzrq = zzrq;
    }

    public String getXkzh() {
        return xkzh;
    }

    public void setXkzh(String xkzh) {
        this.xkzh = xkzh;
    }

    public Long getTraincompanyapplyid() {
        return traincompanyapplyid;
    }

    public void setTraincompanyapplyid(Long traincompanyapplyid) {
        this.traincompanyapplyid = traincompanyapplyid;
    }

    public String getGsdz() {
        return gsdz;
    }

    public void setGsdz(String gsdz) {
        this.gsdz = gsdz;
    }

    public String getZczblx() {
        return zczblx;
    }

    public void setZczblx(String zczblx) {
        this.zczblx = zczblx;
    }

    public String getFzjgbh() {
        return fzjgbh;
    }

    public void setFzjgbh(String fzjgbh) {
        this.fzjgbh = fzjgbh;
    }

    public String getFzjgmc() {
        return fzjgmc;
    }

    public void setFzjgmc(String fzjgmc) {
        this.fzjgmc = fzjgmc;
    }

    public String getFrdblx() {
        return frdblx;
    }

    public void setFrdblx(String frdblx) {
        this.frdblx = frdblx;
    }

    public String getZzzt() {
        return zzzt;
    }

    public void setZzzt(String zzzt) {
        this.zzzt = zzzt;
    }
}
