package com.bcxin.ars.rest.shiro;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.util.EhcacheUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import org.apache.shiro.web.servlet.Cookie;
import org.apache.shiro.web.servlet.ShiroHttpServletRequest;
import org.apache.shiro.web.servlet.SimpleCookie;
import org.apache.shiro.web.session.mgt.DefaultWebSessionManager;
import org.apache.shiro.web.util.WebUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;

public class SessionManager extends DefaultWebSessionManager{

	@Autowired
	private EhcacheUtil ehcacheUtil;

	public SessionManager() {
		super();
	}

	@Override
	protected Serializable getSessionId(ServletRequest request, ServletResponse response) {
		// 如果参数中包含“__sid”参数，则使用此sid会话。 例如：http://localhost/project?__sid=xxx&__cookie=true
		// 其实这里还可以使用如下参数：cookie中的session名称：如：JSESSIONID=xxx,路径中的 ;JESSIONID=xxx，但建议还是使用 __sid参数。

		String sid = request.getParameter("sid");
		String sessionID = request.getParameter("sessionID");
		if(StringUtil.isNotEmpty(sessionID)){
			sid = ehcacheUtil.get(Constants.CACHE_PREFIX_KEY,sessionID);
		}

		if (!StringUtils.isEmpty(sid)) {
			if(request.getAttribute(Constants.SESSION_ID) != null){

			}else{
				try {
					String  userStr = ehcacheUtil.get(Constants.CACHE_PREFIX_KEY, sessionID+"_USERINFO");
					if(StringUtil.isNotEmpty(userStr)){
						request.setAttribute(Constants.LOGIN_USER, JSONObject.parseObject(userStr,User.class) );
					}
					request.setAttribute(Constants.SESSION_ID, sid);
				}catch (Exception e){
					e.printStackTrace();
				}
			}
			// 是否将sid保存到cookie，浏览器模式下使用此参数。
			if (WebUtils.isTrue(request, "__cookie")){
				HttpServletRequest rq = (HttpServletRequest)request;
				HttpServletResponse rs = (HttpServletResponse)response;
				Cookie template = getSessionIdCookie();
				Cookie cookie = new SimpleCookie(template);
				cookie.setValue(sid);
				cookie.saveTo(rq, rs);
			}
			// 设置当前session状态
			request.setAttribute(ShiroHttpServletRequest.REFERENCED_SESSION_ID_SOURCE,
					ShiroHttpServletRequest.URL_SESSION_ID_SOURCE); // session来源与url
			request.setAttribute(ShiroHttpServletRequest.REFERENCED_SESSION_ID, sid);
			request.setAttribute(ShiroHttpServletRequest.REFERENCED_SESSION_ID_IS_VALID, Boolean.TRUE);
			return sid;
		}else{
			return super.getSessionId(request, response);
		}
	}
}
