/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.common.util;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.sys.SysBasicUtil;
import com.bcxin.risk.sys.resources.ConfigResources;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Objects;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class EmailUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EmailUtil.class);
    private static String mail_bcxHead = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\"><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" /><title>\u767e\u5ddd\u4fe1\u63d0\u9192\u90ae\u4ef6</title><style type=\"text/css\">body,ul,li,p,h2 { margin:0; padding:0; }body { background-color:#f9f9f9; }.clear{clear:both;}li {list-style:none;}#box {width:702px; height:100%; margin:0 auto;}.header {width:702px;}.main { width:700px; background:#FFF; border:1px solid #d8d8d8; border-top:none;}.main .main_a {width:624px; padding:26px 0 0 30px;}.main .main_a h2 {font-family:\"\u5fae\u8f6f\u96c5\u9ed1\"; font-size:16px; color:#f68239; letter-spacing:1px;}.main .main_a p {width:624px; padding-top:10px; font-size:12px; color:#555; line-height:20px; letter-spacing:1px; text-indent:2em; }.main_b {width:622px; height:128px; background:#f8f8f8; border:1px solid #ed999f; margin:20px 0 0 30px;}.main_b p {font-size:12px; color:#2e1402; line-height:20px; letter-spacing:1px; padding:5px 0 0 30px;}.main_c {width:700px; height:32px; background:#b29e6b; margin:20px 0 0 0;}.main_c p {font-family:\"\u5fae\u8f6f\u96c5\u9ed1\"; font-size:14px; color:#FFF; text-align:center; line-height:32px; letter-spacing:1px;}.main_d {width:678px;}.main_d ul li {float:left; padding:30px 0 0 50px;}.main_e { margin-top:30px;  border-top:1px solid #D8D8D8;  margin-bottom:1px;}.main_e img {width:675px; height:112px; margin:2px 0 0 1px;}.footer {width:702px; height:4px; background:#bcbcbc; margin-bottom:20px; }</style></head><body><div id=\"box\"><div class=\"header\"><img src=\"http://www.bcxin.com.cn/resources/images/mail-bcx_r1_c1.jpg\" usemap=\"#Map\" border=\"0\" /><map name=\"Map\" id=\"Map\"><area shape=\"rect\" coords=\"16,10,192,81\" href=\"http://www.pss360.cn\" /></map></div><div class=\"main\"><div class=\"main_a\">";
    private static String mail_bcxFooter = "</div><div class=\"main_b\"><p style=\"margin-top:10px;\">\u9009\u62e9\u66f4\u591a\u4fdd\u9669\u4ea7\u54c1\u8bf7\u767b\u5f55\u767e\u5ddd\u4fe1\uff08www.bcxin.com.cn\uff09\u67e5\u8be2\u3002</p><p>\u5982\u6709\u4efb\u4f55\u7591\u95ee\uff0c\u8bf7\u8054\u7cfb\u767e\u5ddd\u4fe1\u5728\u7ebf\u5ba2\u670d\u6216\u62e8\u6253\u5ba2\u670d\u70ed\u7ebf\uff1a400-662-9696\uff0824\u5c0f\u65f6\u4e3a\u60a8\u670d\u52a1\uff09\u3002</p><p>\u7535\u5b50\u90ae\u7bb1\uff1abcxin@bcxin.com.cn</p><p>\u8be5\u90ae\u4ef6\u7531\u767e\u5ddd\u4fe1\u7cfb\u7edf\u53d1\u51fa\uff0c\u8bf7\u52ff\u76f4\u63a5\u56de\u590d\u3002</p></div><div class=\"main_c\"><p>\u66f4\u591a\u7cbe\u5f69\u5185\u5bb9</p></div></div> <div class=\"footer\"></div></div></body></html>";
    private static String username;
    private static String password;
    private static String host;
    private static String from;
    private static final ResourceBundle config;

    public EmailUtil() {
        host = config.getString("mail_host");
        username = config.getString("mail_from");
        password = config.getString("mail_password");
        from = config.getString("mail_from");
    }

    @Async
    public void sendEmail(String subject, String body, String to) {
        if (Objects.equals(ConfigResources.PROFILE_ENVI, "dev")) {
            return;
        }
        if (StringUtil.isEmpty((String)to)) {
            return;
        }
        if (!to.matches("[\\w\\.\\-]+@([\\w\\-]+\\.)+[\\w\\-]+")) {
            log.error("\u90ae\u7bb1\uff08" + to + "\uff09\u6821\u9a8c\u672a\u901a\u8fc7\uff0c\u683c\u5f0f\u4e0d\u5bf9!");
            return;
        }
        try {
            String SSL_FACTORY = "javax.net.ssl.SSLSocketFactory";
            Properties props = System.getProperties();
            props.setProperty("mail.smtp.host", host);
            props.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            props.setProperty("mail.smtp.socketFactory.fallback", "false");
            props.setProperty("mail.smtp.port", "465");
            props.setProperty("mail.smtp.socketFactory.port", "465");
            props.put("mail.smtp.auth", "true");
            Authenticator a = new Authenticator(){

                public PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(username, password);
                }
            };
            Session session = Session.getDefaultInstance((Properties)props, (Authenticator)a);
            MimeMessage msg = new MimeMessage(session);
            String nick = "";
            try {
                nick = MimeUtility.encodeText((String)SysBasicUtil.getConfig("platform_name"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            msg.setFrom((Address)new InternetAddress(nick + " <" + from + ">"));
            msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)to));
            msg.setSentDate(new Date());
            msg.setSubject(subject);
            msg.setText(body);
            Transport.send((Message)msg);
            log.debug("\u90ae\u4ef6\u53d1\u9001\u6210\u529f\uff0c\u6536\u4ef6\u4eba[{}]\uff0c\u4e3b\u9898[{}]\uff0c\u53d1\u9001\u5185\u5bb9[{}]", new Object[]{to, subject, body});
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u90ae\u4ef6\u53d1\u9001\u5931\u8d25\uff0c\u6536\u4ef6\u4eba[{}]\uff0c\u4e3b\u9898[{}]\uff0c\u53d1\u9001\u5185\u5bb9[{}]", new Object[]{to, subject, body});
            log.error("\u90ae\u4ef6\u53d1\u9001\u5931\u8d25\uff0c\u5f02\u5e38[{}]", (Object)e.getMessage());
        }
    }

    static {
        config = ResourceBundle.getBundle("config/config");
    }
}

