/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.common.util;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.RandomUtil;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.util.ConfigUtil;
import com.bcxin.risk.common.util.obs.OBSUtil;
import com.bcxin.risk.exception.FileException;
import com.bcxin.risk.sys.SysBasicUtil;
import com.bcxin.risk.sys.resources.ConfigResources;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;
import sun.net.www.protocol.https.Handler;

public class BcxinFileUtils {
    private static Logger log = LoggerFactory.getLogger(BcxinFileUtils.class);
    private static final String DEFAULT_UPLOAD_DIR = "upload";
    private static final String DEFAULT_TEMP_DIR = "temp";
    private static final String TI = "_t_";

    public static String zipFiles(List<String> filePaths, String zipName) {
        byte[] buffer = new byte[1024];
        String strZipPath = zipName;
        try {
            ZipOutputStream out = new ZipOutputStream((OutputStream)new FileOutputStream(strZipPath));
            ArrayList files = Lists.newArrayList();
            for (String filePath : filePaths) {
                File policyFile;
                if (!StringUtil.isNotEmpty((String)filePath) || !(policyFile = new File(filePath)).exists()) continue;
                files.add(policyFile);
                System.out.println("\u9700\u8981\u6253\u5305\u7684\u6587\u4ef6\uff1a" + filePath);
            }
            for (File file : files) {
                int len;
                if (file.isDirectory()) continue;
                FileInputStream fis = new FileInputStream(file);
                out.setEncoding(System.getProperty("sun.jnu.encoding"));
                out.putNextEntry(new ZipEntry(file.getName()));
                while ((len = fis.read(buffer)) > 0) {
                    out.write(buffer, 0, len);
                }
                out.closeEntry();
                fis.close();
            }
            out.close();
            for (File file : files) {
                if (!file.isFile() || !file.exists()) continue;
                file.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String saveFile(MultipartFile multipartFile) {
        if (multipartFile != null && StringUtil.isNotEmpty((String)multipartFile.getOriginalFilename())) {
            try {
                Date now = new Date();
                String materialFileName = now.getTime() + StringUtil.randomString((int)5) + ".";
                String fileType = Files.getFileExtension((String)multipartFile.getOriginalFilename());
                materialFileName = materialFileName + fileType;
                String dirDate = DateUtil.today();
                File dir = new File(ConfigUtil.material() + dirDate);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                String url = ConfigUtil.webSiteUrl() + "/getResource.do?path=" + dirDate + "/" + materialFileName;
                String targetPath = ConfigUtil.material() + dirDate + "/" + materialFileName;
                File targetFile = new File(targetPath);
                log.info("\u6267\u884c\u672c\u5730\u6587\u4ef6\u4e0a\u4f20..." + targetFile);
                multipartFile.transferTo(targetFile);
                log.info("\u672c\u5730\u6587\u4ef6\u4e0a\u4f20\u6210\u529f!");
                return url;
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error(e.getMessage(), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public static Map<String, String> saveFile(String uploadPath, MultipartFile multipartFile) {
        if (multipartFile != null && StringUtil.isNotEmpty((String)multipartFile.getOriginalFilename())) {
            try {
                Date now = new Date();
                String materialFileName = now.getTime() + StringUtil.randomString((int)5) + ".";
                String fileType = Files.getFileExtension((String)multipartFile.getOriginalFilename());
                materialFileName = materialFileName + fileType;
                String dirDate = DateUtil.today();
                File dir = new File(uploadPath + dirDate);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                String url = "/getResource.do?path=" + dirDate + "/" + materialFileName;
                String targetPath = uploadPath + dirDate + "/" + materialFileName;
                File targetFile = new File(targetPath);
                log.info("\u6267\u884c\u672c\u5730\u6587\u4ef6\u4e0a\u4f20..." + targetFile);
                multipartFile.transferTo(targetFile);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("url", url);
                map.put("key", "local_" + now.getTime());
                if (map == null || map.size() < 2) {
                    log.info("\u672c\u5730\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01");
                } else {
                    log.info("\u672c\u5730\u6587\u4ef6\u4e0a\u4f20\u6210\u529f!");
                }
                return map;
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error(e.getMessage(), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public static boolean fileUpload(MultipartFile file, String radomfileName, String materialFilePath) {
        boolean flag = true;
        File baseFile = new File(materialFilePath);
        File trainFile = new File(baseFile, radomfileName);
        if (!baseFile.exists()) {
            baseFile.mkdirs();
        }
        try {
            file.transferTo(trainFile);
        }
        catch (IllegalStateException e) {
            flag = false;
        }
        catch (IOException e) {
            flag = false;
        }
        return flag;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String huaweiOBSFileUpload(MultipartFile xFile, String envi) {
        String fileType = Files.getFileExtension((String)xFile.getOriginalFilename());
        String randomNumber = DateUtil.current((boolean)false) + RandomUtil.randomNumbers((int)6);
        String fileName = randomNumber + "." + fileType;
        String directoryName = ConfigResources.PROFILE_ENVI + "/" + DEFAULT_UPLOAD_DIR + "/" + DateUtil.today() + "/";
        String ossKey = ConfigResources.PROFILE_ENVI + "/" + DEFAULT_UPLOAD_DIR + "/" + DateUtil.today() + "/" + fileName;
        OBSUtil obsUtil = new OBSUtil(envi);
        try (InputStream inputStream = xFile.getInputStream();){
            String string = obsUtil.put(directoryName, ossKey, inputStream);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String huaweiLocalFileUpload(File file, String date, String envi) {
        String directoryName = "upload/" + date + "/";
        String ossKey = "upload/" + date + "/" + file.getName();
        OBSUtil obsUtil = new OBSUtil(envi);
        try (BufferedInputStream inputStream = FileUtil.getInputStream((File)file);){
            String string = obsUtil.put(directoryName, ossKey, inputStream);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public static void deleteFolder(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                for (File f : file.listFiles()) {
                    BcxinFileUtils.deleteFolder(f);
                }
                file.delete();
            } else {
                file.delete();
            }
        }
    }

    public static List<String> downLoadFromUrl(String urlStr, String fileName, String savePath) {
        try {
            if (StringUtil.isEmpty((String)urlStr)) {
                return Lists.newArrayList();
            }
            if (StringUtil.isNotEmpty((String)fileName)) {
                fileName = fileName.replace("/", "");
            }
            ArrayList pathList = Lists.newArrayList();
            String[] imageValues = urlStr.split("&&");
            int count = 1;
            for (String imageValue : imageValues) {
                String disposeFileName = fileName;
                String[] splitStr = StringUtil.split((String)imageValue, (String)"||");
                String imagePath = "";
                imagePath = splitStr.length >= 3 ? splitStr[1] : urlStr;
                if (count > 1) {
                    disposeFileName = disposeFileName.contains(".") ? disposeFileName.substring(0, disposeFileName.lastIndexOf(".")) + count : disposeFileName + count;
                }
                if (imagePath.startsWith("http")) {
                    String filePath = "";
                    disposeFileName = disposeFileName + imagePath.substring(imagePath.lastIndexOf("."), imagePath.length());
                    filePath = BcxinFileUtils.download(imagePath, disposeFileName, savePath);
                    pathList.add(filePath);
                } else if (imagePath.indexOf("path=") > 0) {
                    String intranet = SysBasicUtil.getConfig("switch_intranet");
                    String web_url = "";
                    web_url = "1".equals(intranet) ? SysBasicUtil.getConfig("intranet_url") : SysBasicUtil.getConfig("web_url");
                    String PROFILE_ENVI = ConfigResources.PROFILE_ENVI;
                    if (Objects.equals(PROFILE_ENVI, "dev")) {
                        web_url = ConfigResources.DEV_URL;
                    }
                    if (StringUtil.isNotEmpty((String)web_url) && web_url.endsWith("/") && imagePath.endsWith("/")) {
                        web_url = web_url.substring(0, web_url.length() - 1);
                    }
                    imagePath = web_url + imagePath;
                    disposeFileName = disposeFileName + imagePath.substring(imagePath.lastIndexOf("."), imagePath.length());
                    String filePath = BcxinFileUtils.download(imagePath, disposeFileName, savePath);
                    pathList.add(filePath);
                }
                ++count;
            }
            return pathList;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38\uff1a" + e.getMessage());
            return Lists.newArrayList();
        }
    }

    public static List<String> downLoadFromUrl(String urlStr, String savePath) {
        try {
            String[] imageValues;
            if (StringUtil.isEmpty((String)urlStr)) {
                return Lists.newArrayList();
            }
            ArrayList pathList = Lists.newArrayList();
            for (String imageValue : imageValues = urlStr.split("&&")) {
                String disposeFileName = "";
                String[] splitStr = StringUtil.split((String)imageValue, (String)"||");
                String imagePath = "";
                if (splitStr.length >= 3) {
                    imagePath = splitStr[1];
                    disposeFileName = Files.getNameWithoutExtension((String)splitStr[2]);
                } else {
                    disposeFileName = Files.getNameWithoutExtension((String)imagePath);
                    imagePath = urlStr;
                }
                if (imagePath.startsWith("http")) {
                    disposeFileName = disposeFileName + imagePath.substring(imagePath.lastIndexOf("."), imagePath.length());
                    String filePath = BcxinFileUtils.download(imagePath, disposeFileName, savePath);
                    pathList.add(filePath);
                    continue;
                }
                if (imagePath.indexOf("path=") <= 0) continue;
                String intranet = SysBasicUtil.getConfig("switch_intranet");
                String web_url = "";
                web_url = "1".equals(intranet) ? SysBasicUtil.getConfig("intranet_url") : SysBasicUtil.getConfig("web_url");
                String PROFILE_ENVI = ConfigResources.PROFILE_ENVI;
                if (Objects.equals(PROFILE_ENVI, "dev")) {
                    web_url = ConfigResources.DEV_URL;
                }
                if (StringUtil.isNotEmpty((String)web_url) && web_url.endsWith("/") && imagePath.endsWith("/")) {
                    web_url = web_url.substring(0, web_url.length() - 1);
                }
                imagePath = web_url + imagePath;
                disposeFileName = disposeFileName + imagePath.substring(imagePath.lastIndexOf("."), imagePath.length());
                String filePath = BcxinFileUtils.download(imagePath, disposeFileName, savePath);
                pathList.add(filePath);
            }
            return pathList;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38\uff1a" + e.getMessage());
            return Lists.newArrayList();
        }
    }

    public static String download(String urlStr, String fileName, String savePath) throws FileException {
        FileOutputStream fos = null;
        InputStream inputStream = null;
        try {
            HttpURLConnection conn;
            URL url = null;
            if (urlStr.startsWith("https://")) {
                BcxinFileUtils.trustAllHosts();
                url = new URL(null, urlStr, new Handler());
                conn = (HttpsURLConnection)url.openConnection();
                conn.setConnectTimeout(10000);
                conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
                inputStream = conn.getInputStream();
            } else {
                url = new URL(urlStr);
                conn = (HttpURLConnection)url.openConnection();
                conn.setConnectTimeout(10000);
                conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
                inputStream = conn.getInputStream();
            }
            byte[] getData = BcxinFileUtils.readInputStream(inputStream);
            File saveDir = new File(savePath);
            if (!saveDir.exists()) {
                saveDir.mkdirs();
            }
            File file = new File(saveDir + File.separator + fileName);
            fos = new FileOutputStream(file);
            fos.write(getData);
            String filePath = saveDir + "/" + fileName;
            log.info("\u6587\u4ef6\u4e0b\u8f7d\uff0curl\u8def\u5f84[{}]\uff0c\u6587\u4ef6\u8def\u5f84[{}]", (Object)url, (Object)filePath);
            String string = filePath;
            return string;
        }
        catch (IOException e) {
            throw new FileException(e.getMessage());
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void trustAllHosts() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("SSL", "SunJSSE");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List<String> filterMultiFilePath(String localFilePath) {
        String[] filePaths;
        ArrayList list = Lists.newArrayList();
        if (StringUtil.isEmpty((String)localFilePath)) {
            return list;
        }
        for (String filePath : filePaths = StringUtils.split((String)localFilePath, (String)"&&")) {
            String localUrl;
            String[] explain;
            if (filePath.indexOf("||") <= -1 || (explain = StringUtils.split((String)filePath, (String)"||")).length < 3 || (localUrl = explain[1]).indexOf("path=") == -1) continue;
            localUrl = localUrl.substring(localUrl.indexOf("path=") + 5, localUrl.length());
            list.add(localUrl);
        }
        return list;
    }

    public static List<String> filterMultiFileUrl(String localFilePath) {
        String[] filePaths;
        ArrayList list = Lists.newArrayList();
        if (StringUtil.isEmpty((String)localFilePath)) {
            return list;
        }
        for (String filePath : filePaths = StringUtils.split((String)localFilePath, (String)"&&")) {
            String[] explain;
            if (filePath.indexOf("||") <= -1 || (explain = StringUtils.split((String)filePath, (String)"||")).length < 3) continue;
            String localUrl = explain[1];
            list.add(localUrl);
        }
        return list;
    }

    public static List<String> filterMultiFileName(String localFilePath) {
        String[] filePaths;
        ArrayList list = Lists.newArrayList();
        if (StringUtil.isEmpty((String)localFilePath)) {
            return list;
        }
        for (String filePath : filePaths = StringUtils.split((String)localFilePath, (String)"&&")) {
            String[] explain;
            if (filePath.indexOf("||") <= -1 || (explain = StringUtils.split((String)filePath, (String)"||")).length < 3) continue;
            String localName = explain[2];
            list.add(localName);
        }
        return list;
    }

    public static String filterSingleLocalFilePath(String localFilePath) {
        if (StringUtil.isEmpty((String)localFilePath)) {
            return localFilePath;
        }
        if (localFilePath.indexOf("||") > -1) {
            String[] explain = StringUtils.split((String)localFilePath, (String)"||");
            if (explain.length < 3) {
                return localFilePath;
            }
            return explain[1];
        }
        return localFilePath;
    }

    public static String filterSingleFilePath(String localFilePath) {
        if (StringUtil.isEmpty((String)localFilePath)) {
            return "";
        }
        if (localFilePath.contains("path=")) {
            return localFilePath.substring(localFilePath.indexOf("path=") + 5, localFilePath.length());
        }
        return localFilePath;
    }

    public static String filterFileDir(String filePath) {
        if (StringUtil.isEmpty((String)filePath)) {
            return "";
        }
        String fileName = Files.getNameWithoutExtension((String)filePath);
        String type = Files.getFileExtension((String)filePath);
        return filePath.replaceAll(fileName + "\\." + type, "");
    }

    public static String filterUrlFileDir(String filePath) {
        if (StringUtil.isEmpty((String)filePath)) {
            return "";
        }
        String localFilePath = BcxinFileUtils.filterSingleFilePath(filePath);
        String fileName = Files.getNameWithoutExtension((String)localFilePath);
        String type = Files.getFileExtension((String)localFilePath);
        return localFilePath.replaceAll(fileName + "\\." + type, "");
    }

    public static String filterSingleFileName(String localFilePath) {
        if (StringUtil.isEmpty((String)localFilePath)) {
            return "";
        }
        if (localFilePath.indexOf("path=") == -1) {
            return "";
        }
        String filePath = localFilePath.substring(localFilePath.indexOf("path=") + 5, localFilePath.length());
        if (filePath.contains("/")) {
            filePath = filePath.substring(filePath.lastIndexOf("/") + 1, filePath.length());
        }
        return filePath;
    }

    private static byte[] readInputStream(InputStream inputStream) throws IOException {
        byte[] buffer = new byte[1024];
        int len = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((len = inputStream.read(buffer)) != -1) {
            bos.write(buffer, 0, len);
        }
        bos.close();
        return bos.toByteArray();
    }

    public static synchronized String packTimestamp(String fileName) {
        if (StringUtil.isEmpty((String)fileName)) {
            return "";
        }
        if (fileName.contains(".")) {
            return Files.getNameWithoutExtension((String)fileName) + TI + DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmssSSS") + Files.getFileExtension((String)fileName);
        }
        return fileName + TI + DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmssSSS");
    }

    public static String appendFolderPath(String[] paths) {
        StringBuilder sb = new StringBuilder();
        for (String path : paths) {
            if (sb.length() == 0) {
                sb.append(path);
                continue;
            }
            if (sb.toString().endsWith(File.separator)) {
                sb.append(path).append(File.separator);
                continue;
            }
            sb.append(File.separator).append(path).append(File.separator);
        }
        BcxinFileUtils.mkDir(sb.toString());
        return sb.toString();
    }

    public static void mkDir(String dir) {
        File fileDir = new File(dir);
        if (!fileDir.exists()) {
            fileDir.mkdirs();
        }
    }

    public static String filterMultiLocalFilePath(String channel, String localFilePath) {
        String[] stringList;
        if (StringUtil.isEmpty((String)localFilePath)) {
            return localFilePath;
        }
        ArrayList files = Lists.newArrayList();
        for (String path : stringList = localFilePath.split("&&")) {
            files.add(channel + BcxinFileUtils.filterSingleLocalFilePath(path));
        }
        return Joiner.on((String)"&&").join((Iterable)files);
    }

    public static void main(String[] args) {
        String url = "https://nx.dh.pss360.cn:9002/getResource.do?path=2021-06-23/162443036329383773.docx";
        BcxinFileUtils.download(url, "_acaf_34_t_20210623190000673.docx", "D:\\data\\pss\\material\\ningxia\\2021-06-24\\hd");
    }
}

