/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class JwtUtil {
    public static final int RESCODE_SUCCESS = 1000;
    public static final int RESCODE_SUCCESS_MSG = 1001;
    public static final int RESCODE_EXCEPTION = 1002;
    public static final int RESCODE_NOLOGIN = 1003;
    public static final int RESCODE_NOEXIST = 1004;
    public static final int RESCODE_NOAUTH = 1005;
    public static final String JWT_ID = "blb";
    public static final String JWT_SECRET = "18disdkfd83DPQ012I8VcnSkq";
    public static final int JWT_TTL = 1471228928;
    public static final int JWT_REFRESH_INTERVAL = 3300000;
    public static final int JWT_REFRESH_TTL = 604800000;
    private static final String JWT_SECRET_WSK = "sdoDFyzfieqMrisd4H5o5t9weOl6GmSr";

    private static SecretKey generalKey(String stringKey) {
        byte[] encodedKey = Base64.decodeBase64((String)stringKey);
        SecretKeySpec key = new SecretKeySpec(encodedKey, 0, encodedKey.length, "AES");
        return key;
    }

    public static String createJWT(String id, String subject, String stringKey, long ttlMillis) throws Exception {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        JwtBuilder builder = Jwts.builder().setId(id).setIssuedAt(new Date(System.currentTimeMillis())).setSubject(subject).signWith(signatureAlgorithm, (Key)JwtUtil.generalKey(stringKey));
        if (ttlMillis >= 0L) {
            long expMillis = System.currentTimeMillis() + ttlMillis;
            Date exp = new Date(expMillis);
            builder.setExpiration(exp);
        }
        return builder.compact();
    }

    public static String createJWT(Map<Object, Object> subject, String stringKey, long ttlMillis) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        JwtBuilder builder = Jwts.builder().setSubject(JSON.toJSONString(subject)).signWith(signatureAlgorithm, (Key)JwtUtil.generalKey(stringKey));
        if (ttlMillis >= 0L) {
            long expMillis = System.currentTimeMillis() + ttlMillis;
            Date exp = new Date(expMillis);
            builder.setExpiration(exp);
        }
        return builder.compact();
    }

    public static Claims parseJWT(String jwttoken, String stringKey) throws Exception {
        Claims claims = (Claims)Jwts.parser().setSigningKey((Key)JwtUtil.generalKey(stringKey)).parseClaimsJws(jwttoken).getBody();
        return claims;
    }

    public static Claims parseJWT(String jwttoken) throws Exception {
        Claims claims = (Claims)Jwts.parser().setSigningKey((Key)JwtUtil.generalKey(JWT_SECRET_WSK)).parseClaimsJws(jwttoken).getBody();
        return claims;
    }

    public static String encrypting(Map<Object, Object> map) {
        String jwt_secret = JWT_SECRET_WSK;
        String token = JwtUtil.createJWT(map, jwt_secret, 604800000L);
        return token;
    }

    public static void main(String[] args) throws Exception {
        HashMap<Object, Object> p = new HashMap<Object, Object>();
        String jwt_secret = JWT_SECRET_WSK;
        String token = JwtUtil.createJWT(p, jwt_secret, 604800000L);
        HashMap requestMap = Maps.newHashMap();
        requestMap.put("token", token);
        JwtUtil.parseJWT("eyJhbGciOiJIUzI1NiJ9.eyJzdWIiOiJ7fSIsImV4cCI6MTY2OTg4NTU0OH0.EL7ZHkQK3f5IAOlsn7_PI4wLO2G26arlCTgMYvROWLg");
        System.out.println(token);
    }

    public static String createJWT(Map<String, String> subject) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        JwtBuilder builder = Jwts.builder().setSubject(JSON.toJSONString(subject)).signWith(signatureAlgorithm, (Key)JwtUtil.generalKey(JWT_SECRET_WSK));
        long expMillis = System.currentTimeMillis() + 604800000L;
        Date exp = new Date(expMillis);
        builder.setExpiration(exp);
        return builder.compact();
    }

    public static String setIDJwt(String id) {
        HashMap<Object, Object> p = new HashMap<Object, Object>();
        p.put("oid", id);
        return JwtUtil.createJWT(p, JWT_SECRET_WSK, 30000L);
    }

    public static JSONObject getBody(String token) throws Exception {
        Claims claims = JwtUtil.parseJWT(token);
        String sub = (String)claims.get((Object)"sub");
        return JSONObject.parseObject((String)sub);
    }
}

