import AbstractField from "./AbstractField";
import { Sequence } from "../../utility";

class NoField extends AbstractField{
    constructor(container) {
        super();
        this.scope="noField"
        this.container = container;
        this.htmlDOM=null;
        this.className="baseField";
        this.propValues.id = Sequence.createUuid();
        this.html=`<div style="padding: 5px 0;line-height: 20px;color: #3d464d;font-weight: 600;">
        <span  class="baseLabel-title" style="font-size: 14px;color: #3d464d;">流水号</span>
        </div><div class="baseCon fieldId"  fieldid='${this.propValues.id}' style="">
        <input type="text" readonly class="base-field" ></input></div>`
        
        this.propValues.name="流水号"+window.formApp.formPanel.propValues.nameIndex;
        this.propValues.texttype = "text";//显示
        this.propValues.headText = ""; // 前缀
        this.propValues.digit = 1; // 位数
        this.propValues.layout = ""; // 手机布局
        this.propValues.width = 200; // 宽度
        this.propValues.readonlyshowvalonly = true; //只读时仅只显示值
        this.propValues.calculateonrefresh = true; //重计算
        this.propValues.mobile = true; //手机可用
        this.propValues.isYear = true;// 前缀是否包含年份
        this.propValues.isMonth = true;// 前缀是否包含月份
        this.propValues.isDay = true;// 前缀是否包含日期
        this.propValues.discript ="";
        this.propValues.editProp="editTextareaField";
        this.propValues.editmode = "01"; //值的方式
        this.propValues.valuescript = ""; //脚本值
        this.propValues.processdescription = ""; //值设计脚本的值
        this.propValues.processprevalue = []; //用来存储选中的值设计的字段值
        this.propValues.filtercondition = "";//用来存储设计时的脚本(部分写死)
        this.propValues.isdefaultvalue = false; //仅创建时计算
        this.propValues.validatelibs =[]; //校验方式
        this.propValues.validaterule = ""; //校验脚本
        this.propValues.instantvalidate = false; //即时校验（新增属性）

        this.propValues.hiddenscript = ""; //隐藏条件脚本
        this.propValues.hiddenvalue = ""; //隐藏时显示值
        this.propValues.hiddenprintscript = ""; //打印时隐藏条件脚本
        this.propValues.printhiddenvalue = ""; //打印隐藏时显示值
        this.propValues.readonlyscript = ""; //只读条件脚本
        this.propValues.fieldtype="VALUE_TYPE_TEXT";

    }
    
    getPropsDesc() {
        return {
            "base":['myselfrows','name','headText', 'digit', 'layout', 'width', 'readonlyshowvalonly','calculateonrefresh','mobile','isYear', 'isMonth', 'isDay', 'discript'],
            "value":['editmode','isdefaultvalue','valuescript','processdescription'],
            "check":['validatelibs','validaterule','instantvalidate'],
            "hidden":['hiddenscript','hiddenvalue'],
            "hiddenprint":["hiddenprintscript","printhiddenvalue"],
            "readonly":['readonlyscript']


        }
    }
    
}
export default NoField;