import Vue from "vue";
import Vuex from "vuex";
// import API from "@/service/CommonApi.js"

Vue.use(Vuex);

export default new Vuex.Store({
  state: {
    params: {
      appId: "",
      appName: "",
    },
    menuTreeMenuId: "", // 选中的菜单树节点id
    rightHelpFrame: null, // 帮助页面iframe
    rightHelpPageParams: { // 帮助页面title和显示的页面
      title: "",
      url: "",
    },
    isReloadTree: false,//是否重新加载左边模块树
    tabName: '',//点击的选项的名字
    selectTreeNodeArr: [], // 复制菜单数组
    menuSuperiorId:'',//新建菜单时的上级id
    isShowMunuDetail: false, // 是否直接显示menuDetail
    mobileSave: "", // mobile菜单一级保存不需提示表单视图等
    formDetailVisible:true,
    viewDetailVisible:true,
    processDetailVisible:true,
    dataSourceId: '', // 数据源id
    currentDataSourcesOption: {}, // 视图的当前选择的数据
    formData: {}, // 表单的基本的值
  },

  getters: {
    currentMenus: (state) => {
      return state.menus.appMenus[state.menus.currentApp];
    },
  },

  mutations: {
    changeformDetailVisible (state, val) {
      state.formDetailVisible=val;
    },
    changeviewDetailVisible (state, val) {
      state.viewDetailVisible=val;
    },
    changeprocessDetailVisible (state, val) {
      state.processDetailVisible=val;
    },
    changeIsClickPrimaryTab (state, val) {
      state.tabName = val.substring(0, val.length - 13)

    },
    changeIsReloadTree (state, val) {
      state.isReloadTree = val
    },
    landingUser (state, data) {
      state.params.appId = data.params.appId;
      state.params.appName = data.params.appName;
    },
    resetUserInfo (state) {
      state.params.appId = ""
      state.params.appName = ""
    },
    setMenuSuperiorId(state,menuId){
      state.menuSuperiorId = menuId;
    },
    saveMenuTreeMenuId (state, menuId) {
      state.menuTreeMenuId = menuId;
    },
    resetMenuTreeMenuId (state) {
      state.menuTreeMenuId = "";
    },
    rightHelpFrame (state, iFrameObj) {
      state.rightHelpFrame = iFrameObj;
    },
    rightHelpPageParams (state, dataObj) {
      state.rightHelpPageParams.title = dataObj.title;
      state.rightHelpPageParams.url = dataObj.url;
    },
    selectTreeNode (state, selectNodeArr) {
      state.selectTreeNodeArr = selectNodeArr;
    },
    changeShowMunuDetail(state, obj){
      state.isShowMunuDetail = obj.show
      state.mobileSave = obj.superiorId
    },

    // 设置数据源id
    setDataSourceId(state, id){
      state.dataSourceId = id
    },

    // 设置视图当前选中的值
    setCurrentDataSources(state, val){
      state.currentDataSourcesOption = val
    },
    // 设置表单
    setFormData(state, val){
      state.formData = val
    },
  },

  actions: {
    //当前登陆的用户
    landingUser (context, data) {
      context.commit("landingUser", data);
    },
    // 退出清空数据
    resetUserInfo (context) {
      context.commit("resetUserInfo");
      sessionStorage.removeItem("appId")
      sessionStorage.removeItem("appName")
      sessionStorage.removeItem("token")
    },
    //设置菜单上级id
    setMenuSuperiorId(context,menuId){
      context.commit("setMenuSuperiorId", menuId);
    },

    // 保存节点树id
    saveMenuTreeMenuId (context, menuId) {
      context.commit("saveMenuTreeMenuId", menuId);
    },
    // 重置节点树id
    resetMenuTreeMenuId (context) {
      context.commit("resetMenuTreeMenuId");
    },

    // 获取帮助文档的iframe
    loadRightHelpFrame (context, iFrameObj) {
      context.commit("rightHelpFrame", iFrameObj);
    },

    // 显示右侧的数据
    rightHelpPageParams (context, dataObj) {
      context.commit("rightHelpPageParams", dataObj);
    },

    // 菜单选中的需要复制的值
    selectTreeNode (context, selectNodeArr) {
      context.commit("selectTreeNode", selectNodeArr);
    },
  },
});
