import PropsPanel from './PropsPanel';
import TreeMenu from './TreeMenu';
class Tree {
	
	static instance = null;
	
	static getInstance() {
		if(!Tree.instance || !(Tree.instance instanceof Tree)) {
			Tree.instance = new Tree();
		}

		return Tree.instance;	
	}

	constructor(config) {
		this.report = null;
		this.container = null;
		
		this.treeMenu = TreeMenu.getInstance();
	}
	
	setProps(newProps) {
		Object.assign(this, newProps);
	}
	
	getProp(prop) {
		return this[prop];
	}

	init(params) {
		this.setProps(params);
		this.render();
	}

	render() {
		//console.log("render")
		const report = this.report;
		const treeData = report.transformToTree();
		const $container = this.container;
		let id=0;
		//console.log(treeData);
		if($container) {
			$container.treeview({
				data: treeData,
				levels:2,
				selectedBackColor:"#f5f5f5",
				selectedColor:'#666'

			});
			// $container.treeview('collapseAll', { silent: true });
			if(report.getCurrToEdit()){
				let num=1;
				treeData[0].nodes.forEach(function(val){

					if(val.scope==report.getCurrToEdit().scope||val.scope==report.getCurrToEdit().belong || val.scope==report.getCurrToEdit()){
						id=num;
						return false;
					}

					if(val.nodes){
						num =val.nodes.length+1+num;
					}else{
						num +=1;
					}

				})

			}
			$container.treeview('expandNode', [ id, { levels: 2, silent: true } ]);

			this.bindEvent($container);
			console.log(report.getCurrToEdit());
		}
		//console.log(treeData);
	}
	backTreeMenu(){
		return this.treeMenu;
	}
	bindEvent(element) {
		const $elem = $(element);
		const that = this;
		// $elem.on("nodeCollapsed",function(event,data){
		// 	data.icon="glyphicon glyphicon-euro"
		// 	console.log(data);
		// })

		$elem.on('nodeSelected', function(event, data) {
			//console.log(event.target);
			const report = that.getProp('report');
			const propsPanel = PropsPanel.getInstance();
			
			if(data) {
				const instance = data.instance || null;
				//console.log(data)
				if(instance) {
					
					const className = instance.getClassName();
					if(className == 'Title' || className == 'PageHeader' || className == 'ColumnHeader' || className == 'Detail'
					|| className == 'ColumnFooter' || className == 'PageFooter' || className == 'Summary' || className=="GroupHeader" || className == "GroupFooter") {
						//console.log(222)
						report.setProps({_currToChunk: instance, _currToElem: null});
						//console.log(1)
					}else {
						//console.log(instance)
						report.setProps({_currToElem: instance, _currToChunk: null});
					}
				}
				if(data.scope=='Variable'){
					report.setProps({_currToChunk: data, _currToElem:null })
				}else if(data.scope=='Variables'){
					report.setProps({_currToChunk: data.scope, _currToElem:  null})
				}else if(data.scope=="field"){
					report.setProps({_currToChunk: data, _currToElem:  null})
				}else if(data.scope=="report"){
					report.setProps({_currToChunk: null, _currToElem:  null})

				}else if(data.scope=='Parameters'){
					report.setProps({_currToChunk: data.scope, _currToElem:  null})
				}else if(data.scope=='Parameter'){
					report.setProps({_currToChunk: data, _currToElem:  null})
				}
				propsPanel.render();
				report.paint();
			}
			
		});
		
		$elem.off("mousedown").on('mousedown', function(e) {
			//console.log("mousedown");
			const $container = that.container;
			const target = $(e.target);
			const report = that.getProp('report');
			const text = target.text();
			const field = report.getProp('field');
			const variable=report.getProp('variable');
			const parameter=report.getProp('parameter');

			// const scope=target.scope();
			const nodeId=parseInt(target[0].dataset.nodeid);
			let arr=$('#tree').treeview('getSelected', nodeId);
			let str=$('#tree').treeview('getNode', nodeId);//当前鼠标在哪个节点位置内
			if(field.length > 0) {
				for(let i = 0;i < field.length;i++) {
					if(field[i].columnName == text) {
						report.addTextField(text);
					}
				}
			}
			if(text=='变量'&&e.button==2 && !that.treeMenu.getProp("hasMenu")){
				report.stopElementDefaultMenu(e.target);
				that.treeMenu.setProps({target: e, report: report,type: "添加变量"});
				that.treeMenu.showMenu();
			}else if(report.getCurrToEdit()==null&&e.button==2 && target.attr("data-nodeid")=="0" && !that.treeMenu.getProp("hasMenu")){
				// report.stopElementDefaultMenu(e.target);
				// that.treeMenu.setProps({target: e, report: report,type: "添加分组"});
				// that.treeMenu.showMenu();
			}else if(text.indexOf("组头")!=-1&&e.button==2 && !that.treeMenu.getProp("hasMenu")){
				report.stopElementDefaultMenu(e.target);
				that.treeMenu.setProps({target: e, report: report,type: "删除分组",whichGroup:str});
				that.treeMenu.showMenu();
			}else if(text=='参数'&&e.button==2 && !that.treeMenu.getProp("hasMenu")){
				report.stopElementDefaultMenu(e.target);
				that.treeMenu.setProps({target: e, report: report,type: "添加参数"});
				that.treeMenu.showMenu();
			}
			else{
				that.treeMenu.hideMenu();
			}
		// else if(str.scope=="Variable"&&button==2){
		//
		// 	}
			if(arr.length!=0){
				if(arr[0].scope=='Variable'){

					// const nodeId=target[0].dataset.nodeid;
					// let arr=$('#tree').treeview('getSelected', nodeId);
					// //arr留下一个坑，后期补
					//
					// if(arr.length!=0){
					if(e.button==2){
						report.stopElementDefaultMenu(e.target);
						that.treeMenu.setProps({target: e,report: this,type: "删除变量",whichNode:str,preVar:variable,});
						that.treeMenu.showMenu();
					}else{
						that.treeMenu.hideMenu();
						report.addVariable(text,arr[0].field,arr[0].option);
					}

					// }
					return ;
				}
				if(arr[0].scope=='Parameter'){

					// const nodeId=target[0].dataset.nodeid;
					// let arr=$('#tree').treeview('getSelected', nodeId);
					// //arr留下一个坑，后期补
					//
					// if(arr.length!=0){
					if(e.button==2){
						report.stopElementDefaultMenu(e.target);
						that.treeMenu.setProps({target: e,report: this,type: "删除参数",whichNode:str,preVar:parameter,});
						that.treeMenu.showMenu();
					}else{
						that.treeMenu.hideMenu();
						report.addParameter(text);
					}

					// }
					return ;
				}
			}
		});
		
		$elem.on('mouseup', function(e) {
			console.log("mouseUp")
			const target = $(e.target);
			const report = that.getProp('report');
			const text = target.text();
			const field = report.getProp('field');
			const nodeId=target[0].dataset.nodeid;
			let arr=$('#tree').treeview('getSelected', nodeId);
			if(field.length > 0) {
				for(let i = 0;i < field.length;i++) {
					if(field[i].columnName == text) {
						report.delElement();
					}
				}
			}
			if(arr.length!=0){
				if(arr[0].scope=="Variable"){
					report.delElement();
				}else if(arr[0].scope=="Parameter"){
					report.delElement();
				}
			}
		});
	}
}

export default Tree;