import Element from './Element'

class AbstractSheet extends Element {
    constructor(diagram){
		super(diagram);

        this.color = AbstractSheet.DEF_COLOR; // 元素使用的默认颜色

        this.font = AbstractSheet.DEF_FONT; // 元素使用的默认字体

        this.scale = 0;

        this.note = ""; // 备注
		
    }
    getColumns() {
		let rtn = [];
		let iter = this._owner.getAllElements();
		for(let i=0;i<iter.length;i++) {
			let obj = iter[i];
			if (obj instanceof Relation) {
				let r = obj;

				let node = r.getAnotherEndNode(this);
				if (node instanceof Column) {
					rtn.push(node);
				}
			}
		}
		return rtn;
	}
	
	//拼装XML
    toXML(){
        var str = "";
        
		str+=super.toXML();
		str+="<scale>"+this.scale+"</scale>\n";
        
		return str;
	}
	
}
AbstractSheet.DEF_PASSCOLOR = "green";
AbstractSheet.DEF_COLOR = "black";
AbstractSheet.DEF_SELECTEDCOLOR = "pink";
AbstractSheet.DEF_CURREDITCOLOR = "orange";
AbstractSheet.DEF_PASSEDCOLOR = "green";
AbstractSheet.DEF_FONT = '12px -apple-system, "Microsoft YaHei", Arial, sans-serif';

export default AbstractSheet