class Helper {
    // static instance = null;

    static getInstance() {
        if(!Helper.instance || !(Helper.instance instanceof Helper)) {
            Helper.instance = new Helper();
        }

        return Helper.instance;
    }

    constructor() {
		this.instance = null;
        this.templete = '';
    }

    /**
     * 处理请求后获取的模板
     * @param tml 需要处理的模板
     * @param data 需要填充进模板里的数据
     * @param tmlId 需要过滤掉的模板id，用于删除模板里不需要的标签
     * @return 返回处理完的模板html字符串
     */
    handleTemplete(tml, data, tmlId) {
        const $tml = $(tml).filter('#' + tmlId).html();
        //console.log(tml);
        const render = template.compile($tml);
        //console.log(render);
        return render(data);
    }
}

export default Helper;