import AbstractSheet from './AbstractSheet';
import Point from '../utility/Point';
import Rectangle from '../utility/Rectangle';
import Resources from '../utility/Resources';


class Node extends AbstractSheet {
    constructor(diagram){
        super(diagram);
        this.HEAD_TEXT = "";
        this._headRect = {};
        this._textRect = {};
        this.width = Node.WIDTH;
        this.height = Node.HEIGHT;
		this.formName = '';
        this.resize();
        this._handlePoint = {
            x: 0,
            y: 0
        };
        this.x = 0;
		this.y = 0;
        

    }

    /**
	 * @param x
	 * @param y
	 * @return boolean
	 * @roseuid 3E0A6E190080
	 */
    isSelected(x, y) {
        // Rectangle rc = new Rectangle();
        return this._headRect.contains(x, y) || this._textRect.contains(x, y);
    }

    /**
	 * @param x
	 * @param y
	 * @roseuid 3E0A6E19009E
	 */
	moveTo(x, y) {
        this.x = x - this._handlePoint.x;
		this.y = y - this._handlePoint.y;
		this.resize();
	}

	//拼装XML
	toXML(){
		//检验节点名称与状态标签是否为空
		var str = "";

		str+=super.toXML();

		str+="<x>"+this.x+"</x>\n";
		str+="<y>"+this.y+"</y>\n";
		str+="<width>"+this.width+"</width>\n";
		str+="<height>"+this.height+"</height>\n";
		str+="<formName>"+this.replaceCharacter(this.formName)+"</formName>\n";

		return str;
	}
	

    resize() {
		this._headRect = new Rectangle();
		this._headRect.setBounds(this.x, this.y, Resources.FONT_METRICS.width * this.HEAD_TEXT.length + 10, Resources.FONT_METRICS.height + 5);

		this._textRect = new Rectangle();
		this._textRect.setBounds(this.x, this.y + this._headRect.height, 
			Resources.FONT_METRICS.width * this.HEAD_TEXT.length + 10, Resources.FONT_METRICS.height + 5);
    }
    
    drawTips(g, tips) {
		if (tips != null && tips != '') {
			let tiplist = tips.split("\n"); 
			let tipWidth = 0;
			for (let i = 0; i < tiplist.length; i++) {
				if(g.stringWidth(tiplist[i]) > tipWidth){
					tipWidth = g.stringWidth(tiplist[i]);
				}
            }
            g.setColor('#FFFFE1');
			g.fillRect(
				this.x + this.width / 2 + 1,
				this.y + this.height + 1,
				Resources.FONT_METRICS.ascent * 18 - 1, 
				(Resources.FONT_METRICS.height + 5) * tiplist.length + 10 - 1
			);
			g.setColor(Resources.COLOR.black);
			g.drawRect(
				this.x + this.width / 2, 
				this.y + this.height, 
				tipWidth + 10, 
				(Resources.FONT_METRICS.height + 5) * (tiplist.length) + 10
			);
			for (let i = 0; i < tiplist.length; i++) {
				g.drawString(
					tiplist[i], 
					this.x + this.width / 2 + 5, 
					this.y + this.height + (i + 1) * (Resources.FONT_METRICS.height + 5)
				);
			}
		}
	}

}

Node.WIDTH = 142;
Node.HEIGHT = 34;

export default Node
