import instance from './ajax'

/**
 * 获取报表详情
 */
export const getReportDetail= (reportId) => {
  return instance({
    url: `${contextPath}/designtime/applications/reports/${reportId}`,
    method: 'get',
  })
}

/**
 * 获取模块表单列表
 */
export const getReportsList = (params) => {
  return instance.get(contextPath + '/designtime/applications/modules/'+ params.moduleId +'/reports?searchword='+ params.searchword +'&pageNo='+ params.pageNo +'&linesPerPage='+ params.linesPerPage)
}

/**
 * 通过数据源获取返回结果集的列信息
 */
export const getQueryColumnInfos= (params, { onSucess, onError }) => {
  instance.post(`${contextPath}/designtime/applications/${params.appId}/reports/getQueryColumnInfos?type=${params.type}&viewId=${params.viewId}&isForm=${params.isForm}&dataSourceName=${params.dataSourceName}`,params.data)
  .then(function (response) {
    if (onSucess) onSucess(response);
  }).catch(function (error) {
      if (onError) onError(error);
    }
  );
}
/**
 * 更新报表
 */
export const updateReport= (params) => {
  return instance({
    url: `${contextPath}/designtime/applications/reports`,
    method: 'put',
    data: params
  })
}
/**
 * 报表预览返回html路径
 */
export const previewReport= ({reportId="",checkDomainId=""}) => {
  return instance({
    url: `${contextPath}/designtime/applications/reports/showjrxml/${reportId}?domainId=${checkDomainId}`,
    method: 'get'
  })
}
/**
 * 返回企业域列表
 */
export const getDomainList= ({ onSucess, onError }) => {
  instance.get(`${contextPath}/designtime/applications/reports/getDomainList`)
  .then(function (response) {
    if (onSucess) onSucess(response);
  }).catch(function (error) {
      if (onError) onError(error);
    }
  );
}
/**
 * 创建报表
 */
export const createReports = (params) => {
  return instance({
    url: contextPath + '/designtime/applications/'+ params.appId +'/modules/'+ params.moduleId +'/reports',
    method: 'post',
    data: params
  })
}
