import AbstractField from "./AbstractField";
import { Sequence } from "../../utility";

class DeptField extends AbstractField{
    constructor(container) {
        super();
        this.scope="deptField"
        this.container = container;
        this.htmlDOM=null;
        
        this.className="baseField";
        this.propValues.id = Sequence.createUuid();
        this.html=`<div style="padding: 5px 0;line-height: 20px;color: #3d464d;font-weight: 600;">
        <span  class="baseLabel-title" style="font-size: 14px;color: #3d464d;">部门选择框</span>
        </div><div class="baseCon fieldId"  fieldid='${this.propValues.id}' style=" height: 30px;">
        <select class="selectField"  readonly ></select></div>`;
        this.propValues.name="部门选择框"+window.formApp.formPanel.propValues.nameIndex;

        this.propValues.texttype = "text";//显示
        this.propValues.readonlyshowvalonly = true; //只读时仅只显示值
        this.propValues.refreshonchanged = false; //刷新
        this.propValues.calculateonrefresh = false; //重计算
        this.propValues.mobile = true; //手机可用
        this.propValues.refreshmode = "0"; //重刷新的方式
        this.propValues.refreshfields = []; //局部刷新的字段组合
        this.propValues.discript ="";
        // this.propValues.refresh = '0';
        this.propValues.editProp="editDeptField";
        this.propValues.editmode = "01"; //值的方式
        this.propValues.valuescript = ""; //脚本值
        this.propValues.processdescription = ""; //值设计脚本的值
        this.propValues.processprevalue = []; //用来存储选中的值设计的字段值
        this.propValues.filtercondition = "";//用来存储设计时的脚本(部分写死)
        this.propValues.validatelibs =[]; //校验方式
        this.propValues.isdefaultvalue = false; //仅创建时计算
        this.propValues.validaterule = ""; //校验脚本
        this.propValues.instantvalidate = false; //即时校验（新增属性）


        this.propValues.hiddenscript = ""; //隐藏条件脚本
        this.propValues.hiddenvalue = ""; //隐藏时显示值
        this.propValues.hiddenprintscript = ""; //打印时隐藏条件脚本
        this.propValues.printhiddenvalue = ""; //打印隐藏时显示值
        this.propValues.readonlyscript = ""; //只读条件脚本
        
        this.propValues.departmentlevel=-1//可选
        this.propValues.relatedfield=""//上级部门联动字段
        this.propValues.limitbyuser="false"//仅显示当前用户所属部门及下属部门
        this.defaultoptiontype=16;//默认值

        this.propValues.allowempty=false//选项中包含空值
        this.propValues.fieldtype="VALUE_TYPE_VARCHAR";
        
    }
    getPropsDesc() {
        return {
            "base":['myselfrows','name','texttype','readonlyshowvalonly','refreshonchanged','refreshmode','refreshfields','calculateonrefresh','mobile','departmentlevel','relatedfield','limitbyuser','defaultoptiontype','allowempty','discript'],
            "value":['editmode','isdefaultvalue','valuescript','processdescription'],
            "check":['validatelibs','validaterule','instantvalidate'],
            "hidden":['hiddenscript','hiddenvalue'],
            "hiddenprint":["hiddenprintscript","printhiddenvalue"],
            "readonly":['readonlyscript']


        }
    }
    
}
export default DeptField;