import {Title, ColumnHeader, ColumnFooter, Detail, PageHeader, PageFooter, Summary,GroupFooter,GroupHeader} from '../report/chunk';
class XMLOperate {
  constructor(xml, report) {
    this.xml = xml;
    this.report = report;
    // this.flowDiagram._elems = [];
  }

  parserXML() {
	let chunk = [];
	let GH=[],GF=[];
	const report = this.report;
	const root = this.xml.children[0];
	let haveGroup=false;
	report.reportName = root.getAttribute('name') || '';
	
	report.id = root.getAttribute('uuid') || '';
	report.field = [];
	report.isIgnorePagination = root.getAttribute('isIgnorePagination') || false;

    report.width=parseInt(root.getAttribute("pageWidth"));
	report.pageHeight=parseInt(root.getAttribute("pageHeight"));
	report.subReportId=jQuery("#subReportId").val();
    const traversalNode = (xmlNode) => {
		//console.log(xmlNode);
		const { tagName } = xmlNode;
		//console.log(tagName);

        switch (tagName) {
			case 'title':
				const t = new Title(this.report.width, this.report.height);
				
				t.parseXML(xmlNode);
				chunk.push(t);
				break;
			case 'pageHeader':
				const ph = new PageHeader(this.report.width, this.report.height);
				ph.parseXML(xmlNode);
				chunk.push(ph);
				break;
			case 'columnHeader':
				const ch = new ColumnHeader(this.report.width, this.report.height);
				ch.parseXML(xmlNode);
				chunk.push(ch);
				break;
			case 'group':
				haveGroup=true;
				let tip=new Date().getTime();
				let name=xmlNode.getAttribute("name");
				console.log(xmlNode);
				let groupField="";
				const traversalNode2 = (xmlNode) => {
					const { tagName } = xmlNode;
					switch (tagName) {
						case 'groupExpression':
							groupField=xmlNode.innerHTML.replace(/\<\!\[CDATA\[/, '').replace(/\]\]\>/, '');
							break;
						case 'groupHeader':
							const gh = new GroupHeader(this.report.width, this.report.height);
							gh.field=groupField;
							gh.tip=tip;
							gh.name=name;
							gh.parseXML(xmlNode);
							GH.push(gh);
							break;
						case 'groupFooter':
							const gf = new GroupFooter(this.report.width, this.report.height);
							gf.tip=tip;
							gf.name=name;
							gf.parseXML(xmlNode);
							GF.push(gf);
							break;
					}
				}
				if(xmlNode.hasChildNodes()) {
					for(let i = 0;i < xmlNode.children.length;i++) {
						traversalNode2(xmlNode.children[i]);
					}
				}
				
				break;
			
			case 'detail':
				const d = new Detail(this.report.width, this.report.height);
				d.parseXML(xmlNode);
				chunk.push(d);
				break;
			case 'columnFooter':
				const cf = new ColumnFooter(this.report.width, this.report.height);
				cf.parseXML(xmlNode);
				chunk.push(cf);
				break;
			case 'pageFooter':
				const pf = new PageFooter(this.report.width, this.report.height);
				pf.parseXML(xmlNode);
				chunk.push(pf);
				break;
			case 'summary': 
				const s = new Summary(this.report.width, this.report.height);
				s.parseXML(xmlNode);
				chunk.push(s);
				break;
			default:
				report.parseOwnProperty(xmlNode);
				break;
        }
    };
	
	if(root.hasChildNodes()) {
		for(let i = 0;i < root.children.length;i++) {
			traversalNode(root.children[i]);
		}
	}
	if(haveGroup){
		let insertNum=null;
		for(let b=0;b<chunk.length;b++){
			if(chunk[b].scope=="Detail"){
				insertNum=b;
				break;
			}
		}
		GH.unshift(insertNum,0);
		Array.prototype.splice.apply(chunk, GH);
		for(let c=0;c<chunk.length;c++){
			if(chunk[c].scope=="Detail"){
				insertNum=c;
				break;
			}
		}
		GF.reverse();
		GF.unshift(insertNum+1,0);
		Array.prototype.splice.apply(chunk, GF);

		for(let d=0;d<chunk.length;d++){
			chunk[d].top=(d+1)*120;
		}
	}
	report.chunk = chunk;
	
    return chunk;
  }
}

export default XMLOperate;
