import ReportElement from './ReportElement';
import {Sequence, Archor} from '../../utility';

class Rectangle extends ReportElement {
	constructor() {
		super();
		this.belong = '';
		this.isOpenArchor = false;
		this.text='Rectangle';
		this.radius=0;
		// this.lineWidth=1;
		// this.lineStyle="Solid";
		// this.lineColor="#000000";
		// this.lineStyleOption={
		// 	"Solid":true,
		// 	"Dashed":false,
		// 	"Dotted":false,
		// 	"Double":false,
		// }
		this.key="矩形"
	}
	
	getClassName() {
		return 'rectangle';
	}
	
	getNodeConfigInfo() {
		let node = {};
		node.text = this.key==""?this.text:this.key;
		// `(${parseInt(this.x)}, ${parseInt(this.printedY)})`
		node.icon = 'glyphicon glyphicon glyphicon-unchecked';
		node.uuid = this.getProp('id');	
		node.instance = this;
		return node;
	}

	/**
	 * @param g
	 */
	paint(g) {
		let that=this;
		if(!this.id) {
			this.id = Sequence.createUuid();
		}
		var a=g.checkWH(this.width,this.height);
		this.width=a.w;
		this.height=a.h;
		if(2*this.radius>this.width || 2*this.radius>this.height){
			alert("四边形的圆角直径必须要小于四边形的宽高")
			return false;
		}
		g.save();	
		g.setColor(this.backcolor);
		g.setLineWidth(0.5);

		if(this.mode == 'Opaque') {
			g.setStyle(this.lineWidth,this.lineStyle,this.lineColor)
			// g.strokeRect(this.x, this.y, this.width, this.height);
			if(this.lineStyle=="Double"){
				g.strokeRect(this.x+this.lineWidth*2, this.y+this.lineWidth*2, this.width-this.lineWidth*4, this.height-this.lineWidth*4);
				g.fillRect(this.x+this.lineWidth*(5/2), this.y+this.lineWidth*(5/2), this.width-this.lineWidth*5, this.height-this.lineWidth*5);
			}else{
				g.drawRuondRect(this.x+this.lineWidth/2, this.y+this.lineWidth/2, this.width-this.lineWidth, this.height-this.lineWidth,parseInt(this.radius))
				g.stroke();
			}

			//g.fillRect(this.x+this.lineWidth/2, this.y+this.lineWidth/2, this.width-this.lineWidth, this.height-this.lineWidth);

		} else {
			g.setStyle(this.lineWidth,this.lineStyle,this.lineColor)
			g.drawRuondRect(this.x,this.y,this.width,this.height,parseInt(this.radius))
			g.stroke();
			//g.strokeRect(this.x, this.y, this.width, this.height);
			if(this.lineStyle=="Double"){
				//g.strokeRect(this.x+this.lineWidth*2, this.y+this.lineWidth*2, this.width-this.lineWidth*4, this.height-this.lineWidth*4);
				g.drawRuondRect(this.lineWidth*2, this.lineWidth*2, this.width-this.lineWidth*4, this.height-this.lineWidth*4,parseInt(this.radius));
				g.stroke();
			}
			//g.strokeRect(this.x+this.lineWidth, this.y+this.lineWidth, this.width-this.lineWidth*2, this.height-this.lineWidth*2);
		}
		g.setLineStyle();
		if(this.error){
			let img=new Image();
			img.src=this.errorImgSrc;
			img.onload=function(){
				g.drawImage(img,that.x,that.y,15,15);
			}

		}
		g.restore();
		
		if(this.isOpenArchor) {
			const archor = Archor.getInstance();
			const openArchor = [{x: 0, y: 0}, {x: 1, y: 0}, {x: 1, y: 1}, {x: 0, y: 1}]; //以当前元素左上角为坐标系，得(0, 0)为左上角，依次类推
			const params = {x: this.x, y: this.y, targetW: this.width, targetH: this.height, openArchorPos: openArchor};
			
			archor.setProps(params);	
			archor.paint(g);
		}
	}
	
	toXML() {
		
		let str = "<rectangle ";
		str +=`radius="${this.radius}"`
		str +=">\n"
		str += super.toXML();
		str +='<graphicElement>\n';


		str +=`<pen lineWidth="${this.lineWidth}.0" `

		str +=`lineStyle="${this.lineStyle}" `
		str +=`lineColor="${this.lineColor}"`
		str +=`/>\n`
		str +=`</graphicElement>\n`
		str += "</rectangle>\n";
		
		return str;
	}
	
	parseXML(xmlNode) {
		let props = {};
		let that = this;
		//console.log(xmlNode);
		this.radius=xmlNode.getAttribute("radius")
		const traversalNode = (xmlNode) => {

			const { tagName } = xmlNode;
			//console.log(tagName);

			switch (tagName) {
				case 'reportElement':
					const reportElement = this.handleReportElement(xmlNode);
					Object.assign(props, reportElement);
					break;
				case 'graphicElement':
					const children=xmlNode.children;
					if(children.length>0){
						that.lineWidth = parseInt(children[0].getAttribute('lineWidth'));
						that.lineStyle = children[0].getAttribute('lineStyle');
						that.lineColor = children[0].getAttribute('lineColor');
					}

					break;
				default:
					break;
			}
		};
		
		if(xmlNode.hasChildNodes()) {
			for(let i = 0;i < xmlNode.children.length;i++) {
				traversalNode(xmlNode.children[i]);
			}
		}

		this.setProps(props);

		return props;
	}
	
	// showTips(g) {
		// let tips = '';
		// tips += this.text;
		// this.drawTips(g, tips);
	// }
}

export default Rectangle;