import instance from './ajax';

/**
 * 获取contextPath
 */
export const getContextPath = () => {
  return contextPath;
};

export const getStaticPath = () => {
  return staticPath;
}

/**
 * 获取模块流程列表
 */
export const getModuleProcessList = (params, { onSucess, onError }) => {
  instance
    .get(contextPath + "/designtime/applications/modules/" + params.moduleId + "/workflows?name=" + params.name + "&pageNo=" + params.pageNo + "&linesPerPage=" + params.linesPerPage)
    .then(function(response) {
      if (onSucess) onSucess(response);
    })
    .catch(function(error) {
      if (onError) onError(error);
    });
};

/**
 * 复制流程
 */
export const copyProcess = (multipleSelectionId, { onSucess, onError }) => {
  instance({
    url: contextPath + "/designtime/applications/modules/workflows/copy",
    method: "POST",
    data: multipleSelectionId,
  })
    .then(function(response) {
      if (onSucess) onSucess(response);
    })
    .catch(function(error) {
      if (onError) onError(error);
    });
};

/**
 * 删除流程
 */
export const deleteWorkflows = (multipleSelectionId) => {
  return instance({
    url: contextPath + "/designtime/applications/modules/workflows",
    method: "delete",
    data: multipleSelectionId,
  })
};

/**
 * 获取统计图列表
 */
export const getChartsList = (params) => {
  return instance({
    url: contextPath + "/designtime/applications/modules/" + params.moduleId + "/charts?searchword=" + params.searchword + "&currpage=" + params.pageNo + "&pagelines=" + params.linesPerPage,
    method: 'get'
  })
};

/**
 * 获取统计图详情
 */
export const reqChartsDetail = (chartId) => {
  return instance({
    url: contextPath + "/designtime/applications/charts/" + chartId,
    method: 'get'
  })
};

/**
 * 新建统计图
 */
export const reqAddCharts = (params, dataObj) => {
  return instance({
    url: contextPath + "/designtime/applications/" + params.appId + "/modules/" + params.moduleId + "/charts",
    method: "post",
    data: dataObj,
  })
};

/**
 * 更新统计图scripttext
 */
export const reqUpdateChartsDetail = (dataObj) => {
  return instance({
    url: contextPath + "/designtime/applications/charts",
    method: "put",
    data: dataObj,
  })
};

/**
 * 删除统计图
 */
export const deleteCharts = (multipleSelectionId) => {
  return instance({
    url: contextPath + "/designtime/applications/charts",
    method: "delete",
    data: multipleSelectionId,
  })
};

/**
 * 获取报表列表
 */
export const getReportsList = (params, { onSucess, onError }) => {
  instance
    .get(contextPath + "/designtime/applications/modules/" + params.moduleId + "/reports?searchword=" + params.searchword + "&pageNo=" + params.pageNo + "&linesPerPage=" + params.linesPerPage)
    .then(function(response) {
      if (onSucess) onSucess(response);
    })
    .catch(function(error) {
      if (onError) onError(error);
    });
};

/**
 * 获取报表列表（可根据名字或者描述查询）
 */
export const getReportsListBySearch = (params, { onSucess, onError }) => {
  instance
    .get(
      contextPath + "/designtime/applications/modules/" + params.moduleId + "/reports?searchword=" + params.searchword + "&pageNo=" + params.pageNo + "&linesPerPage=" + params.linesPerPage + "&isPrint=" + params.isPrint
    )
    .then(function(response) {
      if (onSucess) onSucess(response);
    })
    .catch(function(error) {
      if (onError) onError(error);
    });
};

/**
 * 删除报表
 */
export const deleteReports = (multipleSelectionId) => {
  return instance({
    url: contextPath + "/designtime/applications/reports",
    method: "DELETE",
    data: multipleSelectionId,
  })
}
