var flowDiagram = window.OBPM.FlowDiagram;
var WorkFlowDesign = {};

WorkFlowDesign.Cache = {
  canvas: document.getElementById("workflows-canvas"),
  diagram: null,
};

WorkFlowDesign.Utils = {
  ajax: function (data) {
    return new Promise((resolve, reject) => {
      var xhr = new XMLHttpRequest();
      xhr.onreadystatechange = function () {
        if (xhr.readyState === 4) {
          if ((xhr.status >= 200 && xhr.status < 300) || xhr.status === 304) {
            // resolve(xhr.responseText);
            data.success(xhr.responseText);
          } else {
            reject(xhr.status);
          }
        } else {
          // HTTP请求还在继续...
        }
      };
      xhr.open(data.methods, data.url, true);
      xhr.setRequestHeader("content-type", "application/json");
      delete data.methods;
      delete data.url;
      xhr.send(JSON.stringify(data));
    });
  },
  encodeHTML: function (t) {
    if (t != null) {
      t = t.replace(/#/g, "%23");
      t = t.replace(/&/g, "&amp;");
      t = t.replace(/\"/g, "@quot;");
      t = t.replace(/</g, "@lt;");
      t = t.replace(/>/g, "@gt;");
      t = t.replace(/'/g, "@#146;");
      t = t.replace(/ /g, "@nbsp;");
      t = t.replace(/ /g, "@nbsp;");
      t = t.replace(/\r/g, "&#10;");
      t = t.replace(/\n/g, "&#13;");
    }
    return t;
  },

  dencodeHTML: function (t) {
    if (t != null) {
      t = t.replace(/&amp;/g, "&");
      t = t.replace(/@amp;/g, "&");
      t = t.replace(/&quot;/g, '"');
      t = t.replace(/@quot;/g, '"');
      t = t.replace(/&lt;/g, "<");
      t = t.replace(/@lt;/g, "<");
      t = t.replace(/&gt;/g, ">");
      t = t.replace(/@gt;/g, ">");
      t = t.replace(/&#146;/g, "'");
      t = t.replace(/@#146;/g, "'");
      t = t.replace(/&nbsp;/g, " ");
      t = t.replace(/@nbsp;/g, " ");
      t = t.replace(/&#10;/g, "\r");
      t = t.replace(/&#13;/g, "\n");
      t = t.replace(/&#9;/g, " ");
      t = t.replace(/%23/g, "#");
      t = t.replace(/\n\r/g, "\n");
      t = t.replace(/\r\n/g, "\n");
    }
    return t;
  },
};

WorkFlowDesign.Core = {
  init: function () {
    this.initCanvas();
    this.bindEvent();

    var diagramReady = setInterval(function () {
      var diagram = WorkFlowDesign.Cache.diagram;
      if (diagram) {
        clearInterval(diagramReady);
        WorkFlowDesign.Core.renderEditPanel();
        WorkFlowDesign.Core.operateXML();
      }
    }, 1000);
  },
  initCanvas() {
    var canvas = WorkFlowDesign.Cache.canvas;
    WorkFlowDesign.Cache.diagram = new flowDiagram(canvas);
    WorkFlowDesign.Cache.diagram.Init();
  },

  operateXML() {
    var diagram = WorkFlowDesign.Cache.diagram;
    var xml = $.trim($("#flow_container").val());
    // if (xml != "") {
      diagram.XMLOperate(xml);
    // }
  },

  bindEvent() {
    // xh 给右边的节点列表和保存退出按钮绑定事件及一系列操作
    var diagram = WorkFlowDesign.Cache.diagram;
    var $activityBar = $(".workflows-activitybar");
    var $topBar = $(".workflows-topbar");
    var $setPanel = $(".workflows-setting");
    var $flowContainer = $("#flow_container");
    var $toolBar = $(".workflows-toolbar")

    $("#workflows-canvas").on("click drop", function () {
      WorkFlowDesign.Core.renderEditPanel();
    });

    $topBar.find(".activity-save").on("click", function () {
      // yx 判断流程面板有没有特殊符号
      let $subject = $("[name='content.subject']")[0].value;
      const regText = /^[\u4e00-\u9fa5_a-zA-Z0-9]+$/g;
      if ($subject == "") {
        alert("流程面板主题不能为空");
        return false;
      } else if (!regText.test($subject)) {
        alert("流程面板主题不能有特殊符号");
        return false;
      }
      
      //WorkFlowDesign.Core.savePropWithEditNode();
      $flowContainer.val(diagram.toXML());
      //tiga 判断当前流程是否有两个及以上的开始节点
      var reg=/(<cn.myapps.runtime.workflow.element.StartNode.*?>)/g
      if(((diagram.toXML()).match(reg)).length>=2){
        alert('不可以同时保存两个开始节点')
        return false;
      }
      var result = diagram.check();
      console.log(result);
      if (!result) {
        return false;
      }
      ev_onsubmit();
    });

    $topBar.find(".activity-exit").on("click", function () {
      ev_onexit("exit");
    });
    //tiga 添加拖拽事件
    $activityBar.find(".activity-start").on({
      click: function () {diagram.addStartNode();},
      dragstart:function(){diagram.addStartNode();}
      });

    $activityBar.find(".activity-complete").on({
      click: function () { diagram.addCompleteNode();},
      dragstart:function(){diagram.addCompleteNode();},
    });
    // yx添加网关节点
    $activityBar.find(".activity-gateway").on("click", function () {
      diagram.addGatewayNode();
    });

    $activityBar.find(".activity-auto").on({
      click: function () {diagram.addAutoNode();},
      dragstart:function(){diagram.addAutoNode();},
    });

    $activityBar.find(".activity-manual").on({
      click:function () {diagram.addManualNode();},
      dragstart:function(){diagram.addManualNode();}
    });

    $activityBar.find(".activity-subflow").on({
      click: function () {diagram.addSubFlow();},
      dragstart:function(){diagram.addSubFlow();}
    });

    $activityBar.find(".activity-relation").on("click", function () {
      diagram.addRelation();
    });

    $activityBar.find(".activity-big").on("click", function () {
      diagram.bigCanvas();
    });

    $activityBar.find(".activity-small").on("click", function () {
      diagram.smallCanvas();
    });

    $activityBar.find(".activity-eraser").on("click", function () {
      diagram.removeElement();
    });
    // 垂直居中
    $toolBar.find(".alignVertical").on("click", function () {
      diagram.alignVerticalCenter();
    });
    // 左对齐
    $toolBar.find(".alignLeft").on("click", function () {
      diagram.alignLeft();
    });
    // 右对齐
    $toolBar.find(".alignRight").on("click", function () {
      diagram.alignRight();
    });
    // 水平居中
    $toolBar.find(".alignHorizontal").on("click", function () {
      diagram.alignHorizontalCenter();
    });
    // 上对齐
    $toolBar.find(".alignTop").on("click", function () {
      diagram.alignTop();
    });
    // 底部对齐
    $toolBar.find(".alignBottom").on("click", function () {
      diagram.alignBottom();
    });
  },

  renderEditPanel() {
    var diagram = WorkFlowDesign.Cache.diagram;
    var $setPanel = $(".workflows-setting");
    var $setTitlePanel = $setPanel.find(".edit-title");
    var $setTitle = $setTitlePanel.find(".edit-title-txt");
    var $setContentPanel = $setPanel.find(".edit-content");
    var $html = "";
    var currToEdit = diagram.getCurrToEdit();

    if (currToEdit == null) {
      $setTitle.text("流程信息");
      var $subject = $("[name='content.subject']");
      var $authorname = $("#authorname");
      var flowDiagramData = {
        subject: $subject.val(),
        authorname: $authorname.val(),
      };
      $html = $(template("editflowdiagram-tmpl", flowDiagramData));

      $html.find("button[name='showCode']").on("click", function () {
        var $xmlContent = $("#xmlcontent");
        var $flowContainer = $xmlContent.find("#flow_container");
        $flowContainer.val(diagram.toXML());

        var $xmlDialog = $("#xmlcontent").clone();
        var $flowDialog = $xmlDialog.find("#flow_container");
        $xmlDialog.removeClass("d-none").dialog({
          title: "源代码",
          modal: true,
          buttons: {
            确定: function () {
              $flowContainer.val($flowDialog.val());
              WorkFlowDesign.Core.operateXML($flowDialog.val());
              $(this).dialog("close");
            },
            取消: function () {
              $(this).dialog("close");
            },
          },
        });
      });
    } else {
      var currToEditName = currToEdit.getClassName();
      var allSplitNodeArr = diagram.getAllSplitNode(currToEdit)
      var splitStartOptions = allSplitNodeArr.arrayColleaction;
      var backupSplitStartOptions = allSplitNodeArr.arrayColleaction.splice(1)
      var currToEditInput = allSplitNodeArr.input;
      
      switch (currToEditName) {
        case "cn.myapps.runtime.workflow.element.StartNode":
          $setTitle.text("开始节点信息");
          var startNodeData = {
            name: currToEdit.name,
            statelabel: currToEdit.statelabel,
          };
          $html = $(template("editstartnode-tmpl", startNodeData));
          break;
        case "cn.myapps.runtime.workflow.element.CompleteNode":
          $setTitle.text("完成节点信息");
          var completeNodeData = {
            name: currToEdit.name,
            statelabel: currToEdit.statelabel,
            orderNum: currToEdit.orderNum,
            isgather: currToEdit.isgather,
            splitStartNode: currToEdit.splitStartNode,
            splitStartOptions: currToEditInput > 1 ?  backupSplitStartOptions : splitStartOptions,
            isAutoArchive: currToEdit.isAutoArchive,
          };
          $html = $(template("editcompletenode-tmpl", completeNodeData));

          $html.find("input[type='radio']").on("change", function () {
            WorkFlowDesign.Core.changeEditContentPanel(this);
          });
          break;
        case "cn.myapps.runtime.workflow.element.GatewayNode":
          $setTitle.text("网关节点信息");
          var gatewayNodeData = {
            name: currToEdit.name,
            statelabel: currToEdit.statelabel,
            orderNum: currToEdit.orderNum,
            isgather: currToEdit.isgather,
            issplit: currToEdit.issplit,
            splitStartNode: currToEdit.splitStartNode,
            splitStartOptions: splitStartOptions,
          };
          $html = $(template("editgatewaynode-tmpl", gatewayNodeData));
          break;
        case "cn.myapps.runtime.workflow.element.AutoNode":
          $setTitle.text("自动节点信息");
          var autoNodeData = {
            name: currToEdit.name,
            statelabel: currToEdit.statelabel,
            orderNum: currToEdit.orderNum,
            isgather: currToEdit.isgather,
            isAutoArchive: currToEdit.isAutoArchive,
            auditDateTime: currToEdit.auditDateTime,
            issplit: currToEdit.issplit,
            autoAuditType: currToEdit.autoAuditType,
            delayDay: currToEdit.delayDay,
            delayHour: currToEdit.delayHour,
            delayMinute: currToEdit.delayMinute,
            splitStartNode: currToEdit.splitStartNode,
            splitStartOptions: currToEditInput > 1 ?  backupSplitStartOptions : splitStartOptions,
            autoAuditTimeEditMode: currToEdit.autoAuditTimeEditMode,
            auditDateTimeScript: currToEdit.auditDateTimeScript,
          };
          $html = $(template("editautonode-tmpl", autoNodeData));

          $html.find("button[name='iscriptEdit']").on("click", function () {
            var $this = $(this);
            var title = $this.attr("title");
            var fieldName = $this.data("fieldname");
            var str = '{"nodeId": "' + currToEdit.id + '" ,"fieldName":"' + fieldName + '","label":"' + title + '"}';
            flexOpenIsCriptEditor(str, currToEdit.auditDateTimeScript, currToEditName, currToEdit);
          });

          $html.find("input[type='radio']").on("change", function () {
            WorkFlowDesign.Core.changeEditContentPanel(this);
          });
          $html.find("input[name='auditDateTime']").on("blur", function () {
            WorkFlowDesign.Core.savePropWithEditNode();
          });
          break;
        case "cn.myapps.runtime.workflow.element.ManualNode":
          $setTitle.text("人工节点信息");
          var retracementSet = 1;
          if (currToEdit.retracementScript != "") {
            retracementSet = 3;
          } else if (!currToEdit.cRetracement && currToEdit.retracementEditMode == 0) {
            retracementSet = 2;
          }
          var handupSet = 1;
          if (currToEdit.handupScript != "") {
            handupSet = 3;
          } else if (!currToEdit.isHandup && currToEdit.handupEditMode == 0) {
            handupSet = 2;
          }
          var allowUrgeSet = 1;
          if (currToEdit.allowUrge2ApprovalScript != "") {
            allowUrgeSet = 3;
          } else if (!currToEdit.allowUrge2Approval && currToEdit.urge2ApprovalEditMode == 0) {
            allowUrgeSet = 2;
          }

          var bnodelistOptions = diagram.getAllBeforeNode(currToEdit, currToEdit.ispassed);
          var nameListShow = "";
          var nameList = currToEdit.namelist;
          if (currToEdit.namelist != "" && currToEdit.namelist.substr(0, 1) == "(") {
            var regexp = /(?<=R)[a-zA-Z0-9_\\-]*(?=|)+/g;
            // 获取原来的数组
            let nameArr = currToEdit.namelist.match(regexp)
            // 得到新名字的数组
            let tempNameArr = []

            $.ajax({
              cache: false,
              async: false,   // 太关键了，学习了，同步和异步的参数
              type: 'get',
              url: `${params.contextPath}/designtime/applications/${sessionStorage.getItem('appId')}/roles?name=&pageNo=1&linesPerPage=10000`,
              success: function (data){ 
                const roleArr = data.data.datas
                nameArr.forEach(item => {
                  for(let i = 0; i < roleArr.length; i++){
                    if(item == roleArr[i].id){
                      tempNameArr.push(roleArr[i].name)
                      break;
                    }
                  }
                })
                nameListShow = tempNameArr.join(';')+';'
              }
            })
          }
          var circulatorNamelistShow = "";
          var circulatorNamelist = currToEdit.circulatorNamelist;
          if (currToEdit.circulatorNamelist != "" && currToEdit.circulatorNamelist.substr(0, 1) == "(") {
            var regexp = /R[a-zA-Z0-9_\\-]*\|/g;
            circulatorNamelistShow = circulatorNamelist.substr(1, circulatorNamelist.length - 2).replace(regexp, "");
          }

          var assistNamelistShow = "";
          var assistNamelist = currToEdit.assistNamelist;
          if (currToEdit.assistNamelist != "" && currToEdit.assistNamelist.substr(0, 1) == "(") {
            var regexp = /R[a-zA-Z0-9_\\-]*\|/g;
            assistNamelistShow = assistNamelist.substr(1, assistNamelist.length - 2).replace(regexp, "");
          }
          if (currToEdit.orgScope == "undefined") {
            currToEdit.orgScope = "self";
          }
          //设置组织角色的显示
          var orgRoleCondition = currToEdit.orgRoleCondition;
          var orgRoleConditionShow = "";
          if (orgRoleCondition) {
            var orgRoleConditionStr = orgRoleCondition;
            //(R11e5-09cc-fbb946fa-8684-eb1d8d022f03|区域总监助理;R11e5-02a2-55a7dca8-beef-eb12388d88a8|区域经理;)
            //去除首部(
            if (orgRoleConditionStr[0] == "(") {
              orgRoleConditionStr = orgRoleConditionStr.substr(1, orgRoleConditionStr.length - 1);
            }
            //去除尾部)
            if (orgRoleConditionStr[orgRoleConditionStr.length - 1] == ")") {
              orgRoleConditionStr = orgRoleConditionStr.substr(0, orgRoleConditionStr.length - 1);
            }
            //去除尾部;
            if (orgRoleConditionStr[orgRoleConditionStr.length - 1] == ";") {
              orgRoleConditionStr = orgRoleConditionStr.substr(0, orgRoleConditionStr.length - 1);
            }
            if (orgRoleConditionStr) {
              var orgRoleConditionStrArray = orgRoleConditionStr.split(";");
              for (var orgRoleConditionIndex = 0; orgRoleConditionIndex < orgRoleConditionStrArray.length; orgRoleConditionIndex++) {
                var orgRoleConditionItem = orgRoleConditionStrArray[orgRoleConditionIndex];
                var orgRoleConditionItemNames = orgRoleConditionItem.split("|");
                if (orgRoleConditionItemNames != null && orgRoleConditionItemNames.length > 1) {
                  orgRoleConditionShow += orgRoleConditionItemNames[1] + ";";
                }
              }
            }
          }
          var notificationStrategyJSON = currToEdit.notificationStrategyJSON.substr(0, 1) == "{" ? JSON.parse(WorkFlowDesign.Utils.dencodeHTML(currToEdit.notificationStrategyJSON)) : "";
          var editMode = notificationStrategyJSON && notificationStrategyJSON.overdue && notificationStrategyJSON.overdue.editMode ? notificationStrategyJSON.overdue.editMode : "";
          var manualNodeData = {
            id: currToEdit.id,
            name: currToEdit.name,
            scale: currToEdit.scale,
            note: currToEdit.note,
            x: currToEdit.x,
            y: currToEdit.y,
            width: currToEdit.width,
            height: currToEdit.height,
            m_width: currToEdit.m_width,
            m_height: currToEdit.m_height,
            prenodeid: currToEdit.prenodeid,
            statelabel: currToEdit.statelabel,
            orderNum: currToEdit.orderNum,
            backnodeid: currToEdit.backnodeid,
            formname: currToEdit.formname,
            fieldpermlist: currToEdit.fieldpermlist,
            isstartandnext: currToEdit.isstartandnext,
            _iscurrent: currToEdit._iscurrent,
            actorListScript: currToEdit.actorListScript,

            jumpNameScript: currToEdit.jumpNameScript,
            jump: currToEdit.jump,
            jumpTo: currToEdit.jumpTo,

            actorEditMode: currToEdit.actorEditMode,
            deptList: currToEdit.deptlist,
            nameList: nameList,
            nameListShow: nameListShow,
            realnamelist: currToEdit.realnamelist,
            passcondition: currToEdit.passcondition,
            approverNumType: currToEdit.approverNumType,

            isApproverEdit: currToEdit.isApproverEdit,
            approverEditScript: currToEdit.approverEditScript,
            isCoApproverEdit: currToEdit.isCoApproverEdit,
            coApproverEditScript: currToEdit.coApproverEditScript,
            isSupplementComments: currToEdit.isSupplementComments,
            exceedaction: currToEdit.exceedaction,
            issetcurruser: currToEdit.issetcurruser,
            inputform: currToEdit.inputform,
            isgather: currToEdit.isgather,
            issplit: currToEdit.issplit,
            cBack: currToEdit.cBack,
            splitStartNode: currToEdit.splitStartNode,
            splitStartOptions: currToEditInput > 1 ?  backupSplitStartOptions : splitStartOptions,
            isFrontEdit: currToEdit.isFrontEdit,
            backType: currToEdit.backType,
            isToPerson: currToEdit.isToPerson,
            checkedOnSinglePerson: currToEdit.checkedOnSinglePerson,
            checkedOnMultiplePerson: currToEdit.checkedOnMultiplePerson,


            bnodelist: currToEdit.bnodelist,
            bnodelistOptions: bnodelistOptions,
            retracementEditMode: currToEdit.retracementEditMode,
            cRetracement: currToEdit.cRetracement,
            retracementScript: currToEdit.retracementScript,
            notificationStrategyJSON: notificationStrategyJSON,
            isCarbonCopy: currToEdit.isCarbonCopy,
            isSelectCirculator: currToEdit.isSelectCirculator,
            circulatorEditMode: currToEdit.circulatorEditMode,
            circulatorListScript: currToEdit.circulatorListScript,
            circulatorNamelist: currToEdit.circulatorNamelist,
            circulatorNamelistShow: circulatorNamelistShow,
            userList: currToEdit.userList,
            circulatorNamelistByUser: currToEdit.circulatorNamelistByUser,
            orgField: currToEdit.orgField,
            orgScope: currToEdit.orgScope,
            orgRoleCondition: currToEdit.orgRoleCondition,
            orgRoleConditionShow: orgRoleConditionShow,
            isLimited: currToEdit.isLimited,
            timeLimitEditMode: currToEdit.timeLimitEditMode,
            timeLimitDay: currToEdit.timeLimitDay,
            timeLimitHour: currToEdit.timeLimitHour,
            timeLimitMinute: currToEdit.timeLimitMinute,
            timeLimitScript: currToEdit.timeLimitScript,
            isUsbKeyVerify: currToEdit.isUsbKeyVerify,
            roleCondition: currToEdit.roleCondition,
            handupEditMode: currToEdit.handupEditMode,
            isHandup: currToEdit.isHandup,
            handupScript: currToEdit.handupScript,
            isAllowEditAuditor: currToEdit.isAllowEditAuditor,
            allowEditAuditorScript: currToEdit.allowEditAuditorScript,
            isAllowTermination: currToEdit.isAllowTermination,
            activityPermList: currToEdit.activityPermList,
            urge2ApprovalEditMode: currToEdit.urge2ApprovalEditMode,
            allowUrge2Approval: currToEdit.allowUrge2Approval,
            allowUrge2ApprovalScript: currToEdit.allowUrge2ApprovalScript,
            isAllowSkip: currToEdit.isAllowSkip,
            nextNodeCheckedStatus: currToEdit.nextNodeCheckedStatus,
            handupSet: handupSet,
            retracementSet: retracementSet,
            allowUrgeSet: allowUrgeSet,
            //彩生活
            isAssist: currToEdit.isAssist,
            isSelectAssistUser: currToEdit.isSelectAssistUser,
            assistEditMode: currToEdit.assistEditMode,
            assistListScript: currToEdit.assistListScript,
            assistNamelist: currToEdit.assistNamelist,
            assistNamelistShow: assistNamelistShow,
            assistNamelistByUser: currToEdit.assistNamelistByUser,
            isAssist: currToEdit.isAssist,
          };
          $html = $(template("editmanualnode-tmpl", manualNodeData));
          if (editMode != "" && editMode == 0) {
            $html.find("#designName").removeClass("d-none");
          } else if (editMode == 1) {
            $html.find("#scriptName").removeClass("d-none");
          }
          console.log("params", params);
          //dwr异步获取摘要
          var getFormSummaryData = {
            methods: "get",
            url: `${params.contextPath}/designtime/applications/${applicationId}/summarys?formId=&pageNo=1&linesPerPage=100000`,
            success: function (result) {
              if (result && result != null && result != "") {
                var summaries = JSON.parse(result).data.data;
                var checkSummary = function (notificationStrategyJSON, id, formName, name, type) {
                  var selectStr = "<option value='" + id + "'>" + formName + "--->" + name + "</option>";
                  for (var key in notificationStrategyJSON) {
                    if (id != "" && type == key && notificationStrategyJSON[key].template == id) {
                      selectStr = "<option value='" + id + "' selected>" + formName + "--->" + name + "</option>";
                    }
                  }
                  return selectStr;
                };
                var select = document.createElement("OPTION");
                select.setAttribute("value", "");
                select.innerHTML = "--select--";
                $("select[name='templateOfSend']").append(select);
                for (var i = 0; i < summaries.length; i++) {
                  var summaryId = summaries[i].id;
                  var $sendTemp = $("select[name='templateOfSend']");
                  // yx[表单摘要中的流程通知才要加进去]
                  if (summaries[i].scope == "01" || (summaries[i].scope == "00" && summaries[i].type == 1)) {
                    //提交
                    var sendOption = checkSummary(notificationStrategyJSON, summaryId, summaries[i].formName, summaries[i].name, "send");
                    $sendTemp.append(sendOption);

                    //到达
                    var $arriveTemp = $("select[name='templateOfArrive']");
                    var arriveOption = checkSummary(notificationStrategyJSON, summaryId, summaries[i].formName, summaries[i].name, "arrive");
                    $arriveTemp.append(arriveOption);
                    //回退
                    var $rejectTemp = $("select[name='templateOfReject']");
                    var rejectOption = checkSummary(notificationStrategyJSON, summaryId, summaries[i].formName, summaries[i].name, "reject");
                    $rejectTemp.append(rejectOption);
                    //过期
                    var $overdueTemp = $("select[name='templateOfOverdue']");
                    var overdueOption = checkSummary(notificationStrategyJSON, summaryId, summaries[i].formName, summaries[i].name, "overdue");
                    $overdueTemp.append(overdueOption);
                    //催办
                    var $carbonCopyTemp = $("select[name='templateOfCarbonCopy']");
                    var carbonCopyOption = checkSummary(notificationStrategyJSON, summaryId, summaries[i].formName, summaries[i].name, "carbonCopy");
                    $carbonCopyTemp.append(carbonCopyOption);
                    //彩生活-协办
                    var $assistTemp = $("select[name='templateOfAssist']");
                    var assistOption = checkSummary(notificationStrategyJSON, summaryId, summaries[i].formName, summaries[i].name, "assist");
                    $assistTemp.append(assistOption);
                  }
                }
              }
            },
          };

          WorkFlowDesign.Utils.ajax(getFormSummaryData);

          $html.find("button[name='selectForm']").on("click", function () {
            selectForm(currToEditName, currToEdit);
          });

          $html.find("button[name='selectRole']").on("click", function () {
            var fieldname = $(this).data("fieldname");
            selectRole(currToEditName, currToEdit, fieldname);
          });
          $html.find("button[name='iscriptEdit']").on("click", function () {
            var $this = $(this);
            var title = $this.attr("title");
            var fieldName = $this.data("fieldname");
            var str = '{"nodeId": "' + currToEdit.id + '" ,"fieldName":"' + fieldName + '","label":"' + title + '"}';

            if(fieldName === "limittimeScriptOfOverdue") {
              let notificationStrategyJSON = JSON.parse(WorkFlowDesign.Utils.dencodeHTML(currToEdit.notificationStrategyJSON));
              currToEdit.limittimeScriptOfOverdue = notificationStrategyJSON.overdue.limittimeScript
            }

            flexOpenIsCriptEditor(str, currToEdit[fieldName], currToEditName, currToEdit);
          });
          $html.find("input[type='radio'], input[type='checkbox'], select").on("change", function () {
            WorkFlowDesign.Core.changeEditContentPanel(this);
          });
          break;
        case "cn.myapps.runtime.workflow.element.SubFlow":
          $setTitle.text("子流程信息");
          var subFLowData = {
            name: currToEdit.name, //名称
            statelabel: currToEdit.statelabel, //状态标签
            orderNum: currToEdit.orderNum, //排序号
            subFlowDefiType: currToEdit.subFlowDefiType, //指定子流程
            subflowid: currToEdit.subflowid, //子流程ID
            subflowname: currToEdit.subflowname, //子流程名称
            subflowScript: currToEdit.subflowScript, //指定子流程脚本
            //启动
            isToPerson: currToEdit.isToPerson, //由子流程启动人设定该子流程第一个人工节点的审批人
            checkedOnSinglePerson: currToEdit.checkedOnSinglePerson, //只有一个审批人的时候，是否默认选中审批人
            checkedOnMultiplePerson: currToEdit.checkedOnMultiplePerson, //只有一个审批人的时候，是否默认选中审批人

            numberSetingType: currToEdit.numberSetingType, //启动实例方式
            numberSetingContent: currToEdit.numberSetingContent, //实例数内容
            paramPassingType: currToEdit.paramPassingType, //传递参数类型
            paramPassingScript: currToEdit.paramPassingScript, //传递参数脚本
            parentFlowFormId: currToEdit.parentFlowFormId, //父流程表单ID
            parentFlowFormName: currToEdit.parentFlowFormName, //父流程表单名称
            subFlowFormId: currToEdit.subFlowFormId, //子流程表单ID
            subFlowFormName: currToEdit.subFlowFormName, //子流程表单名称
            //审批设置
            isgather: currToEdit.isgather,
            splitStartNode: currToEdit.splitStartNode,
            splitStartOptions: currToEditInput > 1 ?  backupSplitStartOptions : splitStartOptions,
            issplit: currToEdit.issplit,
            //参数传递
            fieldMappingXML: currToEdit.fieldMappingXML, //传递参数方式
            //流程等待
            callback: currToEdit.callback, //是否回调
            callbackScript: currToEdit.callbackScript, //回调脚本
          };
          $html = $(template("editsubflow-tmpl", subFLowData));

          $html.find("button[name='selectForm']").on("click", function () {
            selectForm(currToEditName, currToEdit);
          });

          $html.find("button[name='selectSubFlow']").on("click", function () {
            selectSubFlow(currToEditName, currToEdit);
          });

          $html.find("button[name='selectParentFlowForm']").on("click", function () {
            selectParentFlowForm(currToEditName, currToEdit);
          });

          $html.find("button[name='iscriptEdit']").on("click", function () {
            var $this = $(this);
            var title = $this.attr("title");
            var fieldName = $this.data("fieldname");
            var str = '{"nodeId": "' + currToEdit.id + '" ,"fieldName":"' + fieldName + '","label":"' + title + '"}';
            flexOpenIsCriptEditor(str, currToEdit[fieldName], currToEditName, currToEdit);
          });
          $html.find("input[type='radio'], input[type='checkbox'], select").on("change", function () {
            WorkFlowDesign.Core.changeEditContentPanel(this);
          });
          $html.find("#Paramstransfer").on("click", function () {
            var fieldMappingXML = $html.find("input[name='fieldMappingXML']").val();
            var paramPassingType = $html.find("input[name='paramPassingType']").val();

            var paramPassingScript = $html.find("input[name='paramPassingScript']").val();
            var parentFlowFormId = $html.find("input[name='parentFlowFormId']").val();
            var parentFlowFormName = $html.find("input[name='parentFlowFormName']").val();
            var subFlowFormId = $html.find("input[name='subFlowFormId']").val();
            var subFlowFormName = $html.find("input[name='subFlowFormName']").val();
            currToEdit.fieldMappingXML = fieldMappingXML;
            currToEdit.paramPassingType = paramPassingType;

            currToEdit.paramPassingScript = paramPassingScript;
            currToEdit.parentFlowFormId = parentFlowFormId;
            currToEdit.parentFlowFormName = parentFlowFormName;
            currToEdit.subFlowFormId = subFlowFormId;
            currToEdit.subFlowFormName = subFlowFormName;
            editSubflow(currToEditName, currToEdit);
          });

          $html.find("#numberSetingContentSelect").on("change", function () {
            WorkFlowDesign.Core.editSubFlow(currToEdit);
          });
          var moduleid = $("input[name='_moduleid'").val();
          var parentFlowFormId = currToEdit.parentFlowFormId;
          //dwr异步获取摘要
          if (parentFlowFormId != "") {
            var getFormSummaryData = {
              methods: "get",
              url: `../${params.contextPath}/designtime/applications/modules/forms/${parentFlowFormId}`,
              success: function (result) {
                if (result && result != null && result != "") {
                  var resultObj = JSON.parse(result);
                  var $parentSelect = $("select[name='numberSetingContentSelect']");
                  var numberSetingContent = currToEdit.numberSetingContent;
                  $parentSelect.html("");
                  if (resultObj.formFields.length > 0) {
                    var option = "";
                    for (var j = 0; j < resultObj.formFields.length; j++) {
                      var field = resultObj.formFields[j];
                      var valuetype = field.valuetype ? field.valuetype : "";
                      option = "<option value='" + valuetype + "'>" + field.name + "</option>";
                      if (currToEdit.numberSetingContent == field.name) {
                        option = "<option selected value='" + valuetype + "'>" + field.name + "</option>";
                      }
                      $parentSelect.append(option);
                    }
                  }
                }
              },
            };

            // WorkFlowDesign.Utils.ajax(getFormSummaryData)

            //  BillDefiHelper.flexGetFormFields(parentFlowFormId, function(result){
            //      if(result && result != null && result != ""){
            //          var resultObj = JSON.parse(result);
            //          var $parentSelect = $("select[name='numberSetingContentSelect']");
            //          var numberSetingContent= currToEdit.numberSetingContent;
            //          $parentSelect.html('');
            //          if(resultObj.formFields.length>0){
            //          	var option = ""
            //              for(var j = 0; j < resultObj.formFields.length; j++){
            //                  var field = resultObj.formFields[j];
            //                  var valuetype = field.valuetype ? field.valuetype : "";
            //                  option = "<option value='"+valuetype+"'>"+field.name+"</option>";
            //                  if(currToEdit.numberSetingContent == field.name){
            //                      option = "<option selected value='"+valuetype+"'>"+field.name+"</option>";
            //                  }
            //                  $parentSelect.append(option);
            //              }
            //          }
            //      }
            //  });
          }
          break;
        case "cn.myapps.runtime.workflow.element.Relation":
          $setTitle.text("关联线信息");
          var node = diagram.getElementByID(currToEdit.startnodeid);
          var relationData = {
            isStart: node.getClassName() == "cn.myapps.runtime.workflow.element.StartNode" ? true : false,
            name: currToEdit.name,
            condition: currToEdit.condition,
            action: currToEdit.action,
            validateScript: currToEdit.validateScript,
            filtercondition: currToEdit.filtercondition,
            editMode: currToEdit.editMode,
            processDescription: currToEdit.processDescription,
            formlist: currToEdit.formlist,
          };
          $html = $(template("editrelation-tmpl", relationData));

          $html.find("button[name='relationEdit']").on("click", function () {
            editRelation(currToEditName, currToEdit);
          });

          $html.find("button[name='iscriptEdit']").on("click", function () {
            var $this = $(this);
            var title = $this.attr("title");
            var fieldName = $this.data("fieldname");
            var str = '{"nodeId": "' + currToEdit.id + '" ,"fieldName":"' + fieldName + '","label":"' + title + '"}';
            flexOpenIsCriptEditor(str, currToEdit[fieldName], currToEditName, currToEdit);
          });

          $html.find("input[type='radio'], input[type='checkbox'], select").on("change", function () {
            WorkFlowDesign.Core.changeEditContentPanel(this);
          });
          break;
        default:
          break;
      }
    }

    $html.find("input:checkbox,input:radio").on("change", function () {
      WorkFlowDesign.Core.savePropWithEditNode();
    });
    $html.on("input", function () {
      WorkFlowDesign.Core.savePropWithEditNode();
    });

    $setContentPanel.html($html);
  },
  editStartNode(editNode) {
    var diagram = WorkFlowDesign.Cache.diagram;
    var $setPanel = $(".workflows-setting");
    var name = $setPanel.find("input.name").val();
    var statelabel = $setPanel.find("input.statelabel").val();
    diagram.editStartNode(editNode, editNode.id, name, statelabel, editNode.x, editNode.y);
  },
  editCompleteNode(editNode) {
    var diagram = WorkFlowDesign.Cache.diagram;
    var $setPanel = $(".workflows-setting");
    var name = $setPanel.find("input.name").val();
    var statelabel = $setPanel.find("input.statelabel").val();
    var orderNum = $setPanel.find("input.orderNum").val();

    var isgather = $setPanel.find("[name='isgather']:checked").val() == "true" ? true : false;
    var splitStartNode = "";
    if (isgather) {
      splitStartNode = $setPanel.find("[name='splitStartNode']").val();
    }
    var isAutoArchive = $setPanel.find("[name='isAutoArchive']").is(":checked") ? true : false;
    diagram.editCompleteNode(editNode, editNode.id, name, statelabel, orderNum, editNode.x, editNode.y, isgather, splitStartNode, isAutoArchive);
  },
  editGatewayNode(editNode) {
    var diagram = WorkFlowDesign.Cache.diagram;
    var $setPanel = $(".workflows-setting");
    var name = $setPanel.find("input.name").val();
    var statelabel = $setPanel.find("input.statelabel").val();
    var issplit = $setPanel.find("[name='issplit']:checked").val() == "true" ? true : false;
    var isgather = $setPanel.find("[name='isgather']:checked").val() == "true" ? true : false;
    var splitStartNode = "";
    diagram.editGatewayNode(editNode, editNode.id, name, statelabel, editNode.x, editNode.y, issplit, isgather, splitStartNode);
  },
  editAutoNode(editNode) {
    var diagram = WorkFlowDesign.Cache.diagram;
    var $setPanel = $(".workflows-setting");
    var name = $setPanel.find("input.name").val();
    var statelabel = $setPanel.find("input.statelabel").val();
    var orderNum = $setPanel.find("input.orderNum").val();
    var issplit = $setPanel.find("[name='issplit']:checked").val() == "true" ? true : false;
    var isgather = $setPanel.find("[name='isgather']:checked").val() == "true" ? true : false;
    var splitStartNode = "";
    if (isgather) {
      splitStartNode = $setPanel.find("[name='splitStartNode']").val();
    }
    var autoAuditTimeEditMode = parseInt($setPanel.find("[name='autoAuditTimeEditMode']:checked").val());
    var autoAuditType = "";
    var auditDateTimeScript = "";
    var auditDateTime = "";
    var delayDay = "";
    var delayHour = "";
    var delayMinute = "";

    if (autoAuditTimeEditMode == 1) {
      autoAuditType = parseInt($setPanel.find("[name='autoAuditType']:checked").val());
      if (autoAuditType == 2) {
        auditDateTime = $setPanel.find("[name='auditDateTime']").val();
        if (auditDateTime && typeof auditDateTime === "string") {
          auditDateTime = auditDateTime.replace(/[a-zA-Z]+/g, " ");
        }
      } else if (autoAuditType == 3) {
        delayDay = $setPanel.find("[name='delayDay']").val();
        delayHour = $setPanel.find("[name='delayHour']").val();
        delayMinute = $setPanel.find("[name='delayMinute']").val();
      }
    } else {
      auditDateTimeScript = $setPanel.find("textarea[name='auditDateTimeScript']").val();
    }
    diagram.editAutoNode(
      editNode,
      editNode.id,
      name,
      statelabel,
      orderNum,
      issplit,
      isgather,
      autoAuditType,
      delayDay,
      delayHour,
      delayMinute,
      auditDateTime,
      editNode.x,
      editNode.y,
      splitStartNode,
      autoAuditTimeEditMode,
      auditDateTimeScript
    );
  },

  editManualNode(editNode) {
    var diagram = WorkFlowDesign.Cache.diagram;
    var $setPanel = $(".workflows-setting");
    //基本信息
    var name = $setPanel.find("input.name").val();
    var statelabel = $setPanel.find("input.statelabel").val();
    var orderNum = $setPanel.find("input.orderNum").val();

    var fieldpermlist = $setPanel.find("input[name='fieldpermlist']").val();
    var activityPermList = $setPanel.find("input[name='activityPermList']").val();
    var formname = $setPanel.find("input[name='formname']").val();
    var isFrontEdit = $setPanel.find("input[name='isFrontEdit']").is(":checked");
    var isAllowEditAuditor = $setPanel.find("input[name='isAllowEditAuditor']").is(":checked");
    var allowEditAuditorScript = $setPanel.find("textarea[name='allowEditAuditorScript']").val();
    var isAllowTermination = $setPanel.find("input[name='isAllowTermination']").is(":checked");

    //审批人设置
    var actorEditMode = parseInt($setPanel.find("select[name='actorEditMode']").val());
    var deptlist = $setPanel.find("input[name='deptlist']").val();
    var namelist = $setPanel.find("input[name='namelist']").val();
    var orgField = $setPanel.find("select[name='orgField']").val();
    var orgScope = $setPanel.find("input[name='orgScope']:checked").val();
    var orgRoleCondition = $setPanel.find("input[name='orgRoleCondition']").val();
    var roleCondition = $setPanel.find("input[name='roleCondition']:checked").val();
    var isToPerson = $setPanel.find("input[name='isToPerson']").is(":checked");
    var checkedOnSinglePerson = $setPanel.find("input[name='checkedOnSinglePerson']").is(":checked");
    var checkedOnMultiplePerson = $setPanel.find("input[name='checkedOnMultiplePerson']").is(":checked");

    var actorListScript = $setPanel.find("textarea[name='actorListScript']").val();
    var approverNumType = Number($setPanel.find("input[name='approverNumType']:checked").val());

    //节点跳转设置
    var jumpNameScript = $setPanel.find("textarea[name='jumpNameScript']").val();
    var jump = $setPanel.find("input[name='jump']").is(":checked");
    var jumpTo = $setPanel.find("input[name='jumpTo']:checked").val();

    //审批时限设置
    var isLimited = $setPanel.find("input[name='isLimited']").is(":checked");
    var timeLimitEditMode = parseInt($setPanel.find("input[name='timeLimitEditMode']:checked").val());
    var timeLimitDay = $setPanel.find("input[name='timeLimitDay']").val();
    var timeLimitHour = $setPanel.find("input[name='timeLimitHour']").val();
    var timeLimitMinute = $setPanel.find("input[name='timeLimitMinute']").val();
    var timeLimitScript = $setPanel.find("textarea[name='timeLimitScript']").val();

    //抄送设置
    var isCarbonCopy = $setPanel.find("input[name='isCarbonCopy']").is(":checked");
    var circulatorEditMode = parseInt($setPanel.find("select[name='circulatorEditMode']").val());
    var circulatorNamelist = $setPanel.find("input[name='circulatorNamelist']").val();
    var circulatorListScript = $setPanel.find("textarea[name='circulatorListScript']").val();
    var isSelectCirculator = $setPanel.find("input[name='isSelectCirculator']").is(":checked");

    //审批设置
    var issplit = $setPanel.find("[name='issplit']:checked").val() == "true" ? true : false;
    var nextNodeCheckedStatus = parseInt($setPanel.find("input[name='nextNodeCheckedStatus']:checked").val());
    var isgather = $setPanel.find("[name='isgather']:checked").val() == "true" ? true : false;
    var splitStartNode = "";
    if (isgather) {
      splitStartNode = $setPanel.find("[name='splitStartNode']").val();
    }
    var passcondition = parseInt($setPanel.find("input[name='passcondition']:checked").val());

    var isApproverEdit = $setPanel.find("[name='isApproverEdit']:checked").is(":checked");
    var approverEditScript = $setPanel.find("textarea[name='approverEditScript']").val();
    var isCoApproverEdit = $setPanel.find("[name='isCoApproverEdit']:checked").is(":checked"); //彩生活
    var coApproverEditScript = $setPanel.find("textarea[name='coApproverEditScript']").val();
    var isSupplementComments = $setPanel.find("[name='isSupplementComments']:checked").is(":checked");

    var isAllowSkip = $setPanel.find("[name='isAllowSkip']:checked").is(":checked");

    //操作设置
    //回退
    var cBack = $setPanel.find("input[name='cBack']:checked").val() == "true" ? true : false;
    var backType = parseInt($setPanel.find("input[name='backType']:checked").val());
    var bnodelist = $setPanel.find("select[name='bnodelist']").val();
    //回撤
    var retracementSet = $setPanel.find("input[name='retracementSet']:checked").val();
    var retracementEditMode = editNode.retracementEditMode;
    var cRetracement = editNode.cRetracement;
    var retracementScript = editNode.retracementScript;
    if (retracementSet == "1") {
      retracementEditMode = 0;
      cRetracement = true;
      retracementScript = "";
    } else if (retracementSet == "2") {
      retracementEditMode = 0;
      cRetracement = false;
      retracementScript = "";
    } else {
      retracementEditMode = 1;
      cRetracement = false;
      retracementScript = $setPanel.find("textarea[name='retracementScript']").val();
    }
    //挂起
    var handupSet = $setPanel.find("input[name='handupSet']:checked").val();
    var isHandup = editNode.isHandup;
    var handupEditMode = editNode.handupEditMode;
    var handupScript = editNode.handupScript;
    if (handupSet == "1") {
      handupEditMode = 0;
      isHandup = true;
      handupScript = "";
    } else if (handupSet == "2") {
      handupEditMode = 0;
      isHandup = false;
      handupScript = "";
    } else {
      handupEditMode = 1;
      isHandup = false;
      handupScript = $setPanel.find("textarea[name='handupScript']").val();
    }
    //催办
    var allowUrgeSet = $setPanel.find("input[name='allowUrgeSet']:checked").val();
    var allowUrge2Approval = editNode.allowUrge2Approval;
    var urge2ApprovalEditMode = editNode.urge2ApprovalEditMode;
    var allowUrge2ApprovalScript = editNode.allowUrge2ApprovalScript;
    if (allowUrgeSet == "1") {
      urge2ApprovalEditMode = 0;
      allowUrge2Approval = true;
      allowUrge2ApprovalScript = "";
    } else if (allowUrgeSet == "2") {
      urge2ApprovalEditMode = 0;
      allowUrge2Approval = false;
      allowUrge2ApprovalScript = "";
    } else {
      urge2ApprovalEditMode = 1;
      allowUrge2Approval = false;
      allowUrge2ApprovalScript = $setPanel.find("textarea[name='allowUrge2ApprovalScript']").val();
    }

    var notificationStrategyJSON = {};
    //提交
    var noteSend = $setPanel.find("input[name='noteSend']").is(":checked");
    if (noteSend) {
      var receiverTypesOfSend = [];
      $setPanel.find("input[name='receiverTypesOfSend']:checked").each(function () {
        receiverTypesOfSend.push(parseInt($(this).val()));
      });
      var sendModeCodesOfSend = [];
      $setPanel.find("input[name='sendModeCodesOfSend']:checked").each(function () {
        sendModeCodesOfSend.push(parseInt($(this).val()));
      });
      var templateOfSend = $setPanel.find("select[name='templateOfSend']").val();
      notificationStrategyJSON.send = {
        receiverTypes: receiverTypesOfSend,
        sendModeCodes: sendModeCodesOfSend,
        template: templateOfSend,
      };
    }
    //到达
    var noteArrive = $setPanel.find("input[name='noteArrive']").is(":checked");
    if (noteArrive) {
      var smsApprovalOfArrive = $setPanel.find("input[name='smsApprovalOfArrive']").prop("checked");
      var sendModeCodesOfArrive = [];
      $setPanel.find("input[name='sendModeCodesOfArrive']:checked").each(function () {
        sendModeCodesOfArrive.push(parseInt($(this).val()));
      });
      var templateOfArrive = $setPanel.find("select[name='templateOfArrive']").val();
      notificationStrategyJSON.arrive = {
        smsApproval: smsApprovalOfArrive,
        sendModeCodes: sendModeCodesOfArrive,
        template: templateOfArrive,
      };
    }
    //回退
    var noteReject = $setPanel.find("input[name='noteReject']").is(":checked");
    if (noteReject) {
      var responsibleTypeOfReject = $setPanel.find("select[name='responsibleTypeOfReject']").val();
      var sendModeCodesOfReject = [];
      $setPanel.find("input[name='sendModeCodesOfReject']:checked").each(function () {
        sendModeCodesOfReject.push(parseInt($(this).val()));
      });
      var templateOfReject = $setPanel.find("select[name='templateOfReject']").val();
      notificationStrategyJSON.reject = {
        responsibleType: responsibleTypeOfReject,
        sendModeCodes: sendModeCodesOfReject,
        template: templateOfReject,
      };
    }
    //过期
    var noteOverdue = $setPanel.find("input[name='noteOverdue']").is(":checked");
    if (noteOverdue) {
      var isnotifysuperiorOfOverdue = $setPanel.find("input[name='isnotifysuperiorOfOverdue']").prop("checked");
      var editModeOfOverdue = $setPanel.find("input[name='editModeOfOverdue']").prop("checked")
        ? $setPanel.find("input[name='editModeOfOverdue']").eq(0).val()
        : $setPanel.find("input[name='editModeOfOverdue']").eq(1).val();
      var limittimecountOfOverdue = "";
      var timeunitOfOverdue = "";
      var limittimeScriptOfOverdue = "";
      if (editModeOfOverdue == "0") {
        limittimecountOfOverdue = $setPanel.find("input[name='limittimecountOfOverdue']").val();
        timeunitOfOverdue = $setPanel.find("select[name='timeunitOfOverdue']").val();
      } else {
        limittimeScriptOfOverdue = $setPanel.find("textarea[name='limittimeScriptOfOverdue']").val();
      }
      var sendModeCodesOfOverdue = [];
      $setPanel.find("input[name='sendModeCodesOfOverdue']:checked").each(function () {
        sendModeCodesOfOverdue.push(parseInt($(this).val()));
      });
      var templateOfOverdue = $setPanel.find("select[name='templateOfOverdue']").val();
      notificationStrategyJSON.overdue = {
        isnotifysuperior: isnotifysuperiorOfOverdue,
        editMode: editModeOfOverdue,
        limittimecount: limittimecountOfOverdue,
        timeunit: timeunitOfOverdue,
        limittimeScript: limittimeScriptOfOverdue,
        sendModeCodes: sendModeCodesOfOverdue,
        template: templateOfOverdue,
      };
    }
    //催办
    var noteReminder = $setPanel.find("input[name='noteReminder']").is(":checked");
    if (noteReminder) {
      var sendModeCodesOfReminder = [];
      $setPanel.find("input[name='sendModeCodesOfReminder']:checked").each(function () {
        sendModeCodesOfReminder.push(parseInt($(this).val()));
      });
      notificationStrategyJSON.reminder = {
        responsibleType: "16",
        sendModeCodes: sendModeCodesOfReminder,
      };
    }
    //抄送
    var noteCarbonCopy = $setPanel.find("input[name='noteCarbonCopy']").is(":checked");
    if (noteCarbonCopy) {
      var sendModeCodesOfCarbonCopy = [];
      $setPanel.find("input[name='sendModeCodesOfCarbonCopy']:checked").each(function () {
        sendModeCodesOfCarbonCopy.push(parseInt($(this).val()));
      });
      var templateOfCarbonCopy = $setPanel.find("select[name='templateOfCarbonCopy']").val();
      notificationStrategyJSON.carbonCopy = {
        sendModeCodes: sendModeCodesOfCarbonCopy,
        template: templateOfCarbonCopy,
      };
    }

    //彩生活
    var isAssist = $setPanel.find("input[name='isAssist']").is(":checked");
    var isSelectAssistUser = $setPanel.find("input[name='isSelectAssistUser']").is(":checked");
    var assistEditMode = parseInt($setPanel.find("select[name='assistEditMode']").val());
    var assistListScript = $setPanel.find("textarea[name='assistListScript']").val();
    var assistNamelist = $setPanel.find("input[name='assistNamelist']").val();
    var noteAssist = $setPanel.find("input[name='noteAssist']").is(":checked");
    if (noteAssist) {
      var sendModeCodesOfAssist = [];
      $setPanel.find("input[name='sendModeCodesOfAssist']:checked").each(function () {
        sendModeCodesOfAssist.push(parseInt($(this).val()));
      });
      var templateOfAssist = $setPanel.find("select[name='templateOfAssist']").val();
      notificationStrategyJSON.assist = {
        sendModeCodes: sendModeCodesOfAssist,
        template: templateOfAssist,
      };
    }

    var opts = {
      id: editNode.id,
      name: name, //
      scale: editNode.scale,
      note: editNode.note,
      x: editNode.x,
      y: editNode.y,
      width: editNode.width,
      height: editNode.height,
      m_width: editNode.m_width,
      m_height: editNode.m_height,
      prenodeid: editNode.prenodeid,
      statelabel: statelabel, //
      orderNum: orderNum,
      backnodeid: editNode.backnodeid,
      formname: formname, //
      fieldpermlist: fieldpermlist, //
      isstartandnext: editNode.isstartandnext,
      _iscurrent: editNode._iscurrent,
      actorListScript: actorListScript, //

      jumpNameScript: jumpNameScript,
      jump: jump,
      jumpTo: jumpTo,

      actorEditMode: actorEditMode, //
      deptlist: deptlist, //
      namelist: namelist, //
      realnamelist: editNode.realnamelist,
      passcondition: passcondition, //
      isApproverEdit: isApproverEdit, //
      approverEditScript: approverEditScript,//
      isCoApproverEdit: isCoApproverEdit, //cc
      coApproverEditScript: coApproverEditScript,//cc
      isSupplementComments: isSupplementComments,
      exceedaction: editNode.exceedaction,
      issetcurruser: editNode.issetcurruser,
      inputform: editNode.inputform,
      isgather: isgather, //
      issplit: issplit, //
      cBack: cBack, //
      splitStartNode: splitStartNode,
      isFrontEdit: isFrontEdit, //
      backType: backType, //
      isToPerson: isToPerson, //
      checkedOnSinglePerson: checkedOnSinglePerson, //
			checkedOnMultiplePerson: checkedOnMultiplePerson,//

      bnodelist: bnodelist, //
      retracementEditMode: retracementEditMode, //
      cRetracement: cRetracement, //
      retracementScript: retracementScript, //
      notificationStrategyJSON: notificationStrategyJSON != "" ? WorkFlowDesign.Utils.encodeHTML(JSON.stringify(notificationStrategyJSON)) : "", //
      isCarbonCopy: isCarbonCopy, //
      isSelectCirculator: isSelectCirculator, //
      circulatorEditMode: circulatorEditMode, //
      circulatorListScript: circulatorListScript, //
      circulatorNamelist: circulatorNamelist, //
      userList: editNode.userList,
      approverNumType: approverNumType,

      circulatorNamelistByUser: editNode.circulatorNamelistByUser,
      orgField: orgField, //
      orgScope: orgScope, //
      orgRoleCondition: orgRoleCondition, //
      isLimited: isLimited, //
      timeLimitEditMode: timeLimitEditMode, //
      timeLimitDay: timeLimitDay, //
      timeLimitHour: timeLimitHour, //
      timeLimitMinute: timeLimitMinute, //
      timeLimitScript: timeLimitScript, //
      isUsbKeyVerify: editNode.isUsbKeyVerify,
      roleCondition: roleCondition, //
      handupEditMode: handupEditMode, //
      isHandup: isHandup, //
      handupScript: handupScript, //
      isAllowEditAuditor: isAllowEditAuditor, //
      allowEditAuditorScript: allowEditAuditorScript,
      isAllowTermination: isAllowTermination, //
      activityPermList: activityPermList, //
      urge2ApprovalEditMode: urge2ApprovalEditMode, //
      allowUrge2Approval: allowUrge2Approval, //
      allowUrge2ApprovalScript: allowUrge2ApprovalScript, //
      isAllowSkip: isAllowSkip, //
      nextNodeCheckedStatus: nextNodeCheckedStatus, //
      //彩生活
      isAssist: isAssist,
      isSelectAssistUser: isSelectAssistUser,
      assistEditMode: assistEditMode,
      assistListScript: assistListScript,
      assistNamelist: assistNamelist,
      assistNamelistByUser: editNode.assistNamelistByUser,
    };

    diagram.editManualNode(editNode, opts);
  },

  editSubFlow(editNode) {
    var diagram = WorkFlowDesign.Cache.diagram;
    var $setContentPanel = $(".workflows-setting").find(".edit-content");

    //基本信息
    var name = $setContentPanel.find("input.name").val();
    var statelabel = $setContentPanel.find("input.statelabel").val();
    var orderNum = $setContentPanel.find("input.orderNum").val();

    var subFlowDefiType = $setContentPanel.find("input[name='subFlowDefiType']:checked").val();
    var subflowid = "",
      subflowname = "",
      subflowScript = "";
    if (subFlowDefiType == "01") {
      subflowid = $setContentPanel.find("input[name='subflowid']").val();
      subflowname = $setContentPanel.find("input[name='subflowname']").val();
    } else {
      subflowScript = $setContentPanel.find("textarea[name='subflowScript']").val();
    }
    //启动
    var isToPerson = $setContentPanel.find("input[name='isToPerson']").is(":checked");
    var checkedOnSinglePerson = $setContentPanel.find("input[name='checkedOnSinglePerson']").is(":checked");
    var checkedOnMultiplePerson = $setContentPanel.find("input[name='checkedOnMultiplePerson']").is(":checked");

    var numberSetingType = $setContentPanel.find("input[name='numberSetingType']:checked").val();
    var numberSetingContent = 1,
      parentFlowFormId = "",
      parentFlowFormName = "";
    if (numberSetingType == "01") {
      numberSetingContent = $setContentPanel.find("input[name='numberSetingContent']").val();
    } else if (numberSetingType == "02") {
      parentFlowFormId = $setContentPanel.find("input[name='parentFlowFormId']").val();
      parentFlowFormName = $setContentPanel.find("input[name='parentFlowFormName']").val();
      //numberSetingContent = $setContentPanel.find("select[name='numberSetingContentSelect']").val();
      numberSetingContent = $("#numberSetingContentSelect option:selected").text();
    } else if (numberSetingType == "03") {
      numberSetingContent = $setContentPanel.find("textarea[name='numberSetingContent']").val();
    }
    //审批设置
    var issplit = $setContentPanel.find("[name='issplit']:checked").val() == "true" ? true : false;
    var isgather = $setContentPanel.find("[name='isgather']:checked").val() == "true" ? true : false;
    var splitStartNode = "";
    if (isgather) {
      splitStartNode = $setContentPanel.find("[name='splitStartNode']").val();
    }
    //参数传递
    var fieldMappingXML = $setContentPanel.find("[name='fieldMappingXML']").val();
    var paramPassingType = $setContentPanel.find("[name='paramPassingType']").val();

    var parentFlowFormId = $setContentPanel.find("[name='parentFlowFormId']").val();
    var parentFlowFormName = $setContentPanel.find("[name='parentFlowFormName']").val();

    //流程等待
    var callback = $setContentPanel.find("[name='callback']:checked").val() == "true" ? true : false;
    var callbackScript = "";
    if (callback) {
      callbackScript = $setContentPanel.find("textarea[name='callbackScript']").val();
    }

    var opts = {
      //基本信息
      name: name, //名称
      statelabel: statelabel, //状态标签
      orderNum: orderNum, //排序号
      subFlowDefiType: subFlowDefiType, //指定子流程
      subflowid: subflowid, //子流程ID
      subflowname: subflowname, //子流程名称
      subflowScript: subflowScript, //指定子流程脚本
      //启动
      isToPerson: isToPerson, //由子流程启动人设定该子流程第一个人工节点的审批人
      checkedOnSinglePerson: checkedOnSinglePerson, //只有一个审批人的时候，是否默认选中
      checkedOnMultiplePerson: checkedOnMultiplePerson, //上一步提交该节点默认选中所有人

      numberSetingType: numberSetingType, //启动实例方式
      numberSetingContent: numberSetingContent, //实例数内容
      parentFlowFormId: parentFlowFormId, //父流程表单ID
      parentFlowFormName: parentFlowFormName, //父流程表单名称
      //审批设置
      isgather: isgather,
      splitStartNode: splitStartNode,
      issplit: issplit,
      //参数传递
      fieldMappingXML: fieldMappingXML, //传递参数方式
      //流程等待
      callback: callback, //是否回调
      callbackScript: callbackScript, //回调脚本

      paramPassingType: editNode.paramPassingType,
      subFlowFormId: editNode.subFlowFormId,
      subFlowFormName: editNode.subFlowFormName,
      shareDocument: editNode.shareDocument,
      paramPassingScript: editNode.paramPassingScript,
      iscurrent: editNode.iscurrent,
      ispassed: editNode.ispassed,
      crossform: editNode.crossform,
      startupScript: editNode.startupScript,
      id: editNode.id,
      scale: editNode.scale,
      note: editNode.note,
      x: editNode.x,
      y: editNode.y,
      width: editNode.width,
      height: editNode.height,
      m_width: editNode.m_width,
      m_height: editNode.m_height,
      prenodeid: editNode.prenodeid,
      backnodeid: editNode.backnodeid,
      formname: editNode.formname,
      fieldpermlist: editNode.fieldpermlist,
      isstartandnext: editNode.isstartandnext,
      _iscurrent: editNode._iscurrent,
    };
    diagram.editSubFlow(editNode, opts);
  },

  editRelation(editNode) {
    var diagram = WorkFlowDesign.Cache.diagram;
    var $setContentPanel = $(".workflows-setting").find(".edit-content");

    //基本信息
    var id = editNode.id;
    var name = $setContentPanel.find("input.name").val();
    var condition = $setContentPanel.find("textarea[name='condition']").val();
    var note = editNode.note;
    var action = $setContentPanel.find("textarea[name='action']").val();
    var validateScript = $setContentPanel.find("textarea[name='validateScript']").val();
    var filtercondition = $setContentPanel.find("input[name='filtercondition']").val();
    var editMode = $setContentPanel.find("input[name='editMode']:checked").val();
    var processDescription = $setContentPanel.find("input[name='processDescription']").val();
    var formlist = $setContentPanel.find("input[name='formlist']").val() != "undefined" ? $setContentPanel.find("input[name='formlist']").val() : "";

    diagram.editRelation(editNode, id, name, condition, note, action, validateScript, filtercondition, editMode, processDescription, formlist);
  },
  //xh 保存右侧节点信息
  savePropWithEditNode() {
    var diagram = WorkFlowDesign.Cache.diagram;
    var $setPanel = $(".workflows-setting");
    var $flowContainer = $("#flow_container");
    var currToEdit = diagram.getCurrToEdit();
    if (!currToEdit) {
      var subjectVal = $("#flowDiagram").find(".subject").val();
      $("[name='content.subject']").val(subjectVal);
      // yx
      var authorname1 = $("#flowDiagram").find(".authorname").val();
      $("#authorname").val(authorname1);
    } else {
      var currToEditName = currToEdit.getClassName();
      switch (currToEditName) {
        case "cn.myapps.runtime.workflow.element.StartNode":
          WorkFlowDesign.Core.editStartNode(currToEdit);
          break;
        case "cn.myapps.runtime.workflow.element.CompleteNode":
          WorkFlowDesign.Core.editCompleteNode(currToEdit);
          break;
        case "cn.myapps.runtime.workflow.element.GatewayNode":
          WorkFlowDesign.Core.editGatewayNode(currToEdit);
          break;
        case "cn.myapps.runtime.workflow.element.AutoNode":
          WorkFlowDesign.Core.editAutoNode(currToEdit);
          break;
        case "cn.myapps.runtime.workflow.element.ManualNode":
          WorkFlowDesign.Core.editManualNode(currToEdit);
          break;
        case "cn.myapps.runtime.workflow.element.SubFlow":
          WorkFlowDesign.Core.editSubFlow(currToEdit);
          break;
        case "cn.myapps.runtime.workflow.element.Relation":
          WorkFlowDesign.Core.editRelation(currToEdit);
          break;
        default:
          break;
      }
    }
    var xml = diagram.toXML();
    $flowContainer.val(xml);
  },

  changeEditContentPanel(dom) {
    var $this = $(dom);
    var name = $this.attr("name");
    var value = $this.val();

    var $panels = $("div[data-componentName='" + name + "']");

    $panels.each(function () {
      var dataValue = $(this).data("value");
      if (typeof dataValue == "boolean") {
        dataValue = dataValue ? "true" : "false";
      }
      if (dataValue == value && $(this).hasClass("d-none")) {
        $(this).removeClass("d-none");
      } else {
        $(this).addClass("d-none");
      }
    });
  },
};
/**
 * 选择子流程
 * @param {*} className
 * @param {*} currToEdit
 * @param {*} fieldname
 */
function selectSubFlow(className, currToEdit) {
  var url = "./selectSubFlow.html";
  $.dialog.show({
    width: 800,
    height: 600,
    url: url,
    args: {
      applicationId: params.applicationId,
      moduleId: params.moduleId,
      contextPath: params.contextPath,
    },
    title: "选择子流程",
    close: function (result) {
      if (result == null || result === undefined) {
        //取消按钮
      } else {
        //确认按钮
        $("[name='subflowid']").val(result.id);
        $("[name='subflowname']").val(result.subject);

        if (className == "cn.myapps.runtime.workflow.element.ManualNode") {
          WorkFlowDesign.Core.editManualNode(currToEdit);
        } else if (className == "cn.myapps.runtime.workflow.element.SubFlow") {
          WorkFlowDesign.Core.editSubFlow(currToEdit);
        }
      }
    },
  });
}

/**
 * 选择父流程表单
 * @param {*} className
 * @param {*} currToEdit
 * @param {*} fieldname
 */
function selectParentFlowForm(className, currToEdit) {
  var url = "./selectParentFlow.html";
  $.dialog.show({
    width: 800,
    height: 600,
    url: url,
    args: {
      applicationId: params.applicationId,
      moduleId: params.moduleId,
      contextPath: params.contextPath,
    },
    title: "选择父流程表单",
    close: function (result) {
      if (result == null || result === undefined) {
        //取消按钮
      } else {
        //确认按钮
        $("[name='parentFlowFormId']").val(result.id);
        $("[name='parentFlowFormName']").val(result.name);

        var $parentSelect = $("[name='numberSetingContentSelect']");
        $parentSelect.html("");
        for (var i = 0; i < result.formFields.length; i++) {
          var field = result.formFields[i];
          var option = "<option value='" + field.valuetype + "'>" + field.name + "</option>";
          $parentSelect.append(option);
        }

        if (className == "cn.myapps.runtime.workflow.element.ManualNode") {
          WorkFlowDesign.Core.editManualNode(currToEdit);
        } else if (className == "cn.myapps.runtime.workflow.element.SubFlow") {
          WorkFlowDesign.Core.editSubFlow(currToEdit);
        }
      }
    },
  });
}
