import TextElement from './TextElement';
import {Sequence, Archor} from '../../utility';
class imgEle extends TextElement {
	constructor() {
		super();
		this.text = imgEle.DEF_TEXT; //当前元素默认文本
		this.belong = '';
		this.isOpenArchor = false;
		this.width=50;
		this.height=50;
		this.src="";
		this.srcT='../report/ReportDesign/images/auto.gif';
		//../report/ReportDesign/images/actor.png
		// this.lineWidth=1;
		// this.lineStyle="Solid";
		// this.lineColor="#000";
		// this.lineStyleOption={
		// 	"Solid":true,
		// 	"Dashed":false,
		// 	"Dotted":false,
		// 	"Double":false,
		// }
		this.scaleImage="RetainShape"
		this.scaleImageOption={
			"RetainShape":true,
			"Clip":false,
			"FillFrame":false,
		}
		this.hAlign="Left";
		this.hAlignOption={
			"Left":true,
			"Center":false,
			"Right":false,
		}
		this.vAlign="Top"
		this.vAlignOption={
			"Top":true,
			"Middle":false,
			"Bottom":false,
		}
		this.cls="java.lang.String";

		this.key="图片"
	}
	
	getClassName() {
		return 'Image';
	}
	
	getNodeConfigInfo() {
		let node = {};
		node.text = this.key==""?this.text:this.key;
		node.src=this.src;
		node.icon = '\tglyphicon glyphicon-picture';
		node.uuid = this.getProp('id');	
		node.instance = this;
		return node;
	}

	/**
	 * @param g
	 */
	paint(g) {
		//console.log(this)
		const that=this;
		var a=g.checkWH(this.width,this.height);
		this.width=a.w;
		this.height=a.h;
		let length=0;
		if(!this.id) {
			this.id = Sequence.createUuid();
		}
		g.save();
		 g.setStyle(this.lineWidth,this.lineStyle,this.lineColor);
		// if(this.lineStyle=="Double"){
		// 	g.strokeRect(that.x,that.y,that.width,that.height)
		// 	g.strokeRect(that.x+this.lineWidth*2,that.y+this.lineWidth*2,that.width-this.lineWidth*4,that.height-this.lineWidth*4)
		// 	length=this.lineWidth*2;
		// }else{
		// 	g.strokeRect(that.x,that.y,that.width,that.height)
		// }
		// g.setLineStyle();
		that.nowX;
		that.nowY;
		that.nowW;
		that.nowH;
		that.imgH;
		that.imgW;
		that.imgX;
		that.imgY;
		if(this.mode == 'Opaque') {
			g.strokeRect(that.x,that.y,that.width,that.height)
			that.imgX=that.nowX=that.x+this.lineWidth;
			that.imgY=that.nowY=that.y+this.lineWidth;
			that.imgW=that.nowW=that.width-this.lineWidth*2;
			that.imgH=that.nowH=that.height-this.lineWidth*2;
			if(this.lineStyle=="Double"){
				g.strokeRect(that.x+this.lineWidth*2,that.y+this.lineWidth*2,that.width-this.lineWidth*4,that.height-this.lineWidth*4)
				g.fillRect(that.x+this.lineWidth*3,that.y+this.lineWidth*3,that.width-this.lineWidth*6,that.height-this.lineWidth*6)
				that.nowX=that.x+this.lineWidth*3;
				that.nowY=that.y+this.lineWidth*3;
				that.nowW=that.width-this.lineWidth*6;
				that.nowH=that.height-this.lineWidth*6;
			}else{
				g.fillRect(that.x+this.lineWidth,that.y+this.lineWidth,that.width-this.lineWidth*2,that.height-this.lineWidth*2)

			}


		} else {
			g.strokeRect(that.x,that.y,that.width,that.height)
			that.nowX=that.x+this.lineWidth;
			that.nowY=that.y+this.lineWidth;
			that.nowW=that.width-this.lineWidth*2;
			that.nowH=that.height-this.lineWidth*2;
			if(this.lineStyle=="Double"){
				g.strokeRect(that.x+this.lineWidth*2,that.y+this.lineWidth*2,that.width-this.lineWidth*4,that.height-this.lineWidth*4);
				that.nowX=that.x+this.lineWidth*3;
				that.nowY=that.y+this.lineWidth*3;
				that.nowW=that.width-this.lineWidth*5;
				that.nowH=that.height-this.lineWidth*5;
			}else{
				//g.strokeRect(this.x, this.y, this.width, this.height);
			}
			//g.drawRect(this.x, this.y, this.width, this.height);
		}
		g.setLineStyle();
		// let have=this.CheckImgExists(this.src);
		let img = new Image();

		img.onload = function(){

			if(that.scaleImage=="Clip"){
				that.imgH=img.height>that.nowH? that.nowH:img.height;
				that.imgW=img.width*that.imgH/img.height>that.nowW?that.nowW:img.width*that.imgH/img.height;
			}else if(that.scaleImage=="RetainShape"){
				that.imgW=img.width>that.nowW? that.nowW:img.width;
				if(that.imgW==img.width){
					that.imgH=that.nowH;
					that.imgW=that.imgH*img.width/img.height;
				}else{
					that.imgH=that.imgW*img.height/img.width>that.nowH?that.nowH:that.imgW*img.height/img.width;
				}

			}else if(that.scaleImage=="FillFrame") {
				that.imgX=that.nowX;
				that.imgY=that.nowY;
				that.imgW=that.nowW;
				that.imgH=that.nowH;
			}
			if(that.hAlign=="Center"&&that.scaleImage!="FillFrame"){
				that.imgX=that.nowX+that.nowW/2-that.imgW/2;

			}else if(that.hAlign=="Right"&&that.scaleImage!="FillFrame"){
				that.imgX=that.nowX+that.nowW-that.imgW;
			}else if(that.hAlign=="Left"&&that.scaleImage!="FillFrame"){
				that.imgX=that.nowX;
			}
			if(that.vAlign=="Middle"&&that.scaleImage!="FillFrame"){
				that.imgY=that.nowY+that.nowH/2-that.imgH/2;

			}else if(that.vAlign=="Bottom"&&that.scaleImage!="FillFrame"){
				that.imgY=that.nowY+that.nowH-that.imgH;
			}else if(that.vAlign=="Top"&&that.scaleImage!="FillFrame"){
				that.imgY=that.nowY;
			}
			g.drawImage(img,that.imgX,that.imgY,that.imgW,that.imgH);
		}
		if(this.src!=""){
			img.src = this.src ;
		}else{
			img.src='../report/ReportDesign/images/auto.gif';
		}

		//g.drawRect(img,that.x,that.y,that.width,that.height)
		// console.log(img)
		//g.drawTextWithRow(this.text, tx, ty, this.width, parseInt(this.font.size));
		if(this.error){
			let img2=new Image();
			img2.src=this.errorImgSrc;
			img2.onload=function(){
				g.drawImage(img2,that.x,that.y,15,15);
			}

		}
		g.restore();
		
		if(this.isOpenArchor) {
			const archor = Archor.getInstance();
			const openArchor = [{x: 0, y: 0}, {x: 1, y: 0}, {x: 1, y: 1}, {x: 0, y: 1}]; //以当前元素左上角为坐标系，得(0, 0)为左上角，依次类推
			const params = {x: this.x, y: this.y, targetW: this.width, targetH: this.height, openArchorPos: openArchor};
			
			archor.setProps(params);	
			archor.paint(g);
		}
		
		
	}
	
	CheckImgExists(imgurl) {
		var ImgObj = new Image(); //判断图片是否存在
		ImgObj.src = imgurl;
		//没有图片，则返回-1
		if (ImgObj.fileSize > 0 || (ImgObj.width > 0 && ImgObj.height > 0)) {
			return true;
		} else {
			return false;
		}
	}

	toXML() {
		this.srcT
		let str = "<image ";
		str +=`scaleImage="${this.scaleImage}" `
		str +=`hAlign="${this.hAlign}" `
		str +=`vAlign="${this.vAlign}" `

		str +=">\n"
		str += super.toXML2();
		str +='<graphicElement>\n';

		str +=`<pen lineWidth="${this.lineWidth}" `

		str +=`lineStyle="${this.lineStyle}" `
		str +=`lineColor="${this.lineColor}"`
		str +=`/>\n`
		str +=`</graphicElement>\n`
		str +=`<imageExpression><![CDATA[${this.srcT}]]></imageExpression>\n`

		str += "</image>\n";
		
		return str;
	}
	
	parseXML(xmlNode) {
		let props = {};
		let that = this;
		this.scaleImage=xmlNode.getAttribute("scaleImage")
		this.hAlign=xmlNode.getAttribute("hAlign")
		this.vAlign=xmlNode.getAttribute("vAlign")

		const traversalNode = (xmlNode) => {
			//console.log(xmlNode);
			const { tagName } = xmlNode;
			//console.log(tagName);

			switch (tagName) {
				case 'reportElement':
					const reportElement = this.handleReportElement(xmlNode);
					Object.assign(props, reportElement);
					break;
				case 'text':
					//console.log(xmlNode.childNodes[0].nodeValue);
					props.text = this.replaceText(xmlNode.childNodes[0].nodeValue);
					//console.log(props.text)
					break;
				case 'graphicElement':
					const children=xmlNode.children;
					if(children.length>0){
						that.lineWidth = parseInt(children[0].getAttribute('lineWidth'));
						that.lineStyle = children[0].getAttribute('lineStyle');
						that.lineColor = children[0].getAttribute('lineColor');
					}

					break;
				case 'imageExpression':
//					const textElement = this.handleTextElement(xmlNode);
//					Object.assign(props, textElement);

					let v=xmlNode.innerHTML;

					//console.log(typeof xmlNode.childNodes[0])//object
					//console.log(xmlNode.childNodes[0])//<![CDATA["C:/project/obpm4.21/obpm-demo/uploads/reports/images/end.gif"]]>
					v=v.replace(/\<\!\[CDATA\[/,"")

					v=v.replace(/\]\]\>/,"")

					that.srcT=v;
					v=v.replace(/^\"/,"")
					v=v.replace(/\"$/,"")
					let src2=v.substr(v.indexOf("/uploads"));
					src2="../../../designer"+src2;
					that.src=src2;
					break;
				default:
					break;
			}
		};
		
		if(xmlNode.hasChildNodes()) {
			for(let i = 0, len = xmlNode.children.length;i < len;i++) {
				traversalNode(xmlNode.children[i]);
			}
		}
		//console.log(props)
		this.setProps(props);

		return props;
	}
	
	// showTips(g) {
		// let tips = '';
		// tips += this.text;
		// this.drawTips(g, tips);
	// }
}

imgEle.DEF_TEXT = 'image'; 

export default imgEle;