import AbstractField from "./AbstractField";
import { Sequence } from "../../utility";

class ButtonField extends AbstractField{
    constructor(container) {
        super();
        this.scope="buttonField"
        this.container = container;
        this.htmlDOM=null;
        
        this.className="baseField";
        this.propValues.id = Sequence.createUuid();
        this.propValues.name="按钮"+window.formApp.formPanel.propValues.nameIndex;

        this.html=`<div class="baseCon fieldId"  fieldid='${this.propValues.id}' >
        <button class="baseCon-btn">${this.propValues.name}</button></div>`;

        this.propValues.label = ""; // 说明文字
        this.propValues.colorType = "default"; // 颜色
        this.propValues.refreshonchanged = false; //刷新
        this.propValues.calculateonrefresh = false; //重计算
        this.propValues.refreshmode = "0"; //重刷新的方式
        this.propValues.refreshfields = []; //局部刷新的字段组合
        this.propValues.editProp="editButtonField";
        


        this.propValues.hiddenscript = ""; //隐藏条件脚本beforeactionscript
        this.propValues.hiddenvalue = ""; //隐藏时显示值
        this.propValues.hiddenprintscript = ""; //打印时隐藏条件脚本
        this.propValues.printhiddenvalue = ""; //打印隐藏时显示值
        this.propValues.readonlyscript = ""; //只读条件脚本
        
        this.propValues.acttype='0'//动作
        this.propValues.beforeactionscript=""//动作执行前脚本
        this.propValues.afteractionscript=""//动作执行后脚本
        this.propValues.statetoshow=""//状态标签

        this.propValues.filenamescript="";//文件路径脚本
        this.propValues.jumpmode="0";//类型

        this.propValues.transpond="";//选择摘要模板

        this.propValues.actionprint="";//选择打印模板
        this.propValues.withold=false;//带旧数据
        this.propValues.datafield="";//签章数据关联字段
        this.propValues.signaturetype='HTML';//签章类型
        this.propValues.signatureaction='signature'//签署动作
        this.propValues.signaturePosScript=''//签署位置
        this.propValues.actionselection="0";//动作处理方式
        this.propValues.relatedformid=""//动作关联表单
        this.propValues.actionscript="";//动作执行脚本
        this.propValues.actiontype = "0";//动作完成后操作类型
        this.propValues.actiondispatcherurlscript="";//地址脚本

        this.propValues.targetlist={
            "formselect":"",
            "moduleselect":'',
        }//跳转设置
        this.propValues.jumpactopentype="0";//打开方式
        this.propValues.dispatcherurl="";//跳转-地址脚本
        this.propValues.dispatcherparams=[
            {
                paramKey:"",
                paramValue:'',
            }
        ]//参数//跳转里面的
    }
    getPropsDesc() {
        return {
            "base":['myselfrows','name','label','colorType','refreshonchanged','refreshmode','refreshfields', 'calculateonrefresh','acttype','jumpmode','targetlist','dispatcherurl','dispatcherparams','jumpactopentype','filenamescript','transpond','actionprint','withold','signaturetype','datafield','signatureaction','signaturePosScript','statetoshow','beforeactionscript','actionselection','relatedformid','actionscript','afteractionscript','actiontype','actiondispatcherurlscript'],
            "hidden":['hiddenscript','hiddenvalue'],
            "hiddenprint":["hiddenprintscript","printhiddenvalue"],
            "readonly":['readonlyscript']
        }
    }
    //校验特殊属性
    checkSpeProp(){
        if(this.propValues.acttype=='0'){
            alert('请选择按钮动作')
            return false;
        }
        return true;
    }
}
export default ButtonField;