import instance from './ajax';

/**
 * 库模块
 * 获取函数库列表
 */
export const getMacroLibsList = (params, appId) => {
  return instance({
    url: contextPath + '/designtime/applications/'+ appId +'/macros?name='+ params.searchword +'&pageNo='+ params.currpage +'&linesPerPage='+ params.pagelines,
    method: 'get',
  })
}
/**
 * 删除函数库（可批量）
 */
export const deleteMacroLibsList = (appId,data) => {
  return instance({
    url: contextPath + '/designtime/applications/'+ appId +'/macros',
    method: 'delete',
    data
  })
}
/**
 * 
 * 获取函数库列表
 */
export const editgetMacroLibs = (appId,macroId) => {
  return instance({
    url: contextPath + '/designtime/applications/'+ appId +'/macros/'+ macroId,
    method: 'get',
  })
}
/**
 * 新建函数库保存
 */
export const saveMacroLibs = (appId,data) => {
  return instance({
    url: contextPath + '/designtime/applications/'+ appId +'/macros',
    method: 'post',
    data
  })
}
/**
 * 更新函数库保存
 */
export const saveEditMacroLibs = (appId,macroId,data) => {
  return instance({
    url: contextPath + '/designtime/applications/'+ appId +'/macros/'+ macroId,
    method: 'put',
    data: data
  })
}

/**
 * 库模块
 * 获取样式库列表
 */
export const getStyleLibsList = (params, appId) => {
  return instance({
    url: contextPath + '/designtime/applications/'+ appId +'/styles?name='+ params.searchword +'&pageNo='+ params.currpage +'&linesPerPage='+ params.pagelines,
    method: 'get',
  })
}
/**
 * 删除样式库（可批量）
 */
export const deleteStyleLibsList = (appId,data) => {
  return instance({
    url: contextPath + '/designtime/applications/'+ appId +'/styles',
    method: 'delete',
    data
  })
}
/**
 * 
 * 获取样式库列表
 */
export const editgetStyleLibs = (appId,macroId) => {
  return instance({
    url: contextPath + '/designtime/applications/'+ appId +'/styles/'+ macroId,
    method: 'GET',
  })
}
/**
 * 新建样式库保存
 */
export const saveStyleLibs = (appId,data) => {
  return instance({
    url: contextPath + '/designtime/applications/'+ appId +'/styles',
    method: 'post',
    data
  })
}
/**
 * 更新样式库保存
 */
export const saveEditStyleLibs = (appId,macroId,data) => {
  return instance({
    url: contextPath + '/designtime/applications/'+ appId +'/styles/'+ macroId,
    method: 'put',
    data
  })
}

/**
 * 库模块
 * 获取校验库列表
 */
export const getValidateLibsList = (params, appId) => {
  return instance({
    url: contextPath + '/designtime/applications/'+ appId +'/validates?name='+ params.searchword +'&pageNo='+ params.currpage +'&linesPerPage='+ params.pagelines,
    method: 'get',
  })
}
/**
 * 删除校验库（可批量）
 */
export const deleteValidateLibsList = (appId,data) => {
  return instance({
    url: contextPath + '/designtime/applications/'+ appId +'/validates',
    method: 'delete',
    data
  })
}
/**
 * 
 * 获取校验库列表
 */
export const editgetValidateLibs = (appId,macroId) => {
  return instance({
    url: contextPath + '/designtime/applications/'+ appId +'/validates/'+ macroId,
    method: 'get',
  })
}
/**
 * 新建校验库保存
 */
export const saveValidateLibs = (appId,data) => {
  return instance({
    url: contextPath + '/designtime/applications/'+ appId +'/validates',
    method: 'post',
    data
  })
}
/**
 * 更新校验库保存
 */
export const saveEditValidateLibs = (appId,macroId,data) => {
  return instance({
    url: contextPath + '/designtime/applications/'+ appId +'/validates/'+ macroId,
    method: 'put',
    data
  })
}