import Node from "./Node";
import PaintElement from "./PaintElement";
import Resources from "../utility/Resources";
import StringUtil from "../utility/StringUtil";

class ManualNode extends Node {
  constructor(diagram) {
    super(diagram);

    this.actorListScript = ""; // 获取角色列表的脚本

    this.jumpNameScript = ""; //节点跳转名称的脚本
    this.jump = "false";
    this.jumpTo = 1;

    this.actorEditMode = ManualNode.ACTOR_EDIT_MODE_DESIGN; // 角色编辑模式(0:角色定制, 1:脚本,2:用户定制)
    // 详见FlowType.java类
    this.namelist = ""; // actor选择
    this.deptlist = ""; // dept选择
    /**
     * 组织字段(auditor：流程提交者|author：表单作者|initiator:流程发起人)
     */
    this.orgField = ManualNode.ORG_AUDITOR;
    /**
     * 作用范围
     */
    this.orgScope = "self";
    /**
     * 组织中的角色筛选条件
     */
    this.orgRoleCondition = "";
    /**
     * 审批人
     * 		数据规则：(U11e0-7c45-c6138387-a878-afad62721f2a|用户名称1;U11e0-7c45-c3be48e6-a878-afad62721f2a|用户名称2;)
     */
    this.userList = "";

    this.realnamelist = ""; // 当前结点真正审核者，形如{U|admin;D-05-02|副总师;}，“与”条件及代理人已转成具体处理人ID

    this.approverNumType = 0; //上一节点允许用户指定下一步审批人，再选择此节点审批人时

    /**
     * 审批模式
     */
    this.passcondition = "0"; // 审核通过条件 0->或 1->与 2->强制与 3->自定义（与或混合）
    // 详见FlowType.java类
    this.exceedaction = ""; // 超时处理类型
    // 0为不处理，1为自动流转，2为自动终止，3为自动回退，4为自动回退至指定结节
    // 详见FlowType.java类
    this.issetcurruser = false; // 流程转入时是否将writers强制设为当前用户
    /**
     * 使用完整名， 如：11000|赛百威公司/开发部/部门经理 多项值之间使用分号隔开，
     * 如：11000|赛百威公司/开发部/部门经理；12001|赛百威公司/市场部/部门经理
     */
    // this.namelist;
    this.inputform = "";
    // 角色列表，使用完整名，多项值之间使用分号隔开，如：11000|赛百威公司/开发部/部门经理；12001|赛百威公司/市场部/部门经理
    // this.actorlist;
    // 人员列表，使用完整名，多项值之间使用分号隔开，如：11000|赛百威公司/开发部/周志军；12001|赛百威公司/市场部/刘永勤
    // this.personlist;
    /**
     * @param owner
     * @roseuid 3E0428DB0132
     */
    // private Vector<NodeActivity> temp = new Vector<NodeActivity>(); //
    // 临时保存NodeActivity；
    this.isgather = false; // 是否聚合节点

    this.issplit = false; // 是否分散节点

    this.cBack = false; // 可否回退

    this.backType = 0; // 回退模式

    this.isToPerson = false; // 是否指的审批人
    this.checkedOnSinglePerson = false; // 一个审批人时是否默认选中该人
		this.checkedOnMultiplePerson = false;// 上一步提交该节点默认选中所有人

    this.bnodelist = ""; // 回退定制的节点

    this.retracementEditMode = 0; // 回撤编辑模式

    this.cRetracement = false; // 可否回撤

    this.retracementScript = ""; // 回撤条件脚本
    /**
     * 超时编辑模式
     */
    this.overrideTimeEditMode = 0;
    /**
     * 超时脚本
     */
    this.overrideTimeLimitScript = "";

    this.handupEditMode = 0; //挂起编辑模式

    this.isHandup = false; //可否挂起

    this.handupScript = ""; //挂起条件脚本
    /**
     * 流程提醒策略, 分为三种Arrive, OverDue, Reject, <br />
     * 数据结构如下: <br />
     * { <br />
     * arrive: {sendModeCodes:[0, 1, 2], template:reminderId, smsApproval:0or1}, <br />
     * overdue: {sendModeCodes:[0, 1, 2], limittimecount:12, timeunit:0,
     * isnotifysuperior:true, template:reminderId}, <br />
     * reject: {sendModeCodes:[0, 1, 2], responsibleType:256,
     * template:reminderId} <br />
     * }
     */
    this.notificationStrategyJSON = "";
    /**
     * 分散起始节点
     * @return
     */
    this.splitStartNode = "";

    this.isFrontEdit = false; //可否允许前台手动调整流程
    /**
     * 是否开启抄送功能
     */
    this.isCarbonCopy = false;
    /**
     * 是否指定抄送人
     */
    this.isSelectCirculator = false;
    /**
     * 抄送人编辑模式(0:角色定制, 1:脚本 ,2：用户定制)
     */
    this.circulatorEditMode = ManualNode.CIRCULATOR_EDIT_MODE_DESIGN;
    /**
     * 抄送人脚本
     */
    this.circulatorListScript = ""; // 获取角色列表的脚本
    /**
     * 抄送人按角色设计模式的数据模型
     */
    this.circulatorNamelist = "";
    /**
     * 抄送人按用户设计模式的数据模型
     *
     * 数据规则：(U11e0-7c45-c6138387-a878-afad62721f2a|用户名称1;U11e0-7c45-c3be48e6-a878-afad62721f2a|用户名称2;)
     */
    this.circulatorNamelistByUser = "";
    /**
     * 是否为审批时限节点
     */
    this.isLimited = false;
    /**
     * 审批时限编辑模式(0:设计模式|1:脚本模式)
     */
    this.timeLimitEditMode = ManualNode.TIMELIMIT_EDIT_MODE_DESIGN;
    /**
     * 时限天数
     */
    this.timeLimitDay = "";
    /**
     * 时限小时数
     */
    this.timeLimitHour = "";
    /**
     * 时限分钟数
     */
    this.timeLimitMinute = "";
    /**
     * 时限脚本
     */
    this.timeLimitScript = "";
    /**
     *是否允许加签
     */
    this.isApproverEdit = false;
    /**
		 * 允许加签主办人脚本
		 */
		this.approverEditScript = '';
    /**
     *是否允许加签(协办人) 彩生活
     */
    this.isCoApproverEdit = false;
    /**
		 * 允许加签协办人脚本
		 */
		this.coApproverEditScript = '';
    /**
     *是否允许添加/补签意见
     */
    this.isSupplementComments = false;
    /**
     *是否开启USBKEY授权提交 (本节点流转到下一步需要USBKEY身份认证)
     */
    this.isUsbKeyVerify = false;
    /**
     * 筛选条件
     */
    this.roleCondition = "";
    /**
     * 是否允许编辑当前节点的审批人
     */
    this.isAllowEditAuditor = false;
    /**
		 * 允许编辑当前审批人脚本
		 */
		this.allowEditAuditorScript = '';
    /**
     * 是否允许审批人终止此节点
     */
    this.isAllowTermination = false;
    /**
     * 是否允许跳过此节点（当此节点审批人为上一步提交人时，允许跳过此节点直接流转到下一步）
     */
    this.isAllowSkip = false;
    /**
     * 下一步节点的默认选中状态
     */
    this.nextNodeCheckedStatus = ManualNode.NEXT_NODE_CHECKED_STATUS_CHECKED;

    this.urge2ApprovalEditMode = 0; // 是否支持催办编辑模式

    this.allowUrge2Approval = false; // 是否允许催办

    this.allowUrge2ApprovalScript = ""; // 催办条件脚本

    this.activityPermList = ""; //  节点表单域操作按钮权限对应

    /**
     * 彩生活
     */
    this.isAssist = false; //是否开启协办

    this.isSelectAssistUser = false; //允许上一步流程处理人指定本节点的协办人

    this.assistEditMode = 0; //指定方式

    this.assistListScript = ""; //按脚本指定范围

    this.assistNamelist = ""; //按角色指定范围

    this.assistNamelistByUser = "";
  }

  getClassName() {
    return "cn.myapps.runtime.workflow.element.ManualNode";
  }

  getDeadlineDataTime(runner, nodert) {
    let calendar = Calendar.getInstance();

    switch (timeLimitEditMode) {
      case ManualNode.TIMELIMIT_EDIT_MODE_CODE:
        let obj = runner.run("ManualNode [name=" + name + "] [id=" + id + "] timeLimitScript", StringUtil.dencodeHTML(timeLimitScript));
        if (obj instanceof Date) {
          calendar.setTime(obj);
        } else if (obj instanceof String) {
          let date = null;
          try {
            date = DateUtil.parseDate(obj, "yyyy-MM-dd HH:mm:ss");
          } catch (e) {
            try {
              date = DateUtil.parseDate(obj, "yyyy-MM-dd HH:mm");
            } catch (e2) {
              e2.printStackTrace();
              throw new OBPMValidateException("审批时限格式异常,请参照格式'yyyy-MM-dd HH:mm:ss'或'yyyy-MM-dd HH:mm'", new WorkflowException("审批时限格式异常,请参照格式'yyyy-MM-dd HH:mm:ss'或'yyyy-MM-dd HH:mm'"));
            }
          }
          calendar.setTime(date);
        } else if (obj == null) {
          return null;
        }
        break;
      case ManualNode.TIMELIMIT_EDIT_MODE_DESIGN:
        if (!StringUtil.isBlank(timeLimitDay)) {
          calendar.add(Calendar.DATE, Integer.parseInt(timeLimitDay));
        }
        if (!StringUtil.isBlank(timeLimitHour)) {
          calendar.add(Calendar.HOUR, Integer.parseInt(timeLimitHour));
        }
        if (!StringUtil.isBlank(timeLimitMinute)) {
          calendar.add(Calendar.MINUTE, Integer.parseInt(timeLimitMinute));
        }

        let calendarProcess = ProcessFactory.createProcess(CalendarProcess.class);
        let actor = nodert.getActorrts().iterator().next();
        if (actor != null) {
          let userProcess = ProcessFactory.createProcess(UserProcess.class);
          let user = userProcess.doView(actor.getActorid());
          if (user != null) {
            let from = System.currentTimeMillis();
            let to = calendar.getTimeInMillis();
            let minutes = (to - from) / (1000 * 60);
            let deadlineData = calendarProcess.getNextDateByMinuteCount(new Date(), minutes, user.getCalendarType());
            calendar.setTime(deadlineData);
          }
        }
        break;
      default:
        break;
    }

    return calendar.getTime();
  }

  /**
   * 是否允许催办
   * @param doc
   * 		文档对象
   * @param params
   * 		参数表
   * @param user
   * 		当前操作用户
   * @return
   *
   * @throws Exception
   */
  isAllowUrge2Approval(doc, params, user) {
    if (ManualNode.URGE_TO_APPROVAL_EDIT_MODE_DESIGN == this.urge2ApprovalEditMode) {
      return this.allowUrge2Approval;
    } else {
      let runner = JavaScriptFactory.getInstance(params.getSessionid(), doc.getApplicationid());
      runner.initBSFManager(doc, params, user, []);
      let label = "";
      label = label + "Node name:" + this.name + " [" + this.id + "].allowUrge2ApprovalScript";
      let result = runner.run(label.toString(), this.allowUrge2ApprovalScript);
      if (result != null && result instanceof Boolean) {
        return result.booleanValue();
      }
    }

    return false;
  }

  toNameList() {
    // 经解释后的nameList对象
    let nameList = new NameList().parser(this.namelist);
    return nameList;
  }

  toUserList() {
    let nameList = new NameList().parser(this.userList);
    return nameList;
  }

  /**
   * 经解释后的nameList对象
   * @return
   */
  toCirculatorNameList() {
    let nameList = new NameList().parser(this.circulatorNamelist);
    return nameList;
  }

  toCirculatorNameListByUser() {
    let nameList = new NameList().parser(this.circulatorNamelistByUser);
    return nameList;
  }

  addNodeActivity(name) {
    let act = new NodeActivity(_owner);
    act.id = Sequence.getSequence();
    act.name = name;
    this.getSubelems().add(act);
  }

  getShortNameListStr() {
    let shortName = "";

    if (this.namelist != null && this.namelist != "()") {
      const nls = this.namelist.substring(1, this.namelist.length - 1).split(";");
      nls.forEach((nl) => {
        if (nl != null && nl != "") {
          let names = nl.split("|");
          shortName += names[1] + ";";
        }
      });
    }
    return shortName;
  }

  getFormatShortNameListStr() {
    let str = this.getShortNameListStr();
    let rtn = "";
    let pos = 0;
    while (pos <= str.length) {
      if (pos + 10 > str.length) {
        rtn += str.substring(pos, str.length);
      } else {
        rtn += str.substring(pos, pos + 10);
        rtn += "\n";
      }
      pos += 10;
    }
    return rtn;
  }

  /**
   * @param g
   * @roseuid 3E043760021D
   */
  paint(g) {
    if (this._img == null) {
      this._img = Resources.IMG_MANUAL_NODE;
    }

    // Call All Sub Elements PAINT METHOD.
    // 保存当前背景颜色...
    let old = this.bgcolor;
    // yx 判断Ctrl数组是否有值
    if(this._owner.checkSelectArr()){
      // yx 判断是否在ctrl数据中
      if(this._owner.isInZoom(this)){
        this.bgcolor = PaintElement.DEF_CURREDITCOLOR;
      }
    }else{
      if (this._owner.isCurrentToEdit(this)) {
        this.bgcolor = PaintElement.DEF_CURREDITCOLOR;
      }
  
      if (this._owner.isCurrentSelected(this)) {
        this.bgcolor = PaintElement.DEF_SELECTEDCOLOR;
      }
    }

    for (let i = 0; i < this._subelems.length; i++) {
      let te = this._subelems[i];
      if (te instanceof PaintElement) {
        let se = te;
        se.paint(g);
      }
    }

    // Fill background
    this.width = Node.WIDTH;
    this.m_width = Node.M_WIDTH;
    this.m_height = Node.M_HEIGHT;
    this.height = Node.HEIGHT;
    this.resize();
    if(this._owner.isCurrentToEdit(this) || this._owner.isInZoom(this)){
      g.setColor(this.bgcolor);
      g.fillRect(this.x - 3, this.y - 3, this.width + 6, this.height + 6);
      g.setColor("#000");
      g.drawOvalBorder(this.x, this.y, this.width, this.height, Node.PAD,this.bgcolor);
    }else{
      g.setColor("#000");
      g.drawOvalBorder(this.x, this.y, this.width, this.height, Node.PAD);
    }

    // Draw Image
    g.drawImage(this._img, this._imgrect.x, this._imgrect.y, this._imgrect.width, this._imgrect.height);

    // g.setColor(Resources.COLOR.lightGray);
    // g.fillRect(this._txtrect.x,this._txtrect.y,this._txtrect.width,10 + this._txtrect.height);
    // g.setColor(Resources.COLOR.black);
    // g.strokeRect(this._txtrect.x,this._txtrect.y,this._txtrect.width,10 + this._txtrect.height);

    if (this.name != null && this.name != "") {
      // 文字显示最大的长度
      let nameWidthMax = g.stringWidth(this.name) > 86 ? 100 : g.stringWidth(this.name);
      const tx = this._txtrect.x + (this._txtrect.width - nameWidthMax) / 2;
      const ty = this._txtrect.y + 2 * this._txtrect.height;
      if (this._iscurrent) {
        // g.drawImage(Resources.IMG_CURRENT_NODE, this._txtrect.x,
        // this._txtrect.y, this._txtrect.width, 10 + this._txtrect.height);
      } else {
        // g.drawImage(Resources.IMG_BACKGROUND_NODE,
        // this._txtrect.x, this._txtrect.y, this._txtrect.width,
        // 		10 + this._txtrect.height);
      }
      g.setColor(Resources.COLOR.black);
      // 字体多换行，再多久显示。。。
      // g.drawString(StringUtil.dencodeHTML(this.name), tx + this.name.length, ty - 10);
      g.drawText(StringUtil.dencodeHTML(this.name), tx + 10, ty - 10, 80);
    }

    // 恢复当前背景颜色
    this.bgcolor = old;
  }

  toXML() {
    var str = "<cn.myapps.runtime.workflow.element.ManualNode>\n";

    str += "<actorListScript><![CDATA[" + this.replaceCharacter(this.actorListScript) + "]]></actorListScript>\n";

    str += "<jumpNameScript><![CDATA[" + this.replaceCharacter(this.jumpNameScript) + "]]></jumpNameScript>\n";
    str += "<jump>" + this.jump + "</jump>\n";
    str += "<jumpTo>" + this.jumpTo + "</jumpTo>\n";

    str += "<actorEditMode>" + this.actorEditMode + "</actorEditMode>\n";
    str += "<deptlist>" + this.replaceCharacter(this.deptlist) + "</deptlist>\n";
    str += "<namelist>" + this.replaceCharacter(this.namelist) + "</namelist>\n";
    str += "<realnamelist>" + this.replaceCharacter(this.realnamelist) + "</realnamelist>\n";
    //审批人通过条件不需要转字符串
    str += "<passcondition>" + (this.passcondition == "" ? "0" : this.passcondition) + "</passcondition>\n";
    str += "<isApproverEdit>" + this.isApproverEdit + "</isApproverEdit>\n";
    str += "<approverEditScript><![CDATA[" + this.replaceCharacter(this.approverEditScript) + "]]></approverEditScript>\n";//彩生活
    str += "<isCoApproverEdit>" + this.isCoApproverEdit + "</isCoApproverEdit>\n"; //彩生活
    str += "<coApproverEditScript><![CDATA[" + this.replaceCharacter(this.coApproverEditScript) + "]]></coApproverEditScript>\n";//彩生活
    str += "<isSupplementComments>" + this.isSupplementComments + "</isSupplementComments>\n"; //彩生活
    str += "<exceedaction>" + this.replaceCharacter(this.exceedaction) + "</exceedaction>\n";
    str += "<issetcurruser>" + this.issetcurruser + "</issetcurruser>\n";
    str += "<inputform>" + this.replaceCharacter(this.inputform) + "</inputform>\n";
    str += "<isgather>" + this.isgather + "</isgather>\n";
    str += "<issplit>" + this.issplit + "</issplit>\n";
    str += "<cBack>" + this.cBack + "</cBack>\n";
    str += "<splitStartNode>" + this.replaceCharacter(this.splitStartNode) + "</splitStartNode>\n";
    str += "<isFrontEdit>" + this.isFrontEdit + "</isFrontEdit>\n";
    str += "<backType>" + this.backType + "</backType>\n";
    str += "<isToPerson>" + this.isToPerson + "</isToPerson>\n";
    str += "<checkedOnSinglePerson>" + this.checkedOnSinglePerson + "</checkedOnSinglePerson>\n";
		str += "<checkedOnMultiplePerson>" + this.checkedOnMultiplePerson + "</checkedOnMultiplePerson>\n";


    str += "<bnodelist>" + this.replaceCharacter(this.bnodelist) + "</bnodelist>\n";
    str += "<retracementEditMode>" + this.retracementEditMode + "</retracementEditMode>\n";
    str += "<cRetracement>" + this.cRetracement + "</cRetracement>\n";
    str += "<retracementScript><![CDATA[" + this.replaceCharacter(this.retracementScript) + "]]></retracementScript>\n";
    str += "<notificationStrategyJSON>" + this.replaceCharacter(this.notificationStrategyJSON) + "</notificationStrategyJSON>\n";
    str += "<isCarbonCopy>" + this.isCarbonCopy + "</isCarbonCopy>\n";
    str += "<isSelectCirculator>" + this.isSelectCirculator + "</isSelectCirculator>\n";
    str += "<circulatorEditMode>" + this.circulatorEditMode + "</circulatorEditMode>\n";
    str += "<circulatorListScript><![CDATA[" + this.replaceCharacter(this.circulatorListScript) + "]]></circulatorListScript>\n";
    str += "<circulatorNamelist>" + this.replaceCharacter(this.circulatorNamelist) + "</circulatorNamelist>\n";
    str += "<userList>" + this.replaceCharacter(this.userList) + "</userList>\n";
    str += "<approverNumType>" + this.approverNumType + "</approverNumType>\n";
    str += "<circulatorNamelistByUser>" + this.replaceCharacter(this.circulatorNamelistByUser) + "</circulatorNamelistByUser>\n";
    str += "<orgField>" + this.orgField + "</orgField>\n";
    str += "<orgScope>" + this.orgScope + "</orgScope>\n";
    str += "<orgRoleCondition>" + this.replaceCharacter(this.orgRoleCondition) + "</orgRoleCondition>\n";
    str += "<isLimited>" + this.isLimited + "</isLimited>\n";
    str += "<timeLimitEditMode>" + this.timeLimitEditMode + "</timeLimitEditMode>\n";
    str += "<timeLimitDay>" + this.timeLimitDay + "</timeLimitDay>\n";
    str += "<timeLimitHour>" + this.timeLimitHour + "</timeLimitHour>\n";
    str += "<timeLimitMinute>" + this.timeLimitMinute + "</timeLimitMinute>\n";
    str += "<timeLimitScript><![CDATA[" + this.replaceCharacter(this.timeLimitScript) + "]]></timeLimitScript>\n";
    str += "<isUsbKeyVerify>" + this.isUsbKeyVerify + "</isUsbKeyVerify>\n";
    str += "<roleCondition>" + this.roleCondition + "</roleCondition>\n";
    str += "<handupEditMode>" + this.handupEditMode + "</handupEditMode>\n";
    str += "<isHandup>" + this.isHandup + "</isHandup>\n";
    str += "<handupScript><![CDATA[" + this.replaceCharacter(this.handupScript) + "]]></handupScript>\n";
    str += "<isAllowEditAuditor>" + this.isAllowEditAuditor + "</isAllowEditAuditor>\n";
    str += "<allowEditAuditorScript><![CDATA[" + this.replaceXML(this.allowEditAuditorScript) + "]]></allowEditAuditorScript>\n";
    str += "<isAllowTermination>" + this.isAllowTermination + "</isAllowTermination>\n";
    str += "<activityPermList>" + this.replaceCharacter(this.activityPermList) + "</activityPermList>\n";
    str += "<urge2ApprovalEditMode>" + this.urge2ApprovalEditMode + "</urge2ApprovalEditMode>\n";
    str += "<allowUrge2Approval>" + this.allowUrge2Approval + "</allowUrge2Approval>\n";
    str += "<allowUrge2ApprovalScript><![CDATA[" + this.replaceCharacter(this.allowUrge2ApprovalScript) + "]]></allowUrge2ApprovalScript>\n";
    str += "<isAllowSkip>" + this.isAllowSkip + "</isAllowSkip>\n";
    str += "<nextNodeCheckedStatus>" + this.nextNodeCheckedStatus + "</nextNodeCheckedStatus>\n";

    //彩生活
    str += "<isAssist>" + this.isAssist + "</isAssist>\n";
    str += "<isSelectAssistUser>" + this.isSelectAssistUser + "</isSelectAssistUser>\n";
    str += "<assistEditMode>" + this.assistEditMode + "</assistEditMode>\n";
    str += "<assistListScript><![CDATA[" + this.replaceXML(this.assistListScript) + "]]></assistListScript>\n";
    str += "<assistNamelist>" + this.assistNamelist + "</assistNamelist>\n";
    str += "<assistNamelistByUser>" + this.assistNamelistByUser + "</assistNamelistByUser>\n";

    str += super.toXML();

    str += "</cn.myapps.runtime.workflow.element.ManualNode>\n";

    return str;
  }

  //xh
  check() {
    let result = super.check();
    //判断节点是否填写了状态标签和名称
    if (!result) {
      return false;
    }
    //人工节点角色范围校验
    if (!this.actorEditMode) {
      if (!this.namelist) {
        alert("请为" + this.name + "节点在审批人设置里选择角色范围！");
        return false;
      }
    }
    //人工节点审批人脚本选项校验
    if (this.actorEditMode == 1) {
      if (!this.actorListScript) {
        alert("请为" + this.name + "节点在审批人设置里填写脚本！");
        return false;
      }
    }
    if (this.actorEditMode == 0 && !this.namelist && !this.deptlist) {
      alert("请为" + this.name + "节点在审批人设置里选择部门和角色,部门和角色必须填写其中一个！");
      return false;
    }
    if (this.deptlist) {
      let patt1 = new RegExp(/(([A-Za-z0-9\u4e00-\u9fa5]{1,}\/)|(([*]{1,}\/)(?=([A-Za-z0-9\u4e00-\u9fa5]{1,}\/)))|((?<=([A-Za-z0-9\u4e00-\u9fa5]{1,}\/))([*]{1}\/)$))/g);
      // let patt2=new RegExp(/[*]{1,}\//);
      if (this.deptlist.indexOf(";") != -1) {
        if (this.deptlist.replace(patt1, "") == "") {
          // if(this.deptlist.replace(patt2,"")==""){
          // 	lert('请为'+this.name+'节点在审批人设置里填写正确的部门！');
          // 	return false;
          // }
        } else {
          alert("请为" + this.name + "节点在审批人设置里填写正确的部门！");
          return false;
        }
        this.deptlist = this.deptlist.slice(0, -1);
      }
      var arr = this.deptlist.split(";");
      for (var i = 0; i < arr.length; i++) {
        arr[i] += "/";
        if (arr[i].replace(patt1, "") == "") {
          // if(arr[i].replace(patt2,"")==""){
          // 	lert('请为'+this.name+'节点在审批人设置里填写正确的部门！');
          // 	return false;
          // }
        } else {
          alert("请为" + this.name + "节点在审批人设置里填写正确的部门！");
          return false;
        }
        arr[i] = arr[i].slice(0, -1);
      }
      this.deptlist = arr.join(";");
    }

    //人工节点组织选项校验
    // if(this.actorEditMode == 3) {
    // 	//当组织选项为提交者自己时，可以不选择角色范围
    // 	if(this.orgField != 'curruser' && this.orgField != 'initiator') {
    // 		if(!this.orgRoleCondition) {
    //   			alert('请为'+this.name+'节点在审批人设置里选择角色范围！');
    // 		  	return false;
    // 		}
    // 	}
    // }
    //人工节点审批时限校验
    if (this.isLimited) {
      if (this.timeLimitEditMode == 0) {
        //非空校验，Number()会把空字符串转为0
        if (Number(this.timeLimitDay) == 0 && Number(this.timeLimitHour) == 0 && Number(this.timeLimitMinute) == 0) {
          alert("请为" + this.name + "节点填写大于0的审批时限！");
          return false;
        }
        //合法性校验
        if (
          Number(this.timeLimitDay) < 0 ||
          isNaN(Number(this.timeLimitDay)) ||
          Number(this.timeLimitHour) < 0 ||
          isNaN(Number(this.timeLimitHour)) ||
          Number(this.timeLimitMinute) < 0 ||
          isNaN(Number(this.timeLimitMinute))
        ) {
          alert(this.name + "节点审批时限填写不符合要求！");
          return false;
        }
      }

      if (this.timeLimitEditMode == 1) {
        if (!this.timeLimitScript) {
          alert("请为" + this.name + "节点填写审批时限脚本！");
          return false;
        }
      }
    }
    //人工节点协办人校验
    if (this.isAssist) {
      if (this.assistEditMode == 0) {
        if (!this.assistNamelist) {
          alert("请为" + this.name + "节点选择协办人角色范围！");
          return false;
        }
      }

      if (this.assistEditMode == 1) {
        if (!this.assistListScript) {
          alert("请为" + this.name + "节点填写协办人脚本！");
          return false;
        }
      }
    }
    //人工节点抄送校验
    if (this.isCarbonCopy) {
      if (this.circulatorEditMode == 0) {
        if (!this.circulatorNamelist) {
          alert("请为" + this.name + "节点选择抄送角色范围！");
          return false;
        }
      }

      if (this.circulatorEditMode == 1) {
        if (!this.circulatorListScript) {
          alert("请为" + this.name + "节点填写抄送脚本！");
          return false;
        }
      }
    }
    //聚合节点校验
    if (this.isgather) {
      if (!this.splitStartNode) {
        alert("请为" + this.name + "节点选择聚合审批节点(若选择聚合选项，则流程中至少要有一个节点开启并行)！");
        return false;
      }
    }
    //回退时校验
    if (this.cBack) {
      if (this.backType == 1) {
        if (!this.bnodelist) {
          alert("请为" + this.name + "节点选择指定回退节点！");
          return false;
        }
      }
    }
    //回撤时校验
    if (this.retracementEditMode == 1) {
      if (!this.retracementScript) {
        alert("请为" + this.name + "节点填写回撤脚本！");
        return false;
      }
    }
    //挂起时校验
    if (this.handupEditMode == 1) {
      if (!this.handupScript) {
        alert("请为" + this.name + "节点填写挂起脚本！");
        return false;
      }
    }
    //催办校验
    if (this.urge2ApprovalEditMode == 1) {
      if (!this.allowUrge2ApprovalScript) {
        alert("请为" + this.name + "节点填写催办脚本！");
        return false;
      }
    }
    //通知校验
    if (this.notificationStrategyJSON) {
      let notificationStrategyJSON = JSON.parse(StringUtil.dencodeHTML(this.notificationStrategyJSON));

      if (notificationStrategyJSON.send) {
        if (notificationStrategyJSON.send.receiverTypes.length == 0 || notificationStrategyJSON.send.sendModeCodes.length == 0 || !notificationStrategyJSON.send.template) {
          alert("请为" + this.name + "节点选择提交时的接收对象、发送方式和发送内容！");
          return false;
        }
      }

      if (notificationStrategyJSON.arrive) {
        if (notificationStrategyJSON.arrive.sendModeCodes.length == 0 || !notificationStrategyJSON.arrive.template) {
          alert("请为" + this.name + "节点选择到达时的发送方式和发送内容！");
          return false;
        }
      }

      if (notificationStrategyJSON.reject) {
        if (!notificationStrategyJSON.reject.responsibleType || notificationStrategyJSON.reject.sendModeCodes.length == 0 || !notificationStrategyJSON.reject.template) {
          alert("请为" + this.name + "节点选择回退时的接收对象、发送方式和发送内容！");
          return false;
        }
      }

      if (notificationStrategyJSON.overdue) {
        if (notificationStrategyJSON.overdue.editMode == 0) {
          if (Number(notificationStrategyJSON.overdue.limittimecount) == 0 || !notificationStrategyJSON.overdue.timeunit) {
            alert("请为" + this.name + "节点在过期时设计脚本中填写时限和选择单位！");
            return false;
          }

          if (Number(notificationStrategyJSON.overdue.limittimecount) < 0 || isNaN(Number(notificationStrategyJSON.overdue.limittimecount))) {
            alert(this.name + "节点在过期时设计脚本中时限填写格式有误！");
            return false;
          }
        }

        if (notificationStrategyJSON.overdue.editMode == 1) {
          if (!notificationStrategyJSON.overdue.limittimeScript) {
            alert("请为" + this.name + "节点在过期时iscript脚本名称中填写脚本！");
            return false;
          }
        }

        if (notificationStrategyJSON.overdue.sendModeCodes.length == 0 || !notificationStrategyJSON.overdue.template) {
          alert("请为" + this.name + "节点选择过期时的发送方式、发送内容！");
          return false;
        }
      }

      if (notificationStrategyJSON.reminder) {
        if (notificationStrategyJSON.reminder.sendModeCodes.length == 0) {
          alert("请为" + this.name + "节点选择催办时的发送方式！");
          return false;
        }
      }

      if (notificationStrategyJSON.assist) {
        if (notificationStrategyJSON.assist.sendModeCodes.length == 0 || !notificationStrategyJSON.assist.template) {
          alert("请为" + this.name + "节点选择到达协办时的发送方式和发送内容！");
          return false;
        }
      }

      if (notificationStrategyJSON.carbonCopy) {
        if (notificationStrategyJSON.carbonCopy.sendModeCodes.length == 0 || !notificationStrategyJSON.carbonCopy.template) {
          alert("请为" + this.name + "节点选择抄送时的发送方式和发送内容！");
          return false;
        }
      }
    }

    return true;
  }

  //xh
  hasRelation(relation) {
    let { input, output } = super.hasRelation(relation);

    if (input == 0 && output == 0) {
      alert("请创建" + this.name + "节点的关联线！");
      return false;
    } else if (output > 0 && input == 0) {
      alert(this.name + "节点缺少接入节点！");
      return false;
    } else if (input > 0 && output == 0) {
      alert("请为" + this.name + "节点连接其他节点！");
      return false;
    } else {
      return true;
    }
  }

  // yx
  hasSomeRelation (relation) {
    return super.hasRelation(relation)
  }

  showTips(g) {
    let tips = "";
    // yx 如果是【部门和角色】显示相关内容，如果是脚本操作者显示脚本，如果是组织操作者显示组织
    if(this.actorEditMode == 0){
      let shortname = this.getFormatShortNameListStr();
      if (shortname != null && shortname.trim() != "" && shortname.trim() != "null") {
        tips += "操作者：" + shortname;
        tips += "\n";
      }
    }else if(this.actorEditMode == 1){
      tips += "操作者：脚本";
    }else if(this.actorEditMode == 3){
      tips += "操作者：组织";
    }
    this.drawTips(g, tips);
  }

  getPassCondition() {
    try {
      return Integer.parseInt(passcondition);
    } catch (e) {
      return 0;
    }
  }

  getNotificationStrategyMap() {
    try {
      // 测试数据
      // notificationStrategyJSON = "{"
      // + "arrive: {sendModeCodes:[0, 1]}, "
      // + "overdue: {sendModeCodes:[0, 1], limittimecount:12, timeunit:0,
      // isnotifysuperior:true},"
      // + "reject: {sendModeCodes:[0, 1], responsibleType: 256}"
      // + "}";
      let jsonStr = "";
      if (!StringUtil.isBlank(notificationStrategyJSON)) {
        jsonStr = StringUtil.dencodeHTML(notificationStrategyJSON);
      }
      //jsonStr = "{\"overdue\":{\"editMode\":\"1\",\"limittimeScript\":\"IjIwMTMtOC0yMyAxNDowMDowMCI7 \",\"sendModeCodes\":[2],\"limittimecount\":\"1\",\"timeunit\":\"0\",\"isnotifysuperior\":\"false\",\"template\":\"11e1-73c9-2a559d21-b25e-b1c3fd11d730\"}}";
      return JsonUtil.toMap(jsonStr);
    } catch (e) {
      return e;
    }
  }
}

/**
 * 审批人编辑模式, 角色设计
 */
ManualNode.ACTOR_EDIT_MODE_DESIGN = 0;
/**
 * 审批人编辑模式, 脚本
 */
ManualNode.ACTOR_EDIT_MODE_CODE = 1;
/**
 * 审批人编辑模式, 用户设计
 */
ManualNode.ACTOR_EDIT_MODE_USER_DESIGN = 2;

/**
 * 审批人编辑模式, 组织
 */
ManualNode.ACTOR_EDIT_MODE_ORGANIZATION_DESIGN = 3;
/**
 * 是否可催办编辑模式-设计模式
 */
ManualNode.URGE_TO_APPROVAL_EDIT_MODE_DESIGN = 0;
/**
 * 是否可催办编辑模式-脚本模式
 */
ManualNode.URGE_TO_APPROVAL_EDIT_MODE_CODE = 1;
/**
 * 抄送人编辑模式, 角色设计
 */
ManualNode.CIRCULATOR_EDIT_MODE_DESIGN = 0;
/**
 * 抄送人编辑模式, 脚本
 */
ManualNode.CIRCULATOR_EDIT_MODE_CODE = 1;

/**
 * 抄送人编辑模式, 用户设计
 */
ManualNode.CIRCULATOR_EDIT_MODE_USER_DESIGN = 2;

/**
 * 任意, 任意一个负责人处理后通过
 */
ManualNode.PASS_CONDITION_OR = 0;
/**
 * 会签, 每个负责人处理后通过
 */
ManualNode.PASS_CONDITION_AND = 1;
/**
 * 有顺序的会签, 每个负责人按顺序处理后通过
 */
ManualNode.PASS_CONDITION_ORDERLY_AND = 2;

/**
 * 组织-作者
 */
ManualNode.ORG_AUTHOR = "author";

/**
 * 组织-提交者
 */
ManualNode.ORG_AUDITOR = "auditor";

/**
 * 组织-发起人
 */
ManualNode.ORG_INITIATOR = "initiator";
/**
 * 组织-当前登录用户
 */
ManualNode.ORG_CURRUSER = "curruser";

/**
 * 上级用户
 */
ManualNode.ORG_SCOPE_SUPERIOR = "superior";

/**
 * 下级用户
 */
ManualNode.ORG_SCOPE_LOWER = "lower";

/**
 * 本级默认部门
 */
ManualNode.ORG_SCOPE_DEPT_DEFAULT = "default";

/**
 * 直属上级部门
 */
ManualNode.ORG_SCOPE_DEPT_LINE_SUPERIOR = "lineSuperior";

/**
 * 直属下级部门
 */
ManualNode.ORG_SCOPE_DEPT_LINE_LOWER = "lineLower";
/**
 * 所有上级部门
 */
ManualNode.ORG_SCOPE_DEPT_ALL_SUPERIOR = "allSuperior";

/**
 * 所有下级部门
 */
ManualNode.ORG_SCOPE_DEPT_ALL_LOWER = "allLower";

/**
 * 自身
 */
ManualNode.ORG_SCOPE_SELF = "self";

/**
 * 审批时限编辑模式, 设计
 */
ManualNode.TIMELIMIT_EDIT_MODE_DESIGN = 0;
/**
 * 审批时限编辑模式, 脚本
 */
ManualNode.TIMELIMIT_EDIT_MODE_CODE = 1;

/**
 * 流程发起人上级
 */
ManualNode.ROLE_CONDITION_INITIATOR_SUPERIOR = "initiator_superior";

/**
 * 流程发起人所属部门上级
 */
ManualNode.ROLE_CONDITION_INITIATOR_DEP_SUPERIOR = "initiator_dep_superior";

/**
 * 审批人部门为提交人默认部门
 */
ManualNode.ROLE_CONDITION_CURRUSER_DEFAULT_DEPT = "curruser_default_dept";

/**下一步节点的选中状态为选中**/
ManualNode.NEXT_NODE_CHECKED_STATUS_CHECKED = 0;
/**下一步节点的选中状态为不选中**/
ManualNode.NEXT_NODE_CHECKED_STATUS_UNCHECKED = 1;
/**下一步节点的选中状态为选中且锁定**/
ManualNode.NEXT_NODE_CHECKED_STATUS_CHECKED_AND_LOCKED = 2;

export default ManualNode;
