class Graphics {
  constructor(ctx) {
    this.ctx = ctx;
    this.ctx.translate(0.5, 0.5);
  }
  checkWH(w, h) {
    if (w <= 0) {
      w = 0;
    }
    if (h <= 0) {
      h = 0;
    }
    return {
      w: w,
      h: h,
    };
  }
  setColor(color) {
    this.ctx.fillStyle = color;
    this.ctx.strokeStyle = color;
  }

  setFont(font) {
    this.ctx.font = font;
  }

  setLineWidth(width) {
    this.ctx.lineWidth = width;
  }

  setShadow(color, x, y, blur) {
    this.ctx.shadowColor = color;
    this.ctx.shadowOffsetX = x;
    this.ctx.shadowOffsetY = y;
    this.ctx.shadowBlur = blur;
  }

  textAlign(align) {
    this.ctx.textAlign = align;
  }

  textBaseLine(pos) {
    this.ctx.textBaseline = pos;
  }

  stringWidth(txt) {
    return this.ctx.measureText(txt).width;
  }

  strokeRect(x, y, width, height) {
    this.ctx.strokeRect(x, y, width, height);
  }

  translate(x, y) {
    this.ctx.translate(x, y);
  }

  fillText(text, x, y) {
    this.ctx.fillText(text, x, y);
  }

  fillRect(x, y, width, height) {
    this.ctx.fillRect(x, y, width, height);
  }

  clearRect(x, y, width, height) {
    this.ctx.clearRect(x, y, width, height);
  }

  fillPolygon(polygon) {
    this.ctx.beginPath();
    for (let i = 0; i < polygon.points.length; i++) {
      if (i == 0) {
        this.ctx.moveTo(polygon.points[i].x, polygon.points[i].y);
      } else {
        this.ctx.lineTo(polygon.points[i].x, polygon.points[i].y);
      }
    }
    this.ctx.fill();
  }

  drawLine(x1, y1, x2, y2) {
    this.ctx.beginPath();
    this.ctx.moveTo(x1, y1);
    this.ctx.lineTo(x2, y2);
    this.ctx.closePath();
    this.ctx.stroke();
  }
  //绘制元素线
  drawLineEle(x1, y1, x2, y2, lineWidth = 1, lineStyle = "Solid", lineColor) {
    this.ctx.beginPath();
    this.ctx.lineWidth = lineWidth;
    this.ctx.strokeStyle = lineColor;
    if (lineStyle == "Solid") {
      this.ctx.setLineDash([]);
    } else if (lineStyle == "Dashed") {
      this.ctx.setLineDash([20, 10]);
    } else if (lineStyle == "Dotted") {
      this.ctx.setLineDash([lineWidth, lineWidth]);
    } else if (lineStyle == "Double") {
      this.ctx.moveTo(x1, y1 - lineWidth);
      this.ctx.lineTo(x2, y2 - lineWidth);
      this.ctx.moveTo(x1, y1 + lineWidth);
      this.ctx.lineTo(x2, y2 + lineWidth);
      this.ctx.stroke();
      return;
    }
    this.ctx.moveTo(x1, y1);
    this.ctx.lineTo(x2, y2);
    //this.ctx.closePath();
    this.ctx.stroke();
  }
  //设置线条样式
  setStyle(lineWidth = 1, lineStyle = "Solid", lineColor) {
    if (lineStyle == "Solid") {
      this.ctx.setLineDash([]);
    } else if (lineStyle == "Dashed") {
      this.ctx.setLineDash([20, 10]);
    } else if (lineStyle == "Dotted") {
      this.ctx.setLineDash([lineWidth, lineWidth]);
    }
    this.ctx.lineWidth = lineWidth;
    this.ctx.strokeStyle = lineColor;
  }
  //设置线条默认样式
  setLineStyle() {
    this.ctx.setLineDash([]);
    this.ctx.lineWidth = 1;
    this.ctx.strokeStyle = "#000";
  }
  drawImage(image, x, y, width, height) {
    this.ctx.drawImage(image, x, y, width, height);
  }

  drawRect(x, y, width, height) {
    this.ctx.strokeRect(x, y, width, height);
  }
  /**该方法用来绘制圆角矩形
   *@param cxt:canvas的上下文环境
   *@param x:左上角x轴坐标
   *@param y:左上角y轴坐标
   *@param width:矩形的宽度
   *@param height:矩形的高度
   *@param radius:圆的半径
   *@param lineWidth:线条粗细
   *@param strokeColor:线条颜色
   **/
  drawRuondRect(x, y, width, height, radius) {
    this.ctx.translate(x, y);
    this.ctx.beginPath();
    //从右下角顺时针绘制，弧度从0到1/2PI
    this.ctx.arc(width - radius, height - radius, radius, 0, Math.PI / 2);

    //矩形下边线
    this.ctx.lineTo(radius, height);

    //左下角圆弧，弧度从1/2PI到PI
    this.ctx.arc(radius, height - radius, radius, Math.PI / 2, Math.PI);

    //矩形左边线
    this.ctx.lineTo(0, radius);

    //左上角圆弧，弧度从PI到3/2PI
    this.ctx.arc(radius, radius, radius, Math.PI, (Math.PI * 3) / 2);

    //上边线
    this.ctx.lineTo(width - radius, 0);

    //右上角圆弧
    this.ctx.arc(width - radius, radius, radius, (Math.PI * 3) / 2, Math.PI * 2);

    //右边线
    this.ctx.lineTo(width, height - radius);
    this.ctx.closePath();
  }
  stroke() {
    this.ctx.stroke();
  }
  fill() {
    this.ctx.fill();
  }
  drawString(text, x, y) {
    this.ctx.strokeText(text, x, y);
  }

  drawTextWithRow(text, x, y, maxWidth, maxHeight = 24, lineHeight, lineSpacingSize, firstIndex, leftIndent, rightIndent, spare = 0) {
    if (typeof text != "string" || typeof x != "number" || typeof y != "number") {
      return;
    }

    if (typeof maxWidth == "undefined") {
      maxWidth = 142;
    }

    if (typeof lineHeight == "undefined") {
      lineHeight = 12;
    }
    if (leftIndent != 0) {
      x += leftIndent;
      maxWidth = maxWidth - leftIndent;
    }
    if (rightIndent != 0) {
      maxWidth = maxWidth - rightIndent;
    }
    //将文本拆为单个字符数组
    let arrText = text.split("");
    let line = "";
    let textLine = "";
    let first = true;
    let height;
    if (this.ctx.textBaseline == "bottom") {
      height = lineHeight + (lineSpacingSize * lineHeight) / 2;
    } else {
      height = lineHeight + spare;
    }
    for (let i = 0; i < arrText.length; i++) {
      textLine = line + arrText[i];
      let metrics = this.ctx.measureText(textLine);
      let textLen = metrics.width;
      if (textLen > maxWidth - firstIndex) {
        if (height > maxHeight) {
          return false;
        } else {
          if (first) {
            this.ctx.fillText(line, x + firstIndex, y);
            first = false;
          } else {
            this.ctx.fillText(line, x, y);
          }
          line = arrText[i];
          height += lineHeight + (lineSpacingSize * lineHeight) / 2;
          y += lineHeight + (lineSpacingSize * lineHeight) / 2;
        }
        // if(first){
        // 	this.ctx.fillText(line, x+firstIndex, y);
        // 	first=false;
        // }else{
        // 	this.ctx.fillText(line, x, y);
        // }
        // line = arrText[i];
        // y += lineHeight+lineSpacingSize*lineHeight/2;
      } else {
        line = textLine;
      }
    }
    if (height < maxHeight) this.ctx.fillText(line, x, y);
  }

  drawArc(x, y, r, color, borderColor, staAngle = 0, endAngle = Math.PI * 2, antiClockWise = false) {
    this.ctx.beginPath();
    this.ctx.arc(x, y, r, staAngle, endAngle, antiClockWise);
    this.ctx.closePath();
    this.setColor(borderColor);
    this.setLineWidth(1);
    this.ctx.stroke();
    this.setColor(color);
    this.ctx.fill();
  }

  drawEllipse(x, y, radiusX, radiusY, mode, color, rotation = 0, startAngle = 0, endAngle = Math.PI * 2, anticlockwise = false) {
    this.ctx.beginPath();
    this.ctx.ellipse(x, y, radiusX, radiusY, rotation, startAngle, endAngle, anticlockwise);
    this.ctx.closePath();
    // this.setColor(color.backcolor);
    // this.ctx.stroke();
    if (mode == "Opaque") {
      this.setColor(color.backcolor);
      this.ctx.fill();
    } else {
      this.setColor(color.forecolor);
      //this.ctx.stroke();
    }
  }
  drawEllipseLine(x, y, radiusX, radiusY, rotation = 0, startAngle = 0, endAngle = Math.PI * 2, anticlockwise = false) {
    this.ctx.beginPath();
    this.ctx.ellipse(x, y, radiusX, radiusY, rotation, startAngle, endAngle, anticlockwise);
    this.ctx.closePath();
    this.ctx.stroke();
  }
  clearRect(x, y, width, height) {
    this.ctx.clearRect(x, y, width, height);
  }

  getTextWidth(text) {
    const textLen = this.ctx.measureText(text).width;

    return textLen;
  }

  save() {
    this.ctx.save();
  }

  restore() {
    this.ctx.restore();
  }
}

export default Graphics;
