import TextElement from "./TextElement";
import { Sequence, Archor,Api} from "../../utility";
class SubReport extends TextElement {
  constructor() {
    super();
    this.text = SubReport.DEF_TEXT; //当前元素默认文本
    this.belong = "";
    this.isOpenArchor = false;
    this.width = 50;
    this.height = 50;
    this.src = "images/subReport.png";
    this.key = "子报表";
    this.subreportExpression="";//子报表表达式
    this.subParameter=[];//子报表parameter参数
  }

  getClassName() {
    return "SubReport";
  }

  getNodeConfigInfo() {
    let node = {};
    node.text = this.key == "" ? this.text : this.key;
    node.src = this.src;
    node.icon = "\tglyphicon glyphicon-picture";
    node.uuid = this.getProp("id");
    node.instance = this;
    return node;
  }

  /**
   * @param g
   */
  paint(g) {
    //console.log(this)
    const that = this;
    var a = g.checkWH(this.width, this.height);
    this.width = a.w;
    this.height = a.h;
    let length = 0;
    if (!this.id) {
      this.id = Sequence.createUuid();
    }
    g.save();
    g.setStyle(this.lineWidth, this.lineStyle, this.lineColor);
    that.nowX,
      that.nowY,
      that.nowW,
      that.nowH,
      that.imgH,
      that.imgW,
      that.imgX,
      that.imgY;
    if (this.mode == "Opaque") {
      g.strokeRect(that.x, that.y, that.width, that.height);
      that.imgX = that.nowX = that.x + this.lineWidth;
      that.imgY = that.nowY = that.y + this.lineWidth;
      that.imgW = that.nowW = that.width - this.lineWidth * 2;
      that.imgH = that.nowH = that.height - this.lineWidth * 2;
      g.fillRect(
        that.x + this.lineWidth,
        that.y + this.lineWidth,
        that.width - this.lineWidth * 2,
        that.height - this.lineWidth * 2
      );
    } else {
      g.strokeRect(that.x, that.y, that.width, that.height);
      that.nowX = this.imgX = that.x + this.lineWidth;
      that.nowY = this.imgY = that.y + this.lineWidth;
      that.nowW = this.imgW = that.width - this.lineWidth * 2;
      that.nowH = this.imgH = that.height - this.lineWidth * 2;
    }
    g.setLineStyle();
    let img = new Image();
    img.src = that.src;
    img.onload = function() {
      g.drawImage(img, that.imgX, that.imgY, that.imgW, that.imgH);
    };
    if (this.error) {
      let img2 = new Image();
      img2.src = this.errorImgSrc;
      img2.onload = function() {
        g.drawImage(img2, that.x, that.y, 15, 15);
      };
    }
    g.restore();

    if (this.isOpenArchor) {
      const archor = Archor.getInstance();
      const openArchor = [
        { x: 0, y: 0 },
        { x: 1, y: 0 },
        { x: 1, y: 1 },
        { x: 0, y: 1 }
      ]; //以当前元素左上角为坐标系，得(0, 0)为左上角，依次类推
      const params = {
        x: this.x,
        y: this.y,
        targetW: this.width,
        targetH: this.height,
        openArchorPos: openArchor
      };

      archor.setProps(params);
      archor.paint(g);
    }
  }

  toXML() {
    let api=new Api();
    let back;
    // yx 将表达式转换为子报表id
    if(!params.subReportId){
      params.subReportId = this.subreportExpression
    }else{
      params.subReportId += ','+this.subreportExpression
    }
    // $.when(api.getSubReport(report.myId),).done((reportNames) => {
      
    // })
    $.when(api.getReportPath(this.subreportExpression)).done((data) => {
      back=data.data;
      
    })
    let str = "<subreport>\n";
    str += super.toXML2();
    if(this.subParameter.length>0){
      this.subParameter.forEach(function(val){
        str += `<subreportParameter name="`+val.name+`">\n`;
        str +=`<subreportParameterExpression><![CDATA[`+val.expression+`]]></subreportParameterExpression>\n`;
        str +=`</subreportParameter>\n`;
      })
    }
    str +=` <dataSourceExpression><![CDATA[$P{REPORT_DATA}]]></dataSourceExpression>\n`;
    str +=`<subreportExpression><![CDATA["`+back+`"]]></subreportExpression>\n`
    
    str += "</subreport>\n";

    return str;
    
  }

  parseXML(xmlNode) {
    let api=new Api();
    let props = {};
    props.subParameter=[];
    let that = this;
    this.scaleImage = xmlNode.getAttribute("scaleImage");
    this.hAlign = xmlNode.getAttribute("hAlign");
    this.vAlign = xmlNode.getAttribute("vAlign");

    const traversalNode = xmlNode => {
      //console.log(xmlNode);
      const { tagName } = xmlNode;
      //console.log(tagName);

      switch (tagName) {
        case "reportElement":
          const reportElement = this.handleReportElement(xmlNode);
          Object.assign(props, reportElement);
          break;
        case "subreportParameter":
          let name,expression;
          name=xmlNode.getAttribute('name');
          expression=xmlNode.getElementsByTagName("subreportParameterExpression")[0].innerHTML.replace(/\<\!\[CDATA\[/, '').replace(/\]\]\>/, '');
          props.subParameter.push({"expression":expression,"name":name,"checked":false})
          break;
        case "subreportExpression":
          let subReportIdArr=params.subReportId.split(',')
          let subreportExpression=xmlNode.innerHTML.replace(/\<\!\[CDATA\[/, '').replace(/\]\]\>/, '');
          subreportExpression=subreportExpression.substring(1,subreportExpression.length-1)
          for(let i=0;i<subReportIdArr.length;i++){
            $.when(api.getReportPath(subReportIdArr[i])).done((data) => {
              if(data.data==subreportExpression){
                 props.subreportExpression=subReportIdArr[i];
              }
            })
          }
          // props.subreportExpression=arr[arr.length-1].replace(/.jasper/,"")
          // console.log(jQuery("#subReportId").val())
          // props.subreportExpression=params.subReportId;
          break;
        default:
          break;
      }
    };

    if (xmlNode.hasChildNodes()) {
      for (let i = 0, len = xmlNode.children.length; i < len; i++) {
        traversalNode(xmlNode.children[i]);
      }
    }
    //console.log(props)
    this.setProps(props);

    return props;
  }

  // showTips(g) {
  // let tips = '';
  // tips += this.text;
  // this.drawTips(g, tips);
  // }
}

SubReport.DEF_TEXT = "image";

export default SubReport;
