import AbstractField from "./AbstractField";
import { Sequence } from "../../utility";

class AttachmentField extends AbstractField{
    constructor(container) {
        super();
        this.scope="attachmentField"
        this.container = container;
        this.htmlDOM=null;
        
        this.className="baseField";
        this.propValues.id = Sequence.createUuid();
        this.html=`<div style="padding: 5px 0;line-height: 20px;color: #3d464d;font-weight: 600;">
        <span  class="baseLabel-title" style="font-size: 14px;color: #3d464d;">文件上传</span>
        </div><div class="baseCon fieldId" fieldid='${this.propValues.id}' >
        <button class="baseCon-btn">文件上传</button></div>`;
        this.propValues.name="文件上传"+window.formApp.formPanel.propValues.nameIndex;

        this.propValues.readonlyshowvalonly = true; //只读时仅只显示值
        this.propValues.refreshonchanged = false; //刷新
        this.propValues.calculateonrefresh = false; //重计算
        this.propValues.mobile = true; //手机可用
        this.propValues.refreshmode = "0"; //重刷新的方式
        this.propValues.refreshfields = []; //局部刷新的字段组合
        this.propValues.discript ="";
        // this.propValues.refresh = '0';
        this.propValues.editProp="editInputField";
        this.propValues.validatelibs =[]; //校验方式
        this.propValues.validaterule = ""; //校验脚本
        this.propValues.instantvalidate = false; //即时校验（新增属性）


        this.propValues.hiddenscript = ""; //隐藏条件脚本
        this.propValues.hiddenvalue = ""; //隐藏时显示值
        this.propValues.hiddenprintscript = ""; //打印时隐藏条件脚本
        this.propValues.printhiddenvalue = ""; //打印隐藏时显示值
        this.propValues.readonlyscript = ""; //只读条件脚本
        
        this.propValues.limitsize = ""; //限制单个上传文件大小
        this.propValues.filetype="00";//上传文件类型
        this.propValues.customizetype="";//自定义上传类型的内容
        this.propValues.limitnumber=10;//最大上传数量
        this.propValues.filepattern="00";//存放路径
        this.propValues.filecatalog="";//自定义存放路径
        this.propValues.previewedit=true;//office 文档预览时可编辑
        this.propValues.openwatermark=false;//是否添加水印
        this.propValues.supportsorting="false";//文件排序功能
        this.propValues.watermarksupportmode="";//添加水印模式
        this.propValues.watermarkscript=""//添加水印脚本
        this.propValues.showtrackrevisions=true;//托盘编辑显示痕迹
        this.propValues.showusernameanddate=true;//显示用户名和日期

        this.propValues.fieldtype="VALUE_TYPE_TEXT";
        
    }
    getPropsDesc() {
        return {
            "base":['myselfrows','name','limitsize','filetype','customizetype','limitnumber','filepattern','filecatalog','readonlyshowvalonly','refreshonchanged','refreshmode','refreshfields','calculateonrefresh','mobile','previewedit','showtrackrevisions','showusernameanddate','openwatermark','watermarksupportmode','watermarkscript','supportsorting','discript'],
            "check":['validatelibs','validaterule','instantvalidate'],
            "hidden":['hiddenscript','hiddenvalue'],
            "hiddenprint":["hiddenprintscript","printhiddenvalue"],
            "readonly":['readonlyscript']


        }
    }
    //校验特殊属性
    checkSpeProp(){
        if(this.propValues.openwatermark==true){
            if(this.propValues.watermarksupportmode==''){
                alert('请选择一种水印模式')
                return false
            }else{
                if(this.propValues.watermarkscript==''){
                    alert('请输入水印脚本')
                    return false
                }
            }
        }
        return true;
    }
    
}
export default AttachmentField;