import Node from "./Node";
import FlowDiagram from "./FlowDiagram";
import PaintElement from "./PaintElement";
import Rectangle from "../utility/Rectangle";
import Resources from "../utility/Resources";
import StringUtil from "../utility/StringUtil";

class SubFlow extends Node {
  constructor(diagram) {
    super(diagram);
    /**
     * 绑定子流程定义的类型
     */
    this.subFlowDefiType = "";
    /**
     * 子流程定义id
     */
    this.subflowid = "";

    /**
     * 子流程名称
     */
    this.subflowname = "";

    /**
     * 通过脚本返回值设置流程（返回流程ID）
     */
    this.subflowScript = "";

    /**
     * 参数传递设置方式
     */
    this.paramPassingType = "";

    /**
     * 父流程关联表单ID
     */
    this.parentFlowFormId = "";

    /**
     * 父流程关联表单名称
     */
    this.parentFlowFormName = "";

    /**
     * 子流程关联表单ID
     */
    this.subFlowFormId = "";

    /**
     * 子流程关联表单名称
     */
    this.subFlowFormName = "";

    /**
     * 表单字段映射（XML格式）
     */
    this.fieldMappingXML = "";

    /**
     * 是否共享主流程文档
     */
    this.shareDocument = false;

    /**
     * 参数传递脚本
     */
    this.paramPassingScript = "";

    /**
     * 流程实例启动数量设置方式
     */
    this.numberSetingType = "";

    /**
     * 流程实例启动数量设置内容 （可以是数字、字段名和脚本）
     */
    this.numberSetingContent = "";

    /**
     * 是否回调
     */
    this.callback = false;

    /**
     * 回调脚本
     */
    this.callbackScript = "";

    this.iscurrent = false;

    this.ispassed = false; // 是否审核

    /**
     * 是否为聚合节点
     */
    this.isgather = false; // 是否聚合节点

    /**
     * 分散起始节点
     */
    this.splitStartNode = "";

    /**
     * 是否为分散节点(默认为true)
     */
    this.issplit = true;

    /**
     * 是否指的审批人
     */
    this.isToPerson = false;
    //当审批人只有一个人时，默认选中该人
    this.checkedOnSinglePerson = false;
        // 只有一个审批人的时候，是否默认选中审批人

    this.checkedOnMultiplePerson = false;


    this.subflowFormid = ""; // 子流程表单ID

    this.subflowFormname = ""; // 子流程表单名称

    /**
     * @deprecated since 2.6
     */
    this.crossform = false; // 跨表单

    /**
     * 子流程启动时执行的脚本
     * @deprecated since 2.6
     */
    this.startupScript = "";
  }

  getClassName() {
    return "cn.myapps.runtime.workflow.element.SubFlow";
  }

  paint(g) {
    if (this._img == null) {
      this._img = Resources.IMG_SUBFLOW_NODE;
    }

    let old = this.bgcolor;
    // yx 判断Ctrl数组是否有值
    if(this._owner.checkSelectArr()){
      // yx 判断是否在ctrl数据中
      if(this._owner.isInZoom(this)){
        this.bgcolor = PaintElement.DEF_CURREDITCOLOR;
      }
    }else{
      if (this._owner.isCurrentToEdit(this)) {
        this.bgcolor = PaintElement.DEF_CURREDITCOLOR;
      }
  
      if (this._owner.isCurrentSelected(this)) {
        this.bgcolor = PaintElement.DEF_SELECTEDCOLOR;
      }
    }

    for (let i = 0; i < this._subelems.length; i++) {
      let te = this._subelems[i];
      if (te instanceof PaintElement) {
        let se = te;
        se.paint(g);
      }
    }

    // Fill background
    this.width = Node.WIDTH;
    this.m_width = Node.M_WIDTH;
    this.m_height = Node.M_HEIGHT;
    this.height = Node.HEIGHT;
    this.resize();
    if(this._owner.isCurrentToEdit(this) || this._owner.isInZoom(this)){
      g.setColor(this.bgcolor);
      g.fillRect(this.x - 3, this.y - 3, this.width + 6, this.height + 6);
      g.setColor("#000");
      g.drawOvalBorder(this.x, this.y, this.width, this.height, Node.PAD,this.bgcolor);
    }else{
      g.setColor("#000");
      g.drawOvalBorder(this.x, this.y, this.width, this.height, Node.PAD);
    }

    // Draw Image
    g.drawImage(this._img, this._imgrect.x, this._imgrect.y, this._imgrect.width, this._imgrect.height);

    // g.setColor(Resources.COLOR.lightGray);
    // g.fillRect(this._txtrect.x,this._txtrect.y,this._txtrect.width,10 + this._txtrect.height);
    // g.setColor(Resources.COLOR.black);
    // g.strokeRect(this._txtrect.x,this._txtrect.y,this._txtrect.width,10 + this._txtrect.height);

    if (this.name != null && this.name != "") {
      let nameWidthMax = g.stringWidth(this.name) > 86 ? 100 : g.stringWidth(this.name);
      const tx = this._txtrect.x + (this._txtrect.width - nameWidthMax) / 2;
      const ty = this._txtrect.y + 2 * this._txtrect.height;
      if (this._iscurrent) {
        // g.drawImage(Resources.IMG_CURRENT_NODE, this._txtrect.x,
        // this._txtrect.y, this._txtrect.width, 10 + this._txtrect.height);
      } else {
        // g.drawImage(Resources.IMG_BACKGROUND_NODE,
        // this._txtrect.x, this._txtrect.y, this._txtrect.width,
        // 		10 + this._txtrect.height);
      }
      g.setColor(Resources.COLOR.black);
      //g.font = "12px serif";
      // g.drawString(StringUtil.dencodeHTML(this.name), tx + this.name.length, ty - 10);
      g.drawText(StringUtil.dencodeHTML(this.name), tx + 10, ty - 10, 80);
    }

    // 恢复当前背景颜色
    this.bgcolor = old;
  }

  toXML() {
    var str = "<cn.myapps.runtime.workflow.element.SubFlow>\n";

    if (this.subFlowDefiType == "") this.subFlowDefiType = "01";
    str += "<subFlowDefiType>" + this.subFlowDefiType + "</subFlowDefiType>\n";
    str += "<subflowid>" + this.replaceCharacter(this.subflowid) + "</subflowid>\n";
    str += "<subflowname>" + this.replaceCharacter(this.subflowname) + "</subflowname>\n";
    str += "<subflowScript><![CDATA[" + this.replaceXML(this.subflowScript) + "]]></subflowScript>\n";
    str += "<paramPassingType>" + this.replaceCharacter(this.paramPassingType == "" ? "01" : this.paramPassingType) + "</paramPassingType>\n";
    str += "<parentFlowFormId>" + this.replaceCharacter(this.parentFlowFormId) + "</parentFlowFormId>\n";
    str += "<parentFlowFormName>" + this.replaceCharacter(this.parentFlowFormName) + "</parentFlowFormName>\n";
    str += "<subFlowFormId>" + this.replaceCharacter(this.subFlowFormId) + "</subFlowFormId>\n";
    str += "<subFlowFormName>" + this.replaceCharacter(this.subFlowFormName) + "</subFlowFormName>\n";
    if (this.fieldMappingXML.indexOf("<![CDATA[") != -1) {
      str += "<fieldMappingXML>" + this.replaceXML(this.fieldMappingXML) + "</fieldMappingXML>\n";
    } else {
      str += "<fieldMappingXML><![CDATA[" + this.replaceXML(this.fieldMappingXML) + "]]></fieldMappingXML>\n";
    }
    str += "<shareDocument>" + this.shareDocument + "</shareDocument>\n";
    str += "<paramPassingScript><![CDATA[" + this.replaceXML(this.paramPassingScript) + "]]></paramPassingScript>\n";
    str += "<numberSetingType>" + this.replaceCharacter(this.numberSetingType == "" ? "01" : this.numberSetingType) + "</numberSetingType>\n";
    str += "<numberSetingContent>" + this.replaceCharacter(this.numberSetingContent) + "</numberSetingContent>\n";
    str += "<callback>" + this.callback + "</callback>\n";
    str += "<callbackScript><![CDATA[" + this.replaceXML(this.callbackScript) + "]]></callbackScript>\n";
    str += "<iscurrent>" + this.iscurrent + "</iscurrent>\n";
    str += "<ispassed>" + this.ispassed + "</ispassed>\n";
    str += "<crossform>" + this.crossform + "</crossform>\n";
    str += "<startupScript><![CDATA[" + this.replaceXML(this.startupScript) + "]]></startupScript>\n";
    str += "<isgather>" + this.isgather + "</isgather>\n";
    str += "<splitStartNode>" + this.splitStartNode + "</splitStartNode>\n";
    str += "<issplit>" + this.issplit + "</issplit>\n";
    str += "<isToPerson>" + this.isToPerson + "</isToPerson>\n";
    str += "<checkedOnSinglePerson>" + this.checkedOnSinglePerson + "</checkedOnSinglePerson>\n";
    str += "<checkedOnMultiplePerson>" + this.checkedOnMultiplePerson + "</checkedOnMultiplePerson>\n";

    str += super.toXML();

    str += "</cn.myapps.runtime.workflow.element.SubFlow>\n";
    return str;
  }

  //xh
  check() {
    let result = super.check();
    //节点状态标签和名称填写校验
    if (!result) {
      return false;
    }
    //指定子流程校验
    if (this.subFlowDefiType) {
      if (this.subFlowDefiType == 1) {
        if (!this.subflowid || !this.subflowname) {
          alert("请为" + this.name + "节点指定子流程！");
          return false;
        }
      }

      if (this.subFlowDefiType == 2) {
        if (!this.subflowScript) {
          alert("请为" + this.name + "节点指定子流程脚本！");
          return false;
        }
      }
    } else {
      alert("请为" + this.name + "节点选择指定子流程的方式！");
      return false;
    }
    //子流程启动选项校验
    if (this.numberSetingType) {
      if (this.numberSetingType == 1) {
        if (Number(this.numberSetingContent) <= 0 || Number(this.numberSetingContent) % 1 != 0 || isNaN(Number(this.numberSetingContent))) {
          console.log(Number(this.numberSetingContent));
          alert("请为" + this.name + "节点在启动时填写预定义启动的实例数(实例数必须是正整数)！");
          return false;
        }
      }

      if (this.numberSetingType == 2) {
        if (!this.parentFlowFormId || !this.parentFlowFormName || this.numberSetingContent == "undefined" || this.numberSetingContent == "--select--") {
          alert("请为" + this.name + "节点在启动时选择父流程表单和父表单字段值(若没有选择的字段值则代表该父表单无字段)！");
          return false;
        }
      }

      if (this.numberSetingType == 3) {
        if (!this.numberSetingContent) {
          alert("请为" + this.name + "节点在启动时填写启动脚本！");
          return false;
        }
      }
    } else {
      alert("请为" + this.name + "节点选择启动实例数的方式");
      return false;
    }
    //聚合选项校验
    if (this.isgather) {
      if (!this.splitStartNode) {
        alert("请为" + this.name + "节点选择聚合审批节点(若选择聚合选项，则流程中至少要有一个节点开启并行)！");
        return false;
      }
    }
    //流程等待校验
    if (this.callback) {
      if (!this.callbackScript) {
        alert("请为" + this.name + "节点在流程等待里填写流程回调时执行的iscript脚本！");
        return false;
      }
    }

    return true;
  }

  //xh
  hasRelation(relation) {
    let { input, output } = super.hasRelation(relation);

    if (input == 0 && output == 0) {
      alert("请创建" + this.name + "节点的关联线！");
      return false;
    } else if (output > 0 && input == 0) {
      alert(this.name + "节点缺少接入节点！");
      return false;
    } else if (input > 0 && output == 0) {
      alert("请为" + this.name + "节点连接其他节点！");
      return false;
    } else {
      return true;
    }
  }

  // yx
  hasSomeRelation (relation) {
    return super.hasRelation(relation)
  }

  showTips(g) {
    let tips = "";
    if (this.subflowname != null && !this.subflowname.trim() == "" && !this.subflowname.trim() == "null") {
      tips += "子流程名称：" + this.subflowname;
      tips += "\n";
    }
    this.drawTips(g, tips);
  }

  getSubelems() {
    return this._subelems;
  }

  /**
   * 获取子流程参数映射信息
   * @return
   * @throws Exception
   */
  getFieldMappingInfo() {
    if (PARAM_PASSING_SHARE == paramPassingType || fieldMappingXML == "" || fieldMappingXML == null) return null;

    return XmlUtil.toOjbect(fieldMappingXML);
  }
}

/**
 * 子流程绑定方式-自定义值
 */
SubFlow.SUBFLOW_DEFINITION_CUSTOM = "01";
/**
 * 子流程绑定方式-脚本返回值
 */
SubFlow.SUBFLOW_DEFINITION_SCRIPT = "02";
/**
 * 参数传递方式-共享父流程文档
 */
SubFlow.PARAM_PASSING_SHARE = "01";

/**
 * 参数传递方式-表单映射
 */
SubFlow.PARAM_PASSING_MAPPING = "02";

/**
 * 参数传递方式-脚本
 */
SubFlow.PARAM_PASSING_SCRIPT = "03";

/**
 * 实例启动次数设置方式-预定义值
 */
SubFlow.NUMBER_SETING_CUSTOM = "01";

/**
 * 实例启动次数设置方式-父流程表单字段值
 */
SubFlow.NUMBER_SETING_FIEDL = "02";

/**
 * 实例启动次数设置方式-脚本返回值
 */
SubFlow.NUMBER_SETING_SCRIPT = "03";

/**
 * 实例启动次数设置方式-审批人分组总数
 */
SubFlow.NUMBER_SETING_GROUP_TOTAL = "04";

export default SubFlow;
