import AbstractField from "./AbstractField";
import { Sequence } from "../../utility";

class HtmleditorField extends AbstractField{
    constructor(container) {
        super();
        this.scope="htmleditorField"
        this.container = container;
        this.htmlDOM=null;
        
        this.className="baseField";
        this.propValues.id = Sequence.createUuid();
        this.html=`<div style="padding: 5px 0;line-height: 20px;color: #3d464d;font-weight: 600;">
        <span  class="baseLabel-title" style="font-size: 14px;color: #3d464d;">HTML编辑器</span>
        </div><div class="baseCon fieldId" fieldid='${this.propValues.id}' style="height: 30px;">
        <img src="images/htmleditorField.png"/></div>`;
        this.propValues.name="HTML编辑器"+window.formApp.formPanel.propValues.nameIndex;
        this.propValues.calculateonrefresh = false; //重计算
        this.propValues.mobile = true; //手机可用
        this.propValues.discript="";
        this.propValues.editProp="editHtmleditorField";

        this.propValues.editmode = "01"; //值的方式
        this.propValues.valuescript = ""; //脚本值
        this.propValues.processdescription = ""; //值设计脚本的值
        this.propValues.processprevalue = []; //用来存储选中的值设计的字段值
        this.propValues.filtercondition = "";//用来存储设计时的脚本(部分写死)
        this.propValues.isdefaultvalue = false; //仅创建时计算
        this.propValues.hiddenscript = ""; //隐藏条件脚本
        this.propValues.hiddenvalue = ""; //隐藏时显示值
        this.propValues.hiddenprintscript = ""; //打印时隐藏条件脚本
        this.propValues.printhiddenvalue = ""; //打印隐藏时显示值
        this.propValues.readonlyscript = ""; //只读条件脚本

        this.propValues.areawidth="";//宽
        this.propValues.areaheight="";//高
        this.propValues.fieldtype="VALUE_TYPE_TEXT";
        
    }
    getPropsDesc() {
        return {
            "base":['myselfrows','name','areawidth','areaheight','calculateonrefresh','mobile','discript'],
            "value":['editmode','isdefaultvalue','valuescript','processdescription'],            
            "hidden":['hiddenscript','hiddenvalue'],
            "hiddenprint":["hiddenprintscript","printhiddenvalue"],
            "readonly":['readonlyscript']
            

        }
    }
    
}
export default HtmleditorField;