import Node from "./Node";
import FlowDiagram from "./FlowDiagram";
import PaintElement from "./PaintElement";
import Rectangle from "../utility/Rectangle";
import Resources from "../utility/Resources";
import StringUtil from "../utility/StringUtil";

class StartNode extends Node {
  constructor(diagram) {
    super(diagram);
  }

  getClassName() {
    return "cn.myapps.runtime.workflow.element.StartNode";
  }

  paint(g) {
    if (this._img == null) {
      this._img = Resources.IMG_START_NODE;
    }

    // Call All Sub Elements PAINT METHOD.
    // 保存当前背景颜色...
    let old = this.bgcolor;

    // yx 判断Ctrl数组是否有值
    if(this._owner.checkSelectArr()){
      // yx 判断是否在ctrl数据中
      if(this._owner.isInZoom(this)){
        this.bgcolor = PaintElement.DEF_CURREDITCOLOR;
      }
    }else{
      if (this._owner.isCurrentToEdit(this)) {
        this.bgcolor = PaintElement.DEF_CURREDITCOLOR;
      }
  
      if (this._owner.isCurrentSelected(this)) {
        this.bgcolor = PaintElement.DEF_SELECTEDCOLOR;
      }
    }

    for (let i = 0; i < this._subelems.length; i++) {
      let te = this._subelems[i];
      if (te instanceof PaintElement) {
        let se = te;
        se.paint(g);
      }
    }

    // Fill background
    this.width = Node.M_WIDTH;
    this.m_width = Node.M_WIDTH;
    this.m_height = Node.M_HEIGHT;
    this.height = Node.M_HEIGHT;
    this.resize();
    g.setColor(this.bgcolor);
    g.fillRect(this.x - 3, this.y - 2, this.m_width + 2, this.height + 2);
    // g.setColor("#000");
    // g.drawOvalBorder(this.x, this.y, this.width + Node.PAD * 3, this.height, Node.PAD);


    // Draw Image
    g.drawImage(this._img, this.x, this.y, this._imgrect.width, this._imgrect.height);

    // g.setColor(Resources.COLOR.lightGray);
    // g.fillRect(this._txtrect.x,this._txtrect.y,this._txtrect.width,10 + this._txtrect.height);
    // g.setColor(Resources.COLOR.black);
		// g.strokeRect(this._txtrect.x,this._txtrect.y,this._txtrect.width,10 + this._txtrect.height);
		
		// yx 给节点添加默认名称
		if(this.name == '' || this.name == null){
			this.name = '开始'
		}

    if (this.name != null && this.name != "") {
			// yx 判断字体过多是绘画是否一直在中间
      let tx = this._txtrect.x;
			const ty = this._txtrect.y + 1.5 * this._txtrect.height;

      if (this._iscurrent) {
        // g.drawImage(Resources.IMG_CURRENT_NODE, this._txtrect.x,
        // this._txtrect.y, this._txtrect.width, 10 + this._txtrect.height);
      } else {
        // g.drawImage(Resources.IMG_BACKGROUND_NODE,
        // this._txtrect.x, this._txtrect.y, this._txtrect.width,
        // 		10 + this._txtrect.height);
      }

      g.setColor(Resources.COLOR.black);
      // g.drawString(StringUtil.dencodeHTML(this.name), tx + this.name.length, ty - 10);
      if(g.stringWidth(this.name) > 24){
        g.drawText(StringUtil.dencodeHTML(this.name), tx - 8, ty - 18, 20);
      }else{
        g.drawText(StringUtil.dencodeHTML(this.name), tx - 8, ty - 10, 20);
      }
    }

    // 恢复当前背景颜色
    this.bgcolor = old;
  }

  toXML(fieldName, fields) {
    let str = "<cn.myapps.runtime.workflow.element.StartNode>\n";
    str += super.toXML();
    str += "</cn.myapps.runtime.workflow.element.StartNode>\n";
    return str;
  }

  //xh
  // 验证器
  check() {
    let result = super.check();

    if (!result) {
      return false;
    }

    return true;
  }

  //xh
  hasRelation(relation) {
    let { input, output } = super.hasRelation(relation);

    if (output == 0) {
      alert("请创建" + this.name + "节点的关联线！");
      return false;
    } else if (input > 0) {
      alert("不能有其他节点指向" + this.name + "节点！");
      return false;
    } else {
      return true;
    }
  }

  // yx
  hasSomeRelation (relation) {
    return super.hasRelation(relation)
  }

  showTips(g) {
    this.drawTips(g, this.name);
  }
}

export default StartNode;
