import ReportElement from './ReportElement';
import {Sequence, Archor} from '../../utility';

class Line extends ReportElement {
	constructor() {
		super();
		this.direction = 'TopTop';
		this.belong = '';
		this.isOpenArchor = false;
		this.height=1;
		// this.lineWidth=1;
		// this.lineStyle="Solid";
		// this.lineColor="#000";
		this.directionOption={
			"TopTop":true,
			"TopBottom":false,
			"TopDown":false,
			"BottomUp":false,
		}
		// this.lineStyleOption={
		// 	"Solid":true,
		// 	"Dashed":false,
		// 	"Dotted":false,
		// 	"Double":false,
		// }
		this.key="斜线"
	}
	
	getClassName() {
		return 'line';
	}
	
	getNodeConfigInfo() {
		let node = {};
		node.text = this.key==""?this.text:this.key;
			// `(${parseInt(this.x)}, ${parseInt(this.printedY)})`;
		node.icon = 'glyphicon glyphicon-pushpin';
		node.uuid = this.getProp('id');	
		node.instance = this;
		return node;
	}

	/**
	 * @param g
	 */
	paint(g) {
		let that=this;
		if(this.height<1){
			this.height=1;
			this.direction="TopTop";
		}
		if(this.width<1){
			this.width=1;
			this.direction="TopBottom";
		}
		// if(this.height>1 || this.height>1){
		// 	this.direction="TopDown";
		// }
		if(this.direction=="TopTop"&&this.height!=1){
			this.height=1;
			this.width=100;
		}
		if(this.direction=="TopBottom"&&this.width!=1){
			this.width=1;
			this.height=24;
		}
		if(this.direction=="TopDown"&&this.height==1 || this.direction=="TopDown"&&this.width==1 ){
			this.height=24;
			this.width=100;
		}
		if(this.direction=="BottomUp"&&this.height==1 || this.direction=="BottomUp"&&this.width==1 ){
			this.height=24;
			this.width=100;
		}
		if(this.lineWidth<0){
			this.lineWidth=0;
		}
		if(!this.id) {
			this.id = Sequence.createUuid();
		}
		
		g.save();	
		g.setColor('#000000');
		g.setLineWidth(0.5);
		g.drawRect(this.x, this.y, this.width, this.height);

		g.setColor(this.forecolor);
		// if(this.lineStyle!="Solid" || this.lineWidth!=1 ){
		// 	g.setLineStyle(this.lineWidth,this.lineStyle);
		// }
		if(this.direction == 'TopDown')	{
			g.drawLineEle(this.x, this.y, this.x + this.width, this.y + this.height,this.lineWidth,this.lineStyle,this.lineColor);
		} else if(this.direction == 'BottomUp') {
			g.drawLineEle(this.x + this.width, this.y, this.x, this.y + this.height,this.lineWidth,this.lineStyle,this.lineColor);
		} else if(this.direction == 'TopTop'){
			g.drawLineEle(this.x,this.y,this.x+this.width,this.y,this.lineWidth,this.lineStyle,this.lineColor);
		}else if(this.direction == 'TopBottom'){
			g.drawLineEle(this.x,this.y,this.x,this.y+this.height,this.lineWidth,this.lineStyle,this.lineColor);
		}else{
			g.drawLineEle(this.x,this.y,this.x+this.width,this.y,this.lineWidth,this.lineStyle,this.lineColor);
		}

		g.setLineStyle();
		if(this.error){
			let img=new Image();
			img.src=this.errorImgSrc;
			img.onload=function(){
				g.drawImage(img,that.x,that.y,15,15);
			}

		}
		g.restore();
		
		if(this.isOpenArchor) {
			const archor = Archor.getInstance();
			const openArchor = [{x: 0, y: 0}, {x: 1, y: 0}, {x: 1, y: 1}, {x: 0, y: 1}]; //以当前元素左上角为坐标系，得(0, 0)为左上角，依次类推
			const params = {x: this.x, y: this.y, targetW: this.width, targetH: this.height, openArchorPos: openArchor};
			
			archor.setProps(params);	
			archor.paint(g);
		}
	}
	
	toXML() {
		let str = '<line ';
		if(this.direction == 'TopDown' || this.direction == 'BottomUp' ){
			str += `direction = "${this.direction}" `;
		}
		str += '>\n';
		str += super.toXML();
		str +='<graphicElement>\n';

		str +=`<pen lineWidth="${this.lineWidth}" `

		str +=`lineStyle="${this.lineStyle}" `
		str +=`lineColor="${this.lineColor}"`
		str +=`/>\n`
		str +=`</graphicElement>\n`
		str += '</line>\n';
		
		return str;
	}
	
	parseXML(xmlNode) {
		let props = {};
		let that=this;
		
		const traversalNode = (xmlNode) => {
			//console.log(xmlNode);
			const { tagName } = xmlNode;
			//console.log(tagName);

			switch (tagName) {
				case 'reportElement':
					if(xmlNode.getAttribute("width")=="1"){
						props.direction="TopBottom"
					}
					if(xmlNode.getAttribute("height")=="1"){
						props.direction="TopTop"
					}
					if(!props.direction){
						props.direction="TopDown"
					}
					const reportElement = this.handleReportElement(xmlNode);
					Object.assign(props, reportElement);
					break;
				case 'graphicElement':
					const children=xmlNode.children;
					if(children.length>0){
						that.lineWidth = parseInt(children[0].getAttribute('lineWidth'));
						that.lineStyle = children[0].getAttribute('lineStyle');
						that.lineColor = children[0].getAttribute('lineColor');
					}

					break;
				default:
					break;
			}
		};
		
		if(xmlNode.hasChildNodes() && xmlNode.tagName == 'line') {
			props.direction = xmlNode.getAttribute('direction') ? xmlNode.getAttribute('direction') : "";
			
			for(let i = 0;i < xmlNode.children.length;i++) {
				traversalNode(xmlNode.children[i]);
			}
		}

		this.setProps(props);

		return props;
	}
	
	// showTips(g) {
		// let tips = '';
		// tips += this.text;
		// this.drawTips(g, tips);
	// }
}

Line.DEF_DIRECTION = 'TopDown';

export default Line;