package com.bcxin.tenant.domain.snapshots;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;
import org.springframework.util.CollectionUtils;

import java.io.Serializable;
import java.util.Collection;

@Data
public class DepartmentImportedResultSnapshot implements Serializable {
    private Collection<DepartmentImportedItemResultSnapshot> data;

    public DepartmentImportedResultSnapshot(){}

    public DepartmentImportedResultSnapshot(Collection<DepartmentImportedItemResultSnapshot> data) {
        this.data = data;
    }

    @JsonIgnore
    public int getTotalSuccess() {
        if (CollectionUtils.isEmpty(data)) {
            return 0;
        }

        return (int) data.stream().filter(ii -> ii.getIsSuccess()).count();
    }

    @JsonIgnore
    public int getTotalFailed() {
        if (CollectionUtils.isEmpty(data)) {
            return 0;
        }

        return (int) data.stream().filter(ii -> !ii.getIsSuccess()).count();
    }

    public static DepartmentImportedResultSnapshot create(Collection<DepartmentImportedItemResultSnapshot> data) {
        return new DepartmentImportedResultSnapshot(data);
    }
}
