package com.bcxin.tenant.domain.services.impls;

import com.bcxin.tenant.domain.entities.TenantEventEntity;
import com.bcxin.tenant.domain.repositories.TenantEventRepository;
import com.bcxin.tenant.domain.services.TenantEventService;
import com.bcxin.tenant.domain.services.commands.CreateTenantEventCommand;
import com.bcxin.tenant.domain.services.commands.events.ProcessedEventCommand;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TenantEventServiceImpl implements TenantEventService {
    private final TenantEventRepository tenantEventRepository;

    public TenantEventServiceImpl(TenantEventRepository tenantEventRepository) {
        this.tenantEventRepository = tenantEventRepository;
    }

    @Transactional
    @Override
    public void create(CreateTenantEventCommand command) {
        TenantEventEntity event = TenantEventEntity.create(
                command.getEventAction(),
                command.getKeyword(),
                command.getContent());

        this.tenantEventRepository.save(event);
    }

    @Override
    public void dispatch(ProcessedEventCommand command) {

    }
}
