package com.bcxin.tenant.domain.services.commands.tenantUsers;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import lombok.Getter;
import org.springframework.util.StringUtils;

@Getter
public class UpdateUserNickHeadPhotoCommand extends CommandAbstract {
    private final String id;
    private final String nick;
    private final String headPhoto;

    public UpdateUserNickHeadPhotoCommand(String id, String nick, String headPhoto) {
        this.id = id;
        this.nick = nick;
        this.headPhoto = headPhoto;
    }

    public static UpdateUserNickHeadPhotoCommand create(String id, String nick, String headPhoto) {
        return new UpdateUserNickHeadPhotoCommand(id, nick, headPhoto);
    }

    @Override
    public void validate() {
        if (!StringUtils.hasLength(this.getId())) {
            throw new ArgumentTenantException("Id不能为空");
        }
    }
}
