package com.bcxin.tenant.domain.services.commands.tenantUsers;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import lombok.Getter;
import org.springframework.util.StringUtils;

@Getter
public class TenantUserExtensionCommand extends CommandAbstract {
    /**
     * 拓展信息的key
     */
    private final String extensionKey;
    /**
     * 拓展信息的value
     */
    private final String extensionValue;

    public TenantUserExtensionCommand(String extensionKey, String extensionValue) {
        this.extensionKey = extensionKey;
        this.extensionValue = extensionValue;
    }

    public static TenantUserExtensionCommand create(String extensionKey, String extensionValue) {
        return new TenantUserExtensionCommand(extensionKey, extensionValue);
    }

    @Override
    public void validate() {
        if (!StringUtils.hasLength(this.getExtensionKey())) {
            throw new ArgumentTenantException("拓展信息的key不能为空");
        }
    }
}
