package com.bcxin.tenant.domain.services.commands.tenantUsers;

import com.bcxin.Infrastructures.TenantContext;
import com.bcxin.Infrastructures.TenantUserContext;
import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.api.interfaces.tenants.requests.tenantUsers.PlatformResetAuthenticateStatusRequest;
import com.bcxin.api.interfaces.tenants.requests.tenantUsers.PlatformResetPasswordRequest;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

@Getter
public class PlatformResetPasswordCommand extends CommandAbstract {

    //当前登录的用户id
    private final String tenantUserId;

    //当前登录的职员id
    private final String employeeId;

    //被操作的用户id
    private final String operateUserId;

    //IP地址
    private final String ipAddress;

    public PlatformResetPasswordCommand(String tenantUserId, String employeeId, String operateUserId, String ipAddress) {
        this.tenantUserId = tenantUserId;
        this.employeeId = employeeId;
        this.operateUserId = operateUserId;
        this.ipAddress = ipAddress;
    }

    public static PlatformResetPasswordCommand create(PlatformResetPasswordRequest request) {
        return new PlatformResetPasswordCommand(request.getTenantUserId(), request.getEmployeeId(), request.getOperateUserId(),
                request.getIpAddress());
    }

    public void validate() {
        if (StringUtils.isBlank(this.getTenantUserId())) {
            throw new ArgumentTenantException("当前登录的用户id不能为空");
        }
        TenantUserContext.UserModel userModel = TenantContext.getInstance().getUserContext().get();
        if (!userModel.getId().equals(this.getTenantUserId())) {
            throw new ArgumentTenantException("当前登录的用户id和所传参数不一致");
        }
        if (StringUtils.isBlank(this.getEmployeeId())) {
            throw new ArgumentTenantException("当前登录的职员id不能为空");
        }

        if (StringUtils.isBlank(this.getOperateUserId())) {
            throw new ArgumentTenantException("被操作的用户id不能为空");
        }
    }
}
