package com.bcxin.tenant.domain.services.commands.organizations;

import com.bcxin.api.interfaces.tenants.requests.organizations.LocationRequest;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * @author linqinglin
 * @date 2021/12/09 0009 13:47
 */
@Getter
public class LocationCommandItem {

    /**
     * 省份
     */
    private final ItemValueCommandItem province;

    /**
     * 城市
     */
    private final ItemValueCommandItem city;

    /**
     * 区域
     */
    private final ItemValueCommandItem district;

    /**
     * 详细地址
     */
    private final String address;

    public LocationCommandItem(ItemValueCommandItem province,
                               ItemValueCommandItem city,
                               ItemValueCommandItem district,
                               String address) {
        this.province = province;
        this.city = city;
        this.district = district;
        this.address = address;
    }

    public static LocationCommandItem create(ItemValueCommandItem province,
                                             ItemValueCommandItem city,
                                             ItemValueCommandItem district,
                                             String address) {
        return new LocationCommandItem(province, city, district, address);
    }

    public static LocationCommandItem create(LocationRequest locationRequest) {
        if (locationRequest != null && locationRequest.getProvince() != null && locationRequest.getCity() != null && locationRequest.getDistrict() != null) {
            return new LocationCommandItem(ItemValueCommandItem.create(locationRequest.getProvince().getCode(), locationRequest.getProvince().getName()),
                    ItemValueCommandItem.create(locationRequest.getCity().getCode(), locationRequest.getCity().getName()),
                    ItemValueCommandItem.create(locationRequest.getDistrict().getCode(), locationRequest.getDistrict().getName()),
                    locationRequest.getAddress());
        }
        return null;
    }

    private static final LocationCommandItem emptyValue = new LocationCommandItem(
            ItemValueCommandItem.createEmpty(),
            ItemValueCommandItem.createEmpty(),
            ItemValueCommandItem.createEmpty(),
            null
    );
    public static LocationCommandItem  createEmpty() {
        return emptyValue;
    }

    public String getRegionCode() {
        if (this.getProvince() == null || StringUtils.isBlank(this.getProvince().getCode())) {
            return null;
        }
        StringBuffer sb = new StringBuffer(this.getProvince().getCode());
        if (this.getCity() != null && StringUtils.isNotBlank(this.getCity().getCode())) {
            sb.append(this.getCity().getCode());
        }
        if (this.getDistrict() != null && StringUtils.isNotBlank(this.getDistrict().getCode())) {
            sb.append(this.getDistrict().getCode());
        }
        return sb.toString();
    }
}
