package com.bcxin.tenant.domain.services.commands.organizationrelationship;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import lombok.Getter;

@Getter
public class OrganizationRelationshipInfoUpdateCommand extends CommandAbstract {
    private long id;
    private String organizationNote;
    private Long organizationTypeId;
    private String parentId;
    private String parentName;
    private String parentIndex;
    private String code;
    private String contactName;
    private String contactTelephone;

    private String organizationId;

    public OrganizationRelationshipInfoUpdateCommand(long id, String organizationNote, Long organizationTypeId, String parentId, String parentName, String parentIndex, String code, String contactName, String contactTelephone, String organizationId) {
        this.id = id;
        this.organizationNote = organizationNote;
        this.organizationTypeId = organizationTypeId;
        this.parentId = parentId;
        this.parentName = parentName;
        this.parentIndex = parentIndex;
        this.code = code;
        this.contactName = contactName;
        this.contactTelephone = contactTelephone;
        this.organizationId = organizationId;
    }

    public static OrganizationRelationshipInfoUpdateCommand create(long id,
                                                                   String organizationNote,
                                                                   Long organizationTypeId,
                                                                   String parentId,
                                                                   String parentName,
                                                                   String parentIndex,
                                                                   String code,
                                                                   String contactName,
                                                                   String contactTelephone,
                                                                   String organizationId) {
        return new OrganizationRelationshipInfoUpdateCommand(id,
                organizationNote,
                organizationTypeId,
                parentId,
                parentName,
                parentIndex,
                code,
                contactName,
                contactTelephone,
                organizationId);
    }
}
