package com.bcxin.tenant.domain.services.commands.externalMembers;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.enums.ApprovedStatus;
import com.bcxin.Infrastructures.enums.ResourceReferenceType;
import lombok.Getter;

import java.util.Collection;

@Getter
public class UpdateExternalMemberCommand extends CommandAbstract {

    private final ResourceReferenceType referenceType;

    private final String referenceNumber;

    private final Collection<String> ids;

    private final Collection<String> addGroupIds;

    private final String operatorId;

    private final String operatorName;


    public UpdateExternalMemberCommand(ResourceReferenceType referenceType, String referenceNumber,
                                       Collection<String> ids, Collection<String> addGroupIds,
                                       String operatorId, String operatorName) {
        this.referenceType = referenceType;
        this.referenceNumber = referenceNumber;
        this.ids = ids;
        this.addGroupIds = addGroupIds;
        this.operatorId = operatorId;
        this.operatorName = operatorName;
    }

    public static UpdateExternalMemberCommand create(ResourceReferenceType referenceType, String referenceNumber,
                                                     Collection<String> ids, Collection<String> addGroupIds,

                                                     String operatorId, String operatorName){
        return new UpdateExternalMemberCommand(referenceType,referenceNumber,ids,addGroupIds,operatorId,operatorName);
    }
}
