package com.bcxin.tenant.domain.services.commands.externalMembers;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.enums.ResourceReferenceType;
import lombok.Getter;

import java.util.Collection;

@Getter
public class DeleteExternalMemberCommand extends CommandAbstract {
    private final Collection<String> ids;
    private final String operatorId;

    private final String operatorName;

    private final ResourceReferenceType referenceType;

    private final String referenceNumber;

    public DeleteExternalMemberCommand(ResourceReferenceType referenceType, String referenceNumber,
                                       Collection<String> ids, String operatorId, String operatorName) {
        this.referenceType = referenceType;
        this.referenceNumber = referenceNumber;
        this.ids = ids;
        this.operatorId = operatorId;
        this.operatorName = operatorName;
    }

    public static DeleteExternalMemberCommand create(ResourceReferenceType referenceType, String referenceNumber, Collection<String> ids, String operatorId, String operatorName){
        return new DeleteExternalMemberCommand(referenceType,referenceNumber,ids,operatorId,operatorName);
    }
}
