package com.bcxin.tenant.domain.services.commands.externalGroups;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.enums.ResourceReferenceType;
import lombok.Getter;

@Getter
public class DeleteExternalGroupCommand extends CommandAbstract {
    private final String id;
    private final String operatorId;

    private final ResourceReferenceType referenceType;

    private final String referenceNumber;

    public DeleteExternalGroupCommand(ResourceReferenceType referenceType, String referenceNumber,String id, String operatorId) {
        this.referenceType = referenceType;
        this.referenceNumber = referenceNumber;
        this.id = id;
        this.operatorId = operatorId;
    }

    public static DeleteExternalGroupCommand create(ResourceReferenceType referenceType,String referenceNumber,String id, String operatorId) {
        return new DeleteExternalGroupCommand(referenceType, id, operatorId, referenceNumber);
    }
}
