package com.bcxin.tenant.domain.services.commands.contracts;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.tenant.domain.entities.ContractEntity;
import lombok.Getter;
import org.springframework.util.StringUtils;

import java.util.Date;
import java.util.List;

@Getter
public class UpdateContractCommand extends CommandAbstract {
    private final String organizationId;
    private final String id;
    private final String name;
    private final String aName;
    private final String bName;
    private final Date beginDate;
    private final Date endDate;
    private final boolean isDateLimitless;
    private final String attachment;
    private final String note;

    public UpdateContractCommand(String organizationId,String id, String name, String aName, String bName,
                                 Date beginDate, Date endDate, boolean isDateLimitless,
                                 String attachment, String note) {
        this.organizationId = organizationId;
        this.id = id;
        this.name=name;
        this.aName = aName;
        this.bName = bName;
        this.beginDate = beginDate;
        this.endDate = endDate;
        this.isDateLimitless = isDateLimitless;
        this.attachment = attachment;
        this.note = note;
    }

    public static UpdateContractCommand create(String organizationId,String id, String name, String aName, String bName,
                                               Date beginDate, Date endDate, boolean isDateLimitless,
                                               String attachment, String note) {
        return new UpdateContractCommand(organizationId, id, name, aName, bName, beginDate, endDate, isDateLimitless, attachment, note);
    }

    @Override
    public void validate() {
        super.validate();

        if (!StringUtils.hasLength(this.getName())) {
            throw new ArgumentTenantException("合同名称不能为空");
        }

        if (!StringUtils.hasLength(this.getAName())) {
            throw new ArgumentTenantException("甲方名称不能为空");
        }

        if (!StringUtils.hasLength(this.getBName())) {
            throw new ArgumentTenantException("乙方名称不能为空");
        }

        if (this.getBeginDate() == null) {
            throw new ArgumentTenantException("合同开始时间不能为空");
        }

        if (this.isDateLimitless() == false) {
            if (this.getEndDate() == null) {
                throw new ArgumentTenantException("合同结束时间不能为空");
            } else if (this.getEndDate().before(this.getBeginDate())) {
                throw new ArgumentTenantException("合同结束时间不能早于开始时间");
            }
        }

        if (!StringUtils.hasLength(this.getAttachment())) {
            throw new ArgumentTenantException("电子合同文件不能为空");
        }
    }

    public void validateExist(String id,List<ContractEntity> contractList){
        if(contractList == null || contractList.size() == 0){
            return;
        }
        if(contractList.stream().anyMatch(ii -> !ii.getId().equals(id) && ((this.getBeginDate().getTime() <= ii.getBeginDate().getTime()
                && this.getEndDate().getTime() >= ii.getBeginDate().getTime())
                || (this.getBeginDate().getTime() <= ii.getEndDate().getTime()
                && this.getEndDate().getTime() >= ii.getEndDate().getTime())
                || (ii.getBeginDate().getTime() <= this.getBeginDate().getTime()
                && ii.getEndDate().getTime() >= this.getBeginDate().getTime())
                || (ii.getBeginDate().getTime() <= this.getEndDate().getTime()
                && ii.getEndDate().getTime() >= this.getEndDate().getTime())
        ))){
            throw new ArgumentTenantException("在合同有效期内同一个人只能有一份合同");
        }
    }
}
