package com.bcxin.tenant.domain.services.commands;

import cn.hutool.core.util.PhoneUtil;
import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.enums.Sex;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.api.interfaces.tenants.requests.organizations.LocationRequest;
import lombok.Getter;
import org.springframework.util.StringUtils;

import java.util.Date;

@Getter
public class UpdateTenantUserCommand extends CommandAbstract {
    private final String id;
    private final String headPhoto;
    private final Sex sex;
    private final String nation;
    private final String workYear;
    private final String diseasesHistory;
    private final String politicsStatus;
    private final String stature;
    private final String militaryStatus;
    private final Date birthdate;
    private final String education;
    private final String householdType;
    private final String nativePlace;
    private final String maritalStatus;
    private final String email;
    private final String emergencyContact;

    /**
     * 紧急联系人电话
     */
    private final String emergencyPhone;

    /**
     * 驾照等级
     */
    private final String licenseLevel;

    /**
     * 现住地址
     */
    private final LocationRequest placeOfNow;


    @Override
    public void validate() {
        if (!StringUtils.hasLength(this.getId())) {
            throw new ArgumentTenantException("id不能为空");
        }

        if (StringUtils.hasLength(this.getEmergencyPhone())) {
            if (!PhoneUtil.isPhone(this.getEmergencyPhone()) && !PhoneUtil.isTel(this.getEmergencyPhone())) {
                throw new ArgumentTenantException("紧急联系人电话格式不正确");
            }
        }
    }

    public UpdateTenantUserCommand(String id, String headPhoto, Sex sex,
                                   String nation,String diseasesHistory,String workYear, String politicsStatus,
                                   String stature, String militaryStatus,
                                   Date birthdate,
                                   String education, String householdType,
                                   String nativePlace,
                                   String maritalStatus, String email,
                                   String emergencyContact,
                                   String emergencyPhone,
                                   String licenseLevel,
                                   LocationRequest placeOfNow) {
        this.id = id;
        this.headPhoto = headPhoto;
        this.sex = sex;
        this.nation = nation;
        this.diseasesHistory = diseasesHistory;
        this.workYear = workYear;
        this.politicsStatus = politicsStatus;
        this.stature = stature;
        this.militaryStatus = militaryStatus;
        this.birthdate = birthdate;
        this.education = education;
        this.householdType = householdType;
        this.nativePlace = nativePlace;
        this.maritalStatus = maritalStatus;
        this.email = email;
        this.emergencyContact = emergencyContact;
        this.emergencyPhone = emergencyPhone;
        this.licenseLevel = licenseLevel;
        this.placeOfNow = placeOfNow;
    }

    public static UpdateTenantUserCommand create(String id, String headPhoto, Sex sex,
                                                 String nation,String diseasesHistory,String workYear, String politicsStatus,
                                                 String stature, String militaryStatus, Date birthdate,
                                                 String education, String householdType, String nativePlace,
                                                 String maritalStatus, String email,
                                                 String emergencyContact,
                                                 String emergencyPhone,
                                                 String licenseLevel,
                                                 LocationRequest placeOfNow) {
        return new UpdateTenantUserCommand(id, headPhoto, sex, nation,diseasesHistory,workYear, politicsStatus, stature, militaryStatus,
                birthdate, education, householdType, nativePlace, maritalStatus, email,
                emergencyContact,
                emergencyPhone,
                licenseLevel,
                placeOfNow);
    }
}
