package com.bcxin.tenant.domain.services.commands;

import cn.hutool.core.util.IdcardUtil;
import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.enums.OccupationType;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import com.bcxin.Infrastructures.utils.AuthUtil;
import com.bcxin.Infrastructures.validations.CredentialValidator;
import com.bcxin.tenant.domain.entities.EmployeeEntity;
import lombok.Getter;
import org.springframework.util.StringUtils;

import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import java.util.List;

@Getter
public class ChangeEmployeeOccupationTypeRequestCommand extends CommandAbstract {

    private final String organizationId;
    /**
     * 员工id
     */
    private final String employeeId;
    /**
     * 职业: 保安员, 其他
     */
    @Enumerated(EnumType.ORDINAL)
    private final OccupationType occupationType;

    public ChangeEmployeeOccupationTypeRequestCommand(String organizationId,String employeeId, OccupationType occupationType) {
        this.organizationId = organizationId;
        this.employeeId = employeeId;
        this.occupationType = occupationType;
    }

    public static ChangeEmployeeOccupationTypeRequestCommand create(String organizationId,String employeeId, OccupationType occupationType) {
        return new ChangeEmployeeOccupationTypeRequestCommand(organizationId,employeeId, occupationType);
    }

    @Override
    public void validate() {
        if (!StringUtils.hasLength(this.getEmployeeId())) {
            throw new BadTenantException("员工id不能为空");
        }

        if (this.getOccupationType() == null) {
            throw new BadTenantException("职业类型不能为空");
        }
    }
}
