package com.bcxin.tenant.domain.services.commands;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import lombok.Getter;

import java.util.Collection;

@Getter
public class BatchMoveDepartEmployeeCommand extends CommandAbstract {
    private final Collection<String> fromDepartIds;
    private final String destDepartId;
    private final String organizationId;

    public BatchMoveDepartEmployeeCommand(String organizationId, Collection<String> fromDepartIds, String destDepartId) {
        this.fromDepartIds = fromDepartIds;
        this.destDepartId = destDepartId;
        this.organizationId = organizationId;
    }

    public static BatchMoveDepartEmployeeCommand create(String organizationId, Collection<String> fromDepartIds, String destDepartId) {
        return new BatchMoveDepartEmployeeCommand(organizationId, fromDepartIds, destDepartId);
    }
}
